/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef HITMENUITEM_H
#define HITMENUITEM_H

#include <qmenudata.h>
#include <qpixmap.h>

class HitMenuItem : public QObject, public QCustomMenuItem {
Q_OBJECT
private:
    QPixmap icon;
    QString text;
    QString uri;
    QFont font;
public slots:
    void open();
public:
    HitMenuItem(const QPixmap&, const QString&, const QString&uri);
    void paint( QPainter* p, const QColorGroup& cg, bool act, bool enabled,
        int x, int y, int w, int h );
    QSize sizeHint();
    bool fullSpan() { return true; }
    void setFont(const QFont& f) { font = f; }
};

#endif
