from unittest import makeSuite

from base import SquishdotBase

from re import search
from string import index
from DateTime import DateTime

class PostingTests(SquishdotBase):

    def testAddArticle(self):
        "Check the SquishSite.addPosting method works"
        
        id = self._addPosting(title    = 'testSquishSiteAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain',
                              subject  = 'test subject',
                              summary  = 'summary',
                              dept     = 'dept')
        
        Posting = self.Site[id]
        
        assert Posting.title    =='testSquishSiteAddPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        assert Posting.subject  =='test subject'
        assert Posting.summary  ==['summary']
        assert Posting.dept     =='dept'

    def testAddArticleTTW(self):
        "Check the SquishSite.addPosting method works TTW"
        
        REQUEST=self.Site.REQUEST
        RESPONSE=REQUEST.RESPONSE
        REQUEST['title']    = 'testSquishSiteAddPosting'
        REQUEST['author']   = 'tester'
        REQUEST['body']     = 'body'
        REQUEST['email']    = 'email'
        REQUEST['notify']   = 1
        REQUEST['encoding'] = 'Plain'
        REQUEST['subject']  = 'test subject'
        REQUEST['summary']  = 'summary'
        REQUEST['dept']     = 'dept'

        r = str(self.Site.addPosting(REQUEST=REQUEST,RESPONSE=RESPONSE))
        Posting = self._getPosting(title="testSquishSiteAddPosting")
        
        # check return value
        index(r,'Your article has been posted')
        
        assert Posting.title    =='testSquishSiteAddPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        assert Posting.subject  =='test subject'
        assert Posting.summary  ==['summary']
        assert Posting.dept     =='dept'

    def testAddArticleIncomplete(self):
        "Check the SquishSite.addPosting handles incomplete postings correctly"
        
        self.Site.REQUEST.HTTP_REFERER='where I came from'
        result = self._addPosting(title    = 'testSquishSiteAddPostingIncomplete')
        assert search('<FORM ACTION="where I came from"',result) is not None

    def testAddComment(self):
        "Check the Article.addPosting method works"
        
        parent = self._getPosting()
        id = self._addPosting(object   = parent,
                              title    = 'testArticleAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        
        Posting = self.Site[parent.id][id]
        
        assert Posting.title    =='testArticleAddPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        # Comments take their subject from their parent Article.
        assert Posting.subject  ==parent.subject
        return Posting

    def testAddCommentTTW(self):
        "Check the Posting.addPosting method works TTW"
        
        REQUEST=self.Site.REQUEST
        RESPONSE=REQUEST.RESPONSE
        REQUEST['title']    = 'testSquishSiteAddPosting'
        REQUEST['author']   = 'tester'
        REQUEST['body']     = 'body'
        REQUEST['email']    = 'email'
        REQUEST['notify']   = 1
        REQUEST['encoding'] = 'Plain'

        parent = self._getPosting()
        r = str(parent.addPosting(REQUEST=REQUEST,RESPONSE=RESPONSE))
        Posting = self._getPosting(title="testSquishSiteAddPosting")
        
        # check return value
        index(r,'Your reply has been posted')
        assert Posting.title    =='testSquishSiteAddPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        assert Posting.subject  ==parent.subject

    def testAddCommentIncomplete(self):
        "Check the Posting.addPosting handles incomplete postings correctly"
        
        self.Site.REQUEST.HTTP_REFERER='where I came from'
        parent = self._getPosting()
        c = parent.reply_cnt
        result = self._addPosting(object = parent,
                                  title    = 'testSquishSiteAddPostingIncomplete')
        assert search('<FORM ACTION="where I came from"',result) is not None
        assert c==parent.reply_cnt

    def testEditArticle(self):
        "Check the edit method makes the necessary changes to Articles"
        REQUEST = {}
        Posting = self._getPosting()
        
        REQUEST['title']   ='testEditPosting'
        REQUEST['author']  ='tester'
        REQUEST['body']    ='body'
        REQUEST['email']   ='email'
        REQUEST['notify']  =1
        REQUEST['encoding']='Plain'
        REQUEST['subject'] ='test subject'
        REQUEST['summary'] ='summary'
        REQUEST['dept']    ='dept'
        REQUEST['date']    =DateTime('2002/11/24 23:00')
        
        Posting.edit(REQUEST=REQUEST)
        
        assert Posting.title    =='testEditPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        assert Posting.subject  =='test subject'
        assert Posting.summary  ==['summary']
        assert Posting.dept     =='dept'
        self.assertEqual(Posting.date(),DateTime('2002/11/24 23:00'))
        self.assertEqual(Posting.reviewed,1)

    def testEditArticleApprove(self):
        """Check the edit method makes the necessary changes to Articles
           when the SquishSite is in 'Approve articles only' mode."""

        # put us in article approval mode
        S= self.Site
        S.manage_edit(0,0,'articles',30)
        
        # add an unapproved article
        self.testAddArticle() 
        
        # edit it (approving it ;-)
        REQUEST = {}
        Posting = self._getPosting('testSquishSiteAddPosting')
        
        REQUEST['title']   ='testEditPosting'
        REQUEST['author']  ='tester'
        REQUEST['body']    ='body'
        REQUEST['email']   ='email'
        REQUEST['notify']  =1
        REQUEST['encoding']='Plain'
        REQUEST['subject'] ='test subject'
        REQUEST['summary'] ='summary'
        REQUEST['dept']    ='dept'
        
        Posting.edit(REQUEST=REQUEST,reviewed='1')
        
        self.assertEqual(Posting.reviewed,1)

    def testEditArticleApprove2(self):
        """Check we can 'upapprove' an article by using the edit method"""

        # put us in article approval mode
        S= self.Site
        S.manage_edit(0,0,'articles',30)
        
        # edit it (approving it ;-)
        REQUEST = {}
        Posting = self._getPosting()
        
        REQUEST['title']   ='testEditPosting'
        REQUEST['author']  ='tester'
        REQUEST['body']    ='body'
        REQUEST['email']   ='email'
        REQUEST['notify']  =1
        REQUEST['encoding']='Plain'
        REQUEST['subject'] ='test subject'
        REQUEST['summary'] ='summary'
        REQUEST['dept']    ='dept'
        
        Posting.edit(REQUEST=REQUEST)
        
        self.assertEqual(Posting.reviewed,0)

    def testEditComment(self):
        "Check the edit method makes the necessary changes to Comments"
        Posting = self.testAddComment()
        old_subject = Posting.subject
        REQUEST = {}
        
        REQUEST['title']   ='testEditComment'
        REQUEST['author']  ='tester edit'
        REQUEST['body']    ='body edit'
        REQUEST['email']   ='email edit'
        REQUEST['notify']  =0
        REQUEST['encoding']='HTML'
        REQUEST['date']    =DateTime('2002/11/24 23:00')
        
        Posting.edit(REQUEST=REQUEST)
        
        assert Posting.title    =='testEditComment'
        assert Posting.author   =='tester edit'
        assert Posting.body     ==['body edit']
        assert Posting.email    =='email edit'
        assert Posting.notify   ==0
        assert Posting.encoding =='HTML'
        assert Posting.subject  ==old_subject
        self.assertEqual(Posting.date(),DateTime('2002/11/24 23:00'))
        self.assertEqual(Posting.reviewed,1)

    def testEditCommentApprove(self):
        "Check the edit method can be used to 'unapprove' comments"
        Posting = self.testAddComment()
        old_subject = Posting.subject
        
        # put us into "articles and replies moderated" mode
        S= self.Site
        S.manage_edit(0,0,'both',30)
        
        REQUEST = {}        
        REQUEST['title']   ='testEditComment'
        REQUEST['author']  ='tester edit'
        REQUEST['body']    ='body edit'
        REQUEST['email']   ='email edit'
        REQUEST['notify']  =0
        REQUEST['encoding']='HTML'
        
        Posting.edit(REQUEST=REQUEST)
        
        self.assertEqual(Posting.reviewed,0)

    def testDescItems(self):
        "Make sure desc_items doesn't return unmodifed postings"
        Site = self.Site
        # turn on moderated Postings
        Site.mod_comment=1
        # Post some comments
        parent = self._getPosting()
        id1 = self._addPosting(object   = parent,
                               title    = 'reviewed',
                               author   = 'tester',
                               body     = 'body',
                               email    = 'email',
                               notify   = 1,
                               encoding = 'Plain')
        id2 = self._addPosting(object   = parent,
                               title    = 'unreviewed',
                               author   = 'tester',
                               body     = 'body',
                               email    = 'email',
                               notify   = 1,
                               encoding = 'Plain')
        # post replies to id1
        p1 = parent[id1]
        id3 = self._addPosting(object   = p1,
                               title    = 'reviewed',
                               author   = 'tester',
                               body     = 'body',
                               email    = 'email',
                               notify   = 1,
                               encoding = 'Plain')
        id4 = self._addPosting(object   = p1,
                               title    = 'unreviewed',
                               author   = 'tester',
                               body     = 'body',
                               email    = 'email',
                               notify   = 1,
                               encoding = 'Plain')
        # post replies to id2
        p2 = parent[id2]
        id5 = self._addPosting(object   = p2,
                               title    = 'reviewed',
                               author   = 'tester',
                               body     = 'body',
                               email    = 'email',
                               notify   = 1,
                               encoding = 'Plain')
        id6 = self._addPosting(object   = p2,
                               title    = 'unreviewed',
                               author   = 'tester',
                               body     = 'body',
                               email    = 'email',
                               notify   = 1,
                               encoding = 'Plain')
        
        # review some of the postings
        Site.set_reviewed(p1)
        Site.set_reviewed(p1[id3])
        Site.set_reviewed(p2[id5])        

        # now check desc_items
        result = map(lambda p:p.id,parent.desc_items())
        
        # We should only see these two replies
        assert result==[`id1`,`id3`], "%s!=%s" % (result,[`id1`,`id3`])
        
    def testGetPhysicalPath(self):
        "Check that getPhysicalPath works for SquishSite, Article and Comment objects."
        # add a posting so we have a SquishSite, an Article and a Comment to work with
        site = self.Site
        article = self._getPosting()
        id = self._addPosting(object   = article,
                              title    = 'testArticleAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        comment = self._getPosting(title="testArticleAddPosting")
        path = ['','squishdottest','testSquish']
        assert site.getPhysicalPath()==tuple(path)
        path.append(article.id)
        assert article.getPhysicalPath()==tuple(path)
        path.append(comment.id)
        assert comment.getPhysicalPath()==tuple(path)

        

    def testAbsoluteURL(self):
        "Check that absolute_url works for SquishSite, Article and Comment objects."
        # add a posting so we have a SquishSite, an Article and a Comment to work with
        site = self.Site
        article = self._getPosting()
        id = self._addPosting(object   = article,
                              title    = 'testArticleAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        comment = self._getPosting(title="testArticleAddPosting")
        url = 'http://foo/squishdottest/testSquish'
        assert site.absolute_url()==url
        url = url + '/' + article.id
        assert article.absolute_url()==url
        url = url + '/' + comment.id
        assert comment.absolute_url()==url

def test_suite():
    return makeSuite(PostingTests)

def debug():
   test_suite().debug()
    
