/*
   Copyright (C) 2009 Red Hat, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _H_RED_KEY
#define _H_RED_KEY

enum RedKey {
    REDKEY_INVALID,
    REDKEY_ESCAPE,
    REDKEY_1,
    REDKEY_2,
    REDKEY_3,
    REDKEY_4,
    REDKEY_5,
    REDKEY_6,
    REDKEY_7,
    REDKEY_8,
    REDKEY_9,
    REDKEY_0,
    REDKEY_MINUS,
    REDKEY_EQUALS,
    REDKEY_BACKSPACE,
    REDKEY_TAB,
    REDKEY_Q,
    REDKEY_W,
    REDKEY_E,
    REDKEY_R,
    REDKEY_T,
    REDKEY_Y,
    REDKEY_U,
    REDKEY_I,
    REDKEY_O,
    REDKEY_P,
    REDKEY_L_BRACKET,
    REDKEY_R_BRACKET,
    REDKEY_ENTER,
    REDKEY_L_CTRL,
    REDKEY_A,
    REDKEY_S,
    REDKEY_D,
    REDKEY_F,
    REDKEY_G,
    REDKEY_H,
    REDKEY_J,
    REDKEY_K,
    REDKEY_L,
    REDKEY_SEMICOLON,
    REDKEY_QUOTE,

    REDKEY_BACK_QUOTE,
    REDKEY_L_SHIFT,
    REDKEY_BACK_SLASH,
    REDKEY_Z,
    REDKEY_X,
    REDKEY_C,
    REDKEY_V,
    REDKEY_B,
    REDKEY_N,
    REDKEY_M,
    REDKEY_COMMA,
    REDKEY_PERIOD,
    REDKEY_SLASH,
    REDKEY_R_SHIFT,
    REDKEY_PAD_MULTIPLY,
    REDKEY_L_ALT,
    REDKEY_SPACE,
    REDKEY_CAPS_LOCK,
    REDKEY_F1,
    REDKEY_F2,
    REDKEY_F3,
    REDKEY_F4,
    REDKEY_F5,
    REDKEY_F6,
    REDKEY_F7,
    REDKEY_F8,
    REDKEY_F9,
    REDKEY_F10,
    REDKEY_NUM_LOCK,
    REDKEY_SCROLL_LOCK,
    REDKEY_PAD_7,
    REDKEY_PAD_8,
    REDKEY_PAD_9,
    REDKEY_PAD_MINUS,
    REDKEY_PAD_4,
    REDKEY_PAD_5,
    REDKEY_PAD_6,
    REDKEY_PAD_PLUS,
    REDKEY_PAD_1,
    REDKEY_PAD_2,
    REDKEY_PAD_3,
    REDKEY_PAD_0,
    REDKEY_PAD_POINT,

    REDKEY_EUROPEAN = 0x56,
    REDKEY_F11,
    REDKEY_F12,

    REDKEY_JAPANESE_HIRAGANA_KATAKANA = 0x70,
    REDKEY_JAPANESE_BACKSLASH = 0x73,
    REDKEY_JAPANESE_HENKAN = 0x79,
    REDKEY_JAPANESE_MUHENKAN = 0x7B,
    REDKEY_JAPANESE_YEN = 0x7D,

    REDKEY_KOREAN_HANGUL_HANJA = 0xf1,
    REDKEY_KOREAN_HANGUL = 0xf2,

    REDKEY_ESCAPE_BASE = 0x100,
    REDKEY_PAD_ENTER = REDKEY_ESCAPE_BASE + 0x1c,
    REDKEY_R_CTRL = REDKEY_ESCAPE_BASE + 0x1d,
    REDKEY_FAKE_L_SHIFT = REDKEY_ESCAPE_BASE + 0x2a,
    REDKEY_PAD_DIVIDE = REDKEY_ESCAPE_BASE + 0x35,
    REDKEY_FAKE_R_SHIFT = REDKEY_ESCAPE_BASE + 0x36,
    REDKEY_CTRL_PRINT_SCREEN = REDKEY_ESCAPE_BASE + 0x37,
    REDKEY_R_ALT = REDKEY_ESCAPE_BASE + 0x38,
    REDKEY_CTRL_BREAK = REDKEY_ESCAPE_BASE + 0x46,
    REDKEY_HOME = REDKEY_ESCAPE_BASE + 0x47,
    REDKEY_UP = REDKEY_ESCAPE_BASE + 0x48,
    REDKEY_PAGEUP = REDKEY_ESCAPE_BASE + 0x49,
    REDKEY_LEFT = REDKEY_ESCAPE_BASE + 0x4b,
    REDKEY_RIGHT = REDKEY_ESCAPE_BASE + 0x4d,
    REDKEY_END = REDKEY_ESCAPE_BASE + 0x4f,
    REDKEY_DOWN = REDKEY_ESCAPE_BASE + 0x50,
    REDKEY_PAGEDOWN = REDKEY_ESCAPE_BASE + 0x51,
    REDKEY_INSERT = REDKEY_ESCAPE_BASE + 0x52,
    REDKEY_DELETE = REDKEY_ESCAPE_BASE + 0x53,
    REDKEY_LEFT_CMD = REDKEY_ESCAPE_BASE + 0x5b,
    REDKEY_RIGHT_CMD = REDKEY_ESCAPE_BASE + 0x5c,
    REDKEY_MENU = REDKEY_ESCAPE_BASE + 0x5d,

    REDKEY_PAUSE,

    REDKEY_NUM_KEYS
};

#endif

