/*
/ Dialogs.cpp
/ various dialog classes
/
/ version 1.2, 2008 October 9
/
/ Author: Sandro Furieri a-furieri@lqt.it
/
/ Copyright (C) 2008  Alessandro Furieri
/
/    This program is free software: you can redistribute it and/or modify
/    it under the terms of the GNU General Public License as published by
/    the Free Software Foundation, either version 3 of the License, or
/    (at your option) any later version.
/
/    This program is distributed in the hope that it will be useful,
/    but WITHOUT ANY WARRANTY; without even the implied warranty of
/    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/    GNU General Public License for more details.
/
/    You should have received a copy of the GNU General Public License
/    along with this program.  If not, see <http://www.gnu.org/licenses/>.
/
*/

#include "Classdef.h"

#include "wx/spinctrl.h"
#include "wx/listctrl.h"
#include "wx/html/htmlwin.h"

bool VirtualShpDialog::Create(MyFrame * parent, wxString & path,
                              wxString & table, wxString & defCs)
{
//
// creating the dialog
//
  MainFrame = parent;
  Path = path;
  Table = table;
  Default = defCs;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Creating Virtual Shapefile")) ==
      false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void VirtualShpDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the Shapefile path
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(pathSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *pathLabel = new wxStaticText(this, wxID_STATIC, wxT("&Path:"));
  pathSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *pathValue = new wxTextCtrl(this, wxID_STATIC,
                                         Path, wxDefaultPosition,
                                         wxSize(350, 22), wxTE_READONLY);
  pathSizer->Add(pathValue, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: TABLE name
  wxBoxSizer *tableSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(tableSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *tableLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Table name:"));
  tableSizer->Add(tableLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *tableCtrl = new wxTextCtrl(this, ID_VIRTSHP_TABLE, Table,
                                         wxDefaultPosition, wxSize(350,
                                                                   22));
  tableSizer->Add(tableCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: SRID
  wxBoxSizer *sridSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(sridSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxStaticText *sridLabel = new wxStaticText(this, wxID_STATIC, wxT("&SRID:"));
  sridSizer->Add(sridLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxSpinCtrl *sridCtrl = new wxSpinCtrl(this, ID_VIRTSHP_SRID, wxEmptyString,
                                        wxDefaultPosition, wxSize(80, 20),
                                        wxSP_ARROW_KEYS,
                                        -1, 40000, -1);
  sridSizer->Add(sridCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// third row: CHARSET
  wxStaticBox *charsetBox = new wxStaticBox(this, wxID_STATIC,
                                            wxT("Charset Encoding"),
                                            wxDefaultPosition,
                                            wxDefaultSize);
  wxBoxSizer *charsetSizer = new wxStaticBoxSizer(charsetBox, wxHORIZONTAL);
  sridSizer->Add(charsetSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *charsetCtrl = new wxListBox(this, ID_VIRTSHP_CHARSET,
                                         wxDefaultPosition, wxDefaultSize,
                                         MainFrame->GetCharsetsLen(),
                                         MainFrame->GetCharsetsNames(),
                                         wxLB_SINGLE);
  charsetCtrl->
    SetFont(wxFont
            (8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL));
  int idSel = MainFrame->GetCharsetIndex(Default);
  if (idSel != wxNOT_FOUND)
    charsetCtrl->SetSelection(idSel);
  charsetSizer->Add(charsetCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & VirtualShpDialog::OnOk);
}

void VirtualShpDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxTextCtrl *tableCtrl = (wxTextCtrl *) FindWindow(ID_VIRTSHP_TABLE);
  Table = tableCtrl->GetValue();
  if (Table.Len() < 1)
    {
      wxMessageBox(wxT("You must specify the TABLE NAME !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  if (MainFrame->TableAlreadyExists(Table) == true)
    {
      wxMessageBox(wxT("a table name '") + Table + wxT("' already exists"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxSpinCtrl *sridCtrl = (wxSpinCtrl *) FindWindow(ID_VIRTSHP_SRID);
  Srid = sridCtrl->GetValue();
  if (Srid == -1)
    ;
  else if (MainFrame->SridNotExists(Srid) == true)
    {
      wxMessageBox(wxT("invalid SRID value"), wxT("spatialite-gui"),
                   wxOK | wxICON_WARNING, this);
      return;
    }
  wxListBox *charsetCtrl = (wxListBox *) FindWindow(ID_VIRTSHP_CHARSET);
  int idSel = charsetCtrl->GetSelection();
  if (idSel == wxNOT_FOUND)
    {
      wxMessageBox(wxT("you must select some Charset Encoding from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxString *charsets = MainFrame->GetCharsets();
  Charset = *(charsets + idSel);
  wxDialog::EndModal(wxID_OK);
}

bool VirtualTxtDialog::Create(MyFrame * parent, wxString & path,
                              wxString & table, wxString & defCs)
{
//
// creating the dialog
//
  MainFrame = parent;
  Path = path;
  Table = table;
  Default = defCs;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Creating Virtual CSV/TXT")) ==
      false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void VirtualTxtDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  FirstLineTitles = true;
  Separator = '\t';
  TextSeparator = '"';
  DecimalPointIsComma = false;
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the CSV/TXT path
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(pathSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *pathLabel = new wxStaticText(this, wxID_STATIC, wxT("&Path:"));
  pathSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *pathValue = new wxTextCtrl(this, wxID_STATIC,
                                         Path, wxDefaultPosition,
                                         wxSize(350, 22), wxTE_READONLY);
  pathSizer->Add(pathValue, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: TABLE name
  wxBoxSizer *tableSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(tableSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *tableLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Table name:"));
  tableSizer->Add(tableLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *tableCtrl = new wxTextCtrl(this, ID_VIRTTXT_TABLE, Table,
                                         wxDefaultPosition, wxSize(350,
                                                                   22));
  tableSizer->Add(tableCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: OPTIONS
  wxBoxSizer *optSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(optSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxBoxSizer *modeSizer = new wxBoxSizer(wxVERTICAL);
  optSizer->Add(modeSizer, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
  wxBoxSizer *mode1Sizer = new wxBoxSizer(wxHORIZONTAL);
  modeSizer->Add(mode1Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxCheckBox *titleCtrl = new wxCheckBox(this, ID_VIRTTXT_TITLES,
                                         wxT
                                         ("First line contains column names"),
                                         wxDefaultPosition, wxDefaultSize);
  titleCtrl->SetValue(true);
  mode1Sizer->Add(titleCtrl, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxStaticBox *sepBox = new wxStaticBox(this, wxID_STATIC,
                                        wxT("Separators"),
                                        wxDefaultPosition, wxDefaultSize);
  wxBoxSizer *sepSizer = new wxStaticBoxSizer(sepBox, wxVERTICAL);
  modeSizer->Add(sepSizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxBoxSizer *mode2Sizer = new wxBoxSizer(wxHORIZONTAL);
  sepSizer->Add(mode2Sizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxString quotes[2];
  quotes[0] = wxT("&Double \"");
  quotes[1] = wxT("&Single '");
  wxRadioBox *textSeparatorBox = new wxRadioBox(this, ID_VIRTTXT_QUOTE,
                                                wxT("&Text separator: quotes"),
                                                wxDefaultPosition,
                                                wxDefaultSize, 2,
                                                quotes, 2,
                                                wxRA_SPECIFY_COLS);
  mode2Sizer->Add(textSeparatorBox, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxBoxSizer *mode3Sizer = new wxBoxSizer(wxHORIZONTAL);
  sepSizer->Add(mode3Sizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxString separators[6];
  separators[0] = wxT("&Tab");
  separators[1] = wxT("&Space");
  separators[2] = wxT("Co&mma ,");
  separators[3] = wxT("&Colon :");
  separators[4] = wxT("S&emicolon ;");
  separators[5] = wxT("&Other");
  wxRadioBox *separatorBox = new wxRadioBox(this, ID_VIRTTXT_SEPARATOR,
                                            wxT("&Column separator"),
                                            wxDefaultPosition, wxDefaultSize,
                                            6,
                                            separators, 2,
                                            wxRA_SPECIFY_COLS);
  mode3Sizer->Add(separatorBox, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxBoxSizer *mode4Sizer = new wxBoxSizer(wxHORIZONTAL);
  sepSizer->Add(mode4Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxStaticText *charSeparatorLabel = new wxStaticText(this, wxID_STATIC,
                                                      wxT("&Custom separator:"),
                                                      wxDefaultPosition,
                                                      wxDefaultSize, 0);
  mode4Sizer->Add(charSeparatorLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *dummy =
    new wxTextCtrl(this, ID_VIRTTXT_CHARSEPARATOR, wxT("Dummy Text pq"),
                   wxDefaultPosition,
                   wxDefaultSize, 0);
  wxSize sz = dummy->GetSize();
  delete dummy;
  sz.SetWidth(40);
  wxTextCtrl *charSeparatorCtrl =
    new wxTextCtrl(this, ID_VIRTTXT_CHARSEPARATOR, wxT("TAB"),
                   wxDefaultPosition, sz, 0);
  charSeparatorCtrl->SetMaxLength(1);
  charSeparatorCtrl->Enable(false);
  mode4Sizer->Add(charSeparatorCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxBoxSizer *mode5Sizer = new wxBoxSizer(wxHORIZONTAL);
  sepSizer->Add(mode5Sizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxString points[2];
  points[0] = wxT("&Point .");
  points[1] = wxT("&Comma ,");
  wxRadioBox *decimalSeparatorBox = new wxRadioBox(this, ID_VIRTTXT_POINT,
                                                   wxT("&Decimal separator"),
                                                   wxDefaultPosition,
                                                   wxDefaultSize, 2,
                                                   points, 2,
                                                   wxRA_SPECIFY_COLS);
  mode5Sizer->Add(decimalSeparatorBox, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// third row: CHARSET
  wxStaticBox *charsetBox = new wxStaticBox(this, wxID_STATIC,
                                            wxT("Charset Encoding"),
                                            wxDefaultPosition,
                                            wxDefaultSize);
  wxBoxSizer *charsetSizer = new wxStaticBoxSizer(charsetBox, wxHORIZONTAL);
  optSizer->Add(charsetSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *charsetCtrl = new wxListBox(this, ID_VIRTTXT_CHARSET,
                                         wxDefaultPosition, wxDefaultSize,
                                         MainFrame->GetCharsetsLen(),
                                         MainFrame->GetCharsetsNames(),
                                         wxLB_SINGLE);
  charsetCtrl->
    SetFont(wxFont
            (8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL));
  int idSel = MainFrame->GetCharsetIndex(Default);
  if (idSel != wxNOT_FOUND)
    charsetCtrl->SetSelection(idSel);
  charsetSizer->Add(charsetCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & VirtualTxtDialog::OnOk);
// appends event handler for radioboxes
  Connect(ID_VIRTTXT_QUOTE, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & VirtualTxtDialog::OnQuote);
  Connect(ID_VIRTTXT_SEPARATOR, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & VirtualTxtDialog::OnSeparator);
  Connect(ID_VIRTTXT_POINT, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & VirtualTxtDialog::OnDecimalSeparator);
}

void VirtualTxtDialog::OnDecimalSeparator(wxCommandEvent & WXUNUSED(event))
{
//
// POINT selection changed
//
  wxRadioBox *decimalSeparatorCtrl =
    (wxRadioBox *) FindWindow(ID_VIRTTXT_POINT);
  switch (decimalSeparatorCtrl->GetSelection())
    {
      case 0:
        DecimalPointIsComma = false;
        break;
      case 1:
        DecimalPointIsComma = true;
        break;
    };
}

void VirtualTxtDialog::OnQuote(wxCommandEvent & WXUNUSED(event))
{
//
// QUOTE selection changed
//
  wxRadioBox *separatorCtrl = (wxRadioBox *) FindWindow(ID_VIRTTXT_QUOTE);
  switch (separatorCtrl->GetSelection())
    {
      case 0:
        TextSeparator = '"';
        break;
      case 1:
        TextSeparator = '\'';
        break;
    };
}

void VirtualTxtDialog::OnSeparator(wxCommandEvent & WXUNUSED(event))
{
//
// SEPARATOR selection changed
//
  wxTextCtrl *charSeparatorCtrl =
    (wxTextCtrl *) FindWindow(ID_VIRTTXT_CHARSEPARATOR);
  wxRadioBox *separatorCtrl = (wxRadioBox *) FindWindow(ID_VIRTTXT_SEPARATOR);
  switch (separatorCtrl->GetSelection())
    {
      case 0:
        Separator = '\t';
        charSeparatorCtrl->SetValue(wxT("TAB"));
        break;
      case 1:
        Separator = ' ';
        charSeparatorCtrl->SetValue(wxT("SP"));
        break;
      case 2:
        Separator = ',';
        charSeparatorCtrl->SetValue(wxT(","));
        break;
      case 3:
        Separator = ':';
        charSeparatorCtrl->SetValue(wxT(":"));
        break;
      case 4:
        Separator = ';';
        charSeparatorCtrl->SetValue(wxT(";"));
        break;
      case 5:
        Separator = '|';
        charSeparatorCtrl->SetValue(wxT("|"));
        break;
    };
  if (separatorCtrl->GetSelection() == 5)
    charSeparatorCtrl->Enable(true);
  else
    charSeparatorCtrl->Enable(false);
}

void VirtualTxtDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxTextCtrl *tableCtrl = (wxTextCtrl *) FindWindow(ID_VIRTTXT_TABLE);
  Table = tableCtrl->GetValue();
  if (Table.Len() < 1)
    {
      wxMessageBox(wxT("You must specify the TABLE NAME !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  if (MainFrame->TableAlreadyExists(Table) == true)
    {
      wxMessageBox(wxT("a table name '") + Table + wxT("' already exists"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxListBox *charsetCtrl = (wxListBox *) FindWindow(ID_VIRTTXT_CHARSET);
  int idSel = charsetCtrl->GetSelection();
  if (idSel == wxNOT_FOUND)
    {
      wxMessageBox(wxT("you must select some Charset Encoding from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxString *charsets = MainFrame->GetCharsets();
  Charset = *(charsets + idSel);
  wxRadioBox *separatorCtrl = (wxRadioBox *) FindWindow(ID_VIRTTXT_SEPARATOR);
  if (separatorCtrl->GetSelection() == 5)
    {
      wxTextCtrl *charSeparatorCtrl =
        (wxTextCtrl *) FindWindow(ID_VIRTTXT_CHARSEPARATOR);
      wxString separator = charSeparatorCtrl->GetValue();
      if (separator.Len() != 1)
        {
          wxMessageBox(wxT
                       ("you must specificy a single char as Custom Column Separator"),
                       wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
          return;
        }
      char dummy[64];
      strcpy(dummy, separator.ToUTF8());
      Separator = *dummy;
    }
  wxDialog::EndModal(wxID_OK);
}

bool LoadTxtDialog::Create(MyFrame * parent, wxString & path, wxString & table,
                           wxString & defCs)
{
//
// creating the dialog
//
  MainFrame = parent;
  Path = path;
  Table = table;
  Default = defCs;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Load CSV/TXT")) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void LoadTxtDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  FirstLineTitles = true;
  Separator = '\t';
  TextSeparator = '"';
  DecimalPointIsComma = false;
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the CSV/TXT path
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(pathSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *pathLabel = new wxStaticText(this, wxID_STATIC, wxT("&Path:"));
  pathSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *pathValue = new wxTextCtrl(this, wxID_STATIC,
                                         Path, wxDefaultPosition,
                                         wxSize(350, 22), wxTE_READONLY);
  pathSizer->Add(pathValue, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: TABLE name
  wxBoxSizer *tableSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(tableSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *tableLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Table name:"));
  tableSizer->Add(tableLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *tableCtrl = new wxTextCtrl(this, ID_LDTXT_TABLE, Table,
                                         wxDefaultPosition, wxSize(350,
                                                                   22));
  tableSizer->Add(tableCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: OPTIONS
  wxBoxSizer *optSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(optSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxBoxSizer *modeSizer = new wxBoxSizer(wxVERTICAL);
  optSizer->Add(modeSizer, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
  wxBoxSizer *mode1Sizer = new wxBoxSizer(wxHORIZONTAL);
  modeSizer->Add(mode1Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxCheckBox *titleCtrl = new wxCheckBox(this, ID_LDTXT_TITLES,
                                         wxT
                                         ("First line contains column names"),
                                         wxDefaultPosition, wxDefaultSize);
  titleCtrl->SetValue(true);
  mode1Sizer->Add(titleCtrl, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxStaticBox *sepBox = new wxStaticBox(this, wxID_STATIC,
                                        wxT("Separators"),
                                        wxDefaultPosition, wxDefaultSize);
  wxBoxSizer *sepSizer = new wxStaticBoxSizer(sepBox, wxVERTICAL);
  modeSizer->Add(sepSizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxBoxSizer *mode2Sizer = new wxBoxSizer(wxHORIZONTAL);
  sepSizer->Add(mode2Sizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxString quotes[2];
  quotes[0] = wxT("&Double \"");
  quotes[1] = wxT("&Single '");
  wxRadioBox *textSeparatorBox = new wxRadioBox(this, ID_LDTXT_QUOTE,
                                                wxT("&Text separator: quotes"),
                                                wxDefaultPosition,
                                                wxDefaultSize, 2,
                                                quotes, 2,
                                                wxRA_SPECIFY_COLS);
  mode2Sizer->Add(textSeparatorBox, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxBoxSizer *mode3Sizer = new wxBoxSizer(wxHORIZONTAL);
  sepSizer->Add(mode3Sizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxString separators[6];
  separators[0] = wxT("&Tab");
  separators[1] = wxT("&Space");
  separators[2] = wxT("Co&mma ,");
  separators[3] = wxT("&Colon :");
  separators[4] = wxT("S&emicolon ;");
  separators[5] = wxT("&Other");
  wxRadioBox *separatorBox = new wxRadioBox(this, ID_LDTXT_SEPARATOR,
                                            wxT("&Column separator"),
                                            wxDefaultPosition, wxDefaultSize,
                                            6,
                                            separators, 2,
                                            wxRA_SPECIFY_COLS);
  mode3Sizer->Add(separatorBox, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxBoxSizer *mode4Sizer = new wxBoxSizer(wxHORIZONTAL);
  sepSizer->Add(mode4Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxStaticText *charSeparatorLabel = new wxStaticText(this, wxID_STATIC,
                                                      wxT("&Custom separator:"),
                                                      wxDefaultPosition,
                                                      wxDefaultSize, 0);
  mode4Sizer->Add(charSeparatorLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *dummy =
    new wxTextCtrl(this, ID_LDTXT_CHARSEPARATOR, wxT("Dummy Text pq"),
                   wxDefaultPosition,
                   wxDefaultSize, 0);
  wxSize sz = dummy->GetSize();
  delete dummy;
  sz.SetWidth(40);
  wxTextCtrl *charSeparatorCtrl =
    new wxTextCtrl(this, ID_LDTXT_CHARSEPARATOR, wxT("TAB"),
                   wxDefaultPosition, sz, 0);
  charSeparatorCtrl->SetMaxLength(1);
  charSeparatorCtrl->Enable(false);
  mode4Sizer->Add(charSeparatorCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxBoxSizer *mode5Sizer = new wxBoxSizer(wxHORIZONTAL);
  sepSizer->Add(mode5Sizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxString points[2];
  points[0] = wxT("&Point .");
  points[1] = wxT("&Comma ,");
  wxRadioBox *decimalSeparatorBox = new wxRadioBox(this, ID_LDTXT_POINT,
                                                   wxT("&Decimal separator"),
                                                   wxDefaultPosition,
                                                   wxDefaultSize, 2,
                                                   points, 2,
                                                   wxRA_SPECIFY_COLS);
  mode5Sizer->Add(decimalSeparatorBox, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// third row: CHARSET
  wxStaticBox *charsetBox = new wxStaticBox(this, wxID_STATIC,
                                            wxT("Charset Encoding"),
                                            wxDefaultPosition,
                                            wxDefaultSize);
  wxBoxSizer *charsetSizer = new wxStaticBoxSizer(charsetBox, wxHORIZONTAL);
  optSizer->Add(charsetSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *charsetCtrl = new wxListBox(this, ID_LDTXT_CHARSET,
                                         wxDefaultPosition, wxDefaultSize,
                                         MainFrame->GetCharsetsLen(),
                                         MainFrame->GetCharsetsNames(),
                                         wxLB_SINGLE);
  charsetCtrl->
    SetFont(wxFont
            (8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL));
  int idSel = MainFrame->GetCharsetIndex(Default);
  if (idSel != wxNOT_FOUND)
    charsetCtrl->SetSelection(idSel);
  charsetSizer->Add(charsetCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & LoadTxtDialog::OnOk);
// appends event handler for radioboxes
  Connect(ID_LDTXT_QUOTE, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & LoadTxtDialog::OnQuote);
  Connect(ID_LDTXT_SEPARATOR, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & LoadTxtDialog::OnSeparator);
  Connect(ID_LDTXT_POINT, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & LoadTxtDialog::OnDecimalSeparator);
}

void LoadTxtDialog::OnDecimalSeparator(wxCommandEvent & WXUNUSED(event))
{
//
// POINT selection changed
//
  wxRadioBox *decimalSeparatorCtrl = (wxRadioBox *) FindWindow(ID_LDTXT_POINT);
  switch (decimalSeparatorCtrl->GetSelection())
    {
      case 0:
        DecimalPointIsComma = false;
        break;
      case 1:
        DecimalPointIsComma = true;
        break;
    };
}

void LoadTxtDialog::OnQuote(wxCommandEvent & WXUNUSED(event))
{
//
// QUOTE selection changed
//
  wxRadioBox *separatorCtrl = (wxRadioBox *) FindWindow(ID_LDTXT_QUOTE);
  switch (separatorCtrl->GetSelection())
    {
      case 0:
        TextSeparator = '"';
        break;
      case 1:
        TextSeparator = '\'';
        break;
    };
}

void LoadTxtDialog::OnSeparator(wxCommandEvent & WXUNUSED(event))
{
//
// SEPARATOR selection changed
//
  wxTextCtrl *charSeparatorCtrl =
    (wxTextCtrl *) FindWindow(ID_LDTXT_CHARSEPARATOR);
  wxRadioBox *separatorCtrl = (wxRadioBox *) FindWindow(ID_LDTXT_SEPARATOR);
  switch (separatorCtrl->GetSelection())
    {
      case 0:
        Separator = '\t';
        charSeparatorCtrl->SetValue(wxT("TAB"));
        break;
      case 1:
        Separator = ' ';
        charSeparatorCtrl->SetValue(wxT("SP"));
        break;
      case 2:
        Separator = ',';
        charSeparatorCtrl->SetValue(wxT(","));
        break;
      case 3:
        Separator = ':';
        charSeparatorCtrl->SetValue(wxT(":"));
        break;
      case 4:
        Separator = ';';
        charSeparatorCtrl->SetValue(wxT(";"));
        break;
      case 5:
        Separator = '|';
        charSeparatorCtrl->SetValue(wxT("|"));
        break;
    };
  if (separatorCtrl->GetSelection() == 5)
    charSeparatorCtrl->Enable(true);
  else
    charSeparatorCtrl->Enable(false);
}

void LoadTxtDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxTextCtrl *tableCtrl = (wxTextCtrl *) FindWindow(ID_LDTXT_TABLE);
  Table = tableCtrl->GetValue();
  if (Table.Len() < 1)
    {
      wxMessageBox(wxT("You must specify the TABLE NAME !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  if (MainFrame->TableAlreadyExists(Table) == true)
    {
      wxMessageBox(wxT("a table name '") + Table + wxT("' already exists"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxListBox *charsetCtrl = (wxListBox *) FindWindow(ID_LDTXT_CHARSET);
  int idSel = charsetCtrl->GetSelection();
  if (idSel == wxNOT_FOUND)
    {
      wxMessageBox(wxT("you must select some Charset Encoding from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxString *charsets = MainFrame->GetCharsets();
  Charset = *(charsets + idSel);
  wxRadioBox *separatorCtrl = (wxRadioBox *) FindWindow(ID_LDTXT_SEPARATOR);
  if (separatorCtrl->GetSelection() == 5)
    {
      wxTextCtrl *charSeparatorCtrl =
        (wxTextCtrl *) FindWindow(ID_LDTXT_CHARSEPARATOR);
      wxString separator = charSeparatorCtrl->GetValue();
      if (separator.Len() != 1)
        {
          wxMessageBox(wxT
                       ("you must specificy a single char as Custom Column Separator"),
                       wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
          return;
        }
      char dummy[64];
      strcpy(dummy, separator.ToUTF8());
      Separator = *dummy;
    }
  wxDialog::EndModal(wxID_OK);
}

bool LoadShpDialog::Create(MyFrame * parent, wxString & path, wxString & table,
                           int srid, wxString & column, wxString & defCs)
{
//
// creating the dialog
//
  MainFrame = parent;
  Path = path;
  Table = table;
  Srid = srid;
  Column = column;
  Default = defCs;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Load Shapefile")) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void LoadShpDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the Shapefile path
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(pathSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *pathLabel = new wxStaticText(this, wxID_STATIC, wxT("&Path:"));
  pathSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *pathValue = new wxTextCtrl(this, wxID_STATIC,
                                         Path, wxDefaultPosition,
                                         wxSize(350, 22), wxTE_READONLY);
  pathSizer->Add(pathValue, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: TABLE name
  wxBoxSizer *tableSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(tableSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *tableLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Table name:"));
  tableSizer->Add(tableLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *tableCtrl = new wxTextCtrl(this, ID_LDSHP_TABLE, Table,
                                         wxDefaultPosition, wxSize(350,
                                                                   22));
  tableSizer->Add(tableCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// third row: GEOMETRY COLUMN name
  wxBoxSizer *colSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(colSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *colLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&GeomColumn name:"));
  colSizer->Add(colLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *colCtrl = new wxTextCtrl(this, ID_LDSHP_COLUMN, Column,
                                       wxDefaultPosition, wxSize(350, 22));
  colSizer->Add(colCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// fourth row: SRID
  wxBoxSizer *sridSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(sridSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxStaticText *sridLabel = new wxStaticText(this, wxID_STATIC, wxT("&SRID:"));
  sridSizer->Add(sridLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxSpinCtrl *sridCtrl = new wxSpinCtrl(this, ID_LDSHP_SRID, wxEmptyString,
                                        wxDefaultPosition, wxSize(80, 20),
                                        wxSP_ARROW_KEYS,
                                        -1, 40000, Srid);
  sridSizer->Add(sridCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// fifth row: CHARSET
  wxStaticBox *charsetBox = new wxStaticBox(this, wxID_STATIC,
                                            wxT("Charset Encoding"),
                                            wxDefaultPosition,
                                            wxDefaultSize);
  wxBoxSizer *charsetSizer = new wxStaticBoxSizer(charsetBox, wxHORIZONTAL);
  sridSizer->Add(charsetSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *charsetCtrl = new wxListBox(this, ID_LDSHP_CHARSET,
                                         wxDefaultPosition, wxDefaultSize,
                                         MainFrame->GetCharsetsLen(),
                                         MainFrame->GetCharsetsNames(),
                                         wxLB_SINGLE);
  charsetCtrl->
    SetFont(wxFont
            (8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL));
  int idSel = MainFrame->GetCharsetIndex(Default);
  if (idSel != wxNOT_FOUND)
    charsetCtrl->SetSelection(idSel);
  charsetSizer->Add(charsetCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & LoadShpDialog::OnOk);
}

void LoadShpDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxTextCtrl *tableCtrl = (wxTextCtrl *) FindWindow(ID_LDSHP_TABLE);
  Table = tableCtrl->GetValue();
  if (Table.Len() < 1)
    {
      wxMessageBox(wxT("You must specify the TABLE NAME !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  if (MainFrame->TableAlreadyExists(Table) == true)
    {
      wxMessageBox(wxT("a table name '") + Table + wxT("' already exists"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxTextCtrl *columnCtrl = (wxTextCtrl *) FindWindow(ID_LDSHP_COLUMN);
  Column = columnCtrl->GetValue();
  if (Column.Len() < 1)
    {
      wxMessageBox(wxT("You must specify the GEOMETRY COLUMN NAME !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxSpinCtrl *sridCtrl = (wxSpinCtrl *) FindWindow(ID_LDSHP_SRID);
  Srid = sridCtrl->GetValue();
  if (MainFrame->SridNotExists(Srid) == true)
    {
      wxMessageBox(wxT("invalid SRID value"), wxT("spatialite-gui"),
                   wxOK | wxICON_WARNING, this);
      return;
    }
  wxListBox *charsetCtrl = (wxListBox *) FindWindow(ID_LDSHP_CHARSET);
  int idSel = charsetCtrl->GetSelection();
  if (idSel == wxNOT_FOUND)
    {
      wxMessageBox(wxT("you must select some Charset Encoding from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxString *charsets = MainFrame->GetCharsets();
  Charset = *(charsets + idSel);
  wxDialog::EndModal(wxID_OK);
}

bool DumpShpDialog::Create(MyFrame * parent, wxString & path, wxString & table,
                           wxString & column, wxString & defCs)
{
//
// creating the dialog
//
  MainFrame = parent;
  Path = path;
  Table = table;
  Column = column;
  Default = defCs;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Dump Shapefile")) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void DumpShpDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the Shapefile path
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(pathSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *pathLabel = new wxStaticText(this, wxID_STATIC, wxT("&Path:"));
  pathSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *pathValue = new wxTextCtrl(this, wxID_STATIC,
                                         Path, wxDefaultPosition,
                                         wxSize(350, 22), wxTE_READONLY);
  pathSizer->Add(pathValue, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: TABLE name
  wxBoxSizer *tableSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(tableSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *tableLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Table name:"));
  tableSizer->Add(tableLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *tableCtrl = new wxTextCtrl(this, wxID_STATIC, Table,
                                         wxDefaultPosition, wxSize(350,
                                                                   22));
  tableCtrl->Enable(false);
  tableSizer->Add(tableCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// third row: GEOMETRY COLUMN name
  wxBoxSizer *colSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(colSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *colLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&GeomColumn name:"));
  colSizer->Add(colLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *colCtrl = new wxTextCtrl(this, wxID_STATIC, Column,
                                       wxDefaultPosition, wxSize(350, 22));
  colCtrl->Enable(false);
  colSizer->Add(colCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// fourth row: CHARSET
  wxBoxSizer *csSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(csSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxStaticBox *charsetBox = new wxStaticBox(this, wxID_STATIC,
                                            wxT("Charset Encoding"),
                                            wxDefaultPosition,
                                            wxDefaultSize);
  wxBoxSizer *charsetSizer = new wxStaticBoxSizer(charsetBox, wxHORIZONTAL);
  csSizer->Add(charsetSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *charsetCtrl = new wxListBox(this, ID_DMPSHP_CHARSET,
                                         wxDefaultPosition, wxDefaultSize,
                                         MainFrame->GetCharsetsLen(),
                                         MainFrame->GetCharsetsNames(),
                                         wxLB_SINGLE);
  charsetCtrl->
    SetFont(wxFont
            (8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL));
  int idSel = MainFrame->GetCharsetIndex(Default);
  if (idSel != wxNOT_FOUND)
    charsetCtrl->SetSelection(idSel);
  charsetSizer->Add(charsetCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & DumpShpDialog::OnOk);
}

void DumpShpDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxListBox *charsetCtrl = (wxListBox *) FindWindow(ID_DMPSHP_CHARSET);
  int idSel = charsetCtrl->GetSelection();
  if (idSel == wxNOT_FOUND)
    {
      wxMessageBox(wxT("you must select some Charset Encoding from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxString *charsets = MainFrame->GetCharsets();
  Charset = *(charsets + idSel);
  wxDialog::EndModal(wxID_OK);
}

bool DumpTxtDialog::Create(MyFrame * parent, wxString & path, wxString & target,
                           wxString & defCs)
{
//
// creating the dialog
//
  MainFrame = parent;
  Path = path;
  Default = defCs;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Dump ") + target) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void DumpTxtDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the Shapefile path
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(pathSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *pathLabel = new wxStaticText(this, wxID_STATIC, wxT("&Path:"));
  pathSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *pathValue = new wxTextCtrl(this, wxID_STATIC,
                                         Path, wxDefaultPosition,
                                         wxSize(350, 22), wxTE_READONLY);
  pathSizer->Add(pathValue, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: CHARSET
  wxBoxSizer *csSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(csSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxStaticBox *charsetBox = new wxStaticBox(this, wxID_STATIC,
                                            wxT("Charset Encoding"),
                                            wxDefaultPosition,
                                            wxDefaultSize);
  wxBoxSizer *charsetSizer = new wxStaticBoxSizer(charsetBox, wxHORIZONTAL);
  csSizer->Add(charsetSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *charsetCtrl = new wxListBox(this, ID_DMPTXT_CHARSET,
                                         wxDefaultPosition, wxDefaultSize,
                                         MainFrame->GetCharsetsLen(),
                                         MainFrame->GetCharsetsNames(),
                                         wxLB_SINGLE);
  charsetCtrl->
    SetFont(wxFont
            (8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL));
  int idSel = MainFrame->GetCharsetIndex(Default);
  if (idSel != wxNOT_FOUND)
    charsetCtrl->SetSelection(idSel);
  charsetSizer->Add(charsetCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & DumpTxtDialog::OnOk);
}

void DumpTxtDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxListBox *charsetCtrl = (wxListBox *) FindWindow(ID_DMPTXT_CHARSET);
  int idSel = charsetCtrl->GetSelection();
  if (idSel == wxNOT_FOUND)
    {
      wxMessageBox(wxT("you must select some Charset Encoding from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxString *charsets = MainFrame->GetCharsets();
  Charset = *(charsets + idSel);
  wxDialog::EndModal(wxID_OK);
}

bool SqlScriptDialog::Create(MyFrame * parent, wxString & path,
                             wxString & defCs)
{
//
// creating the dialog
//
  MainFrame = parent;
  Path = path;
  Default = defCs;
  if (wxDialog::Create(parent, wxID_ANY, wxT("SQL script execute")) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void SqlScriptDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the SQL script path
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(pathSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *pathLabel = new wxStaticText(this, wxID_STATIC, wxT("&Path:"));
  pathSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *pathValue = new wxTextCtrl(this, wxID_STATIC,
                                         Path, wxDefaultPosition,
                                         wxSize(350, 22), wxTE_READONLY);
  pathSizer->Add(pathValue, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: CHARSET
  wxBoxSizer *csSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(csSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxStaticBox *charsetBox = new wxStaticBox(this, wxID_STATIC,
                                            wxT("Charset Encoding"),
                                            wxDefaultPosition,
                                            wxDefaultSize);
  wxBoxSizer *charsetSizer = new wxStaticBoxSizer(charsetBox, wxHORIZONTAL);
  csSizer->Add(charsetSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *charsetCtrl = new wxListBox(this, ID_SCRIPT_CHARSET,
                                         wxDefaultPosition, wxDefaultSize,
                                         MainFrame->GetCharsetsLen(),
                                         MainFrame->GetCharsetsNames(),
                                         wxLB_SINGLE);
  charsetCtrl->
    SetFont(wxFont
            (8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL));
  int idSel = MainFrame->GetCharsetIndex(Default);
  if (idSel != wxNOT_FOUND)
    charsetCtrl->SetSelection(idSel);
  charsetSizer->Add(charsetCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & SqlScriptDialog::OnOk);
}

void SqlScriptDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxListBox *charsetCtrl = (wxListBox *) FindWindow(ID_SCRIPT_CHARSET);
  int idSel = charsetCtrl->GetSelection();
  if (idSel == wxNOT_FOUND)
    {
      wxMessageBox(wxT("you must select some Charset Encoding from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxString *charsets = MainFrame->GetCharsets();
  Charset = *(charsets + idSel);
  wxDialog::EndModal(wxID_OK);
}

bool DefaultCharsetDialog::Create(MyFrame * parent, wxString & charset,
                                  bool ask)
{
//
// creating the dialog
//
  MainFrame = parent;
  Charset = charset;
  AskCharset = ask;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Charset settings")) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void DefaultCharsetDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the DEFAULT CHARSET
  wxBoxSizer *csSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(csSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticBox *charsetBox = new wxStaticBox(this, wxID_STATIC,
                                            wxT("Default Output Charset"),
                                            wxDefaultPosition,
                                            wxDefaultSize);
  wxBoxSizer *charsetSizer = new wxStaticBoxSizer(charsetBox, wxVERTICAL);
  csSizer->Add(charsetSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *charsetCtrl = new wxListBox(this, ID_DFLT_CHARSET,
                                         wxDefaultPosition, wxDefaultSize,
                                         MainFrame->GetCharsetsLen(),
                                         MainFrame->GetCharsetsNames(),
                                         wxLB_SINGLE);
  charsetCtrl->
    SetFont(wxFont
            (8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL));
  int idSel = MainFrame->GetCharsetIndex(Charset);
  if (idSel != wxNOT_FOUND)
    charsetCtrl->SetSelection(idSel);
  charsetSizer->Add(charsetCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// second row: the ASK CHARSET
  wxBoxSizer *askSizer = new wxBoxSizer(wxHORIZONTAL);
  charsetSizer->Add(askSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxCheckBox *askCtrl = new wxCheckBox(this, ID_DFLT_ASK,
                                       wxT("Ask output charset every time"),
                                       wxDefaultPosition, wxDefaultSize);
  askCtrl->SetValue(AskCharset);
  askSizer->Add(askCtrl, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & DefaultCharsetDialog::OnOk);
}

void DefaultCharsetDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxListBox *charsetCtrl = (wxListBox *) FindWindow(ID_DFLT_CHARSET);
  int idSel = charsetCtrl->GetSelection();
  if (idSel == wxNOT_FOUND)
    {
      wxMessageBox(wxT
                   ("you must select some Default Charset Encoding from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxString *charsets = MainFrame->GetCharsets();
  Charset = *(charsets + idSel);
  wxCheckBox *askCtrl = (wxCheckBox *) FindWindow(ID_DFLT_ASK);
  AskCharset = askCtrl->GetValue();
  wxDialog::EndModal(wxID_OK);
}

bool RecoverDialog::Create(MyFrame * parent, wxString & table,
                           wxString & column)
{
//
// creating the dialog
//
  MainFrame = parent;
  Table = table;
  Column = column;
  Srid = -1;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Recover Geometry Column")) ==
      false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void RecoverDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// First row: TABLE name
  wxBoxSizer *tableSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(tableSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *tableLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Table name:"));
  tableSizer->Add(tableLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *tableCtrl = new wxTextCtrl(this, wxID_ANY, Table,
                                         wxDefaultPosition, wxSize(350, 22),
                                         wxTE_READONLY);
  tableCtrl->Enable(false);
  tableSizer->Add(tableCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: GEOMETRY COLUMN name
  wxBoxSizer *colSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(colSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *colLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Column name:"));
  colSizer->Add(colLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *colCtrl = new wxTextCtrl(this, wxID_ANY, Column,
                                       wxDefaultPosition, wxSize(350, 22),
                                       wxTE_READONLY);
  colCtrl->Enable(false);
  colSizer->Add(colCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// third row: SRID
  wxBoxSizer *sridSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(sridSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxStaticText *sridLabel = new wxStaticText(this, wxID_STATIC, wxT("&SRID:"));
  sridSizer->Add(sridLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxSpinCtrl *sridCtrl = new wxSpinCtrl(this, ID_RCVR_SRID, wxEmptyString,
                                        wxDefaultPosition, wxSize(80, 20),
                                        wxSP_ARROW_KEYS,
                                        -1, 40000, Srid);
  sridSizer->Add(sridCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// fourth row: GEOMETRY TYPE
  wxStaticBox *typeBox = new wxStaticBox(this, wxID_STATIC,
                                         wxT("Geometry Type"),
                                         wxDefaultPosition, wxDefaultSize);
  wxBoxSizer *typeSizer = new wxStaticBoxSizer(typeBox, wxHORIZONTAL);
  sridSizer->Add(typeSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxString types[7];
  types[0] = wxT("POINT");
  types[1] = wxT("MULTIPOINT");
  types[2] = wxT("LINESTRING");
  types[3] = wxT("MULTILINESTRING");
  types[4] = wxT("POLYGON");
  types[5] = wxT("MULTIPOLYGON");
  types[6] = wxT("GEOMETRYCOLLECTION");
  wxListBox *geomType = new wxListBox(this, ID_RCVR_TYPE,
                                      wxDefaultPosition, wxDefaultSize, 7,
                                      types, wxLB_SINGLE);
  typeSizer->Add(geomType, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & RecoverDialog::OnOk);
}

void RecoverDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxSpinCtrl *sridCtrl = (wxSpinCtrl *) FindWindow(ID_RCVR_SRID);
  wxListBox *geomType = (wxListBox *) FindWindow(ID_RCVR_TYPE);
  Srid = sridCtrl->GetValue();
  if (MainFrame->SridNotExists(Srid) == true)
    {
      wxMessageBox(wxT("invalid SRID value"), wxT("spatialite-gui"),
                   wxOK | wxICON_WARNING, this);
      return;
    }
  Type = geomType->GetStringSelection();
  if (Type.Len() < 1)
    {
      wxMessageBox(wxT("you must select some Geometry Type from the list"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxDialog::EndModal(wxID_OK);
}

bool SetSridDialog::Create(MyFrame * parent, wxString & table,
                           wxString & column)
{
//
// creating the dialog
//
  MainFrame = parent;
  Table = table;
  Column = column;
  OldSrid = -1;
  Srid = -1;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Changing SRID")) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void SetSridDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// First row: TABLE name
  wxBoxSizer *tableSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(tableSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *tableLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Table name:"));
  tableSizer->Add(tableLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *tableCtrl = new wxTextCtrl(this, wxID_ANY, Table,
                                         wxDefaultPosition, wxSize(350, 22),
                                         wxTE_READONLY);
  tableCtrl->Enable(false);
  tableSizer->Add(tableCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: GEOMETRY COLUMN name
  wxBoxSizer *colSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(colSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *colLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Column name:"));
  colSizer->Add(colLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *colCtrl = new wxTextCtrl(this, wxID_ANY, Column,
                                       wxDefaultPosition, wxSize(350, 22),
                                       wxTE_READONLY);
  colCtrl->Enable(false);
  colSizer->Add(colCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// third row: SRID
  wxBoxSizer *mySizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(mySizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxBoxSizer *oldSridSizer = new wxBoxSizer(wxHORIZONTAL);
  mySizer->Add(oldSridSizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxStaticText *oldSridLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&old SRID:"));
  oldSridSizer->Add(oldSridLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxSpinCtrl *oldSridCtrl = new wxSpinCtrl(this, ID_SRID_OLD, wxEmptyString,
                                           wxDefaultPosition, wxSize(80,
                                                                     20),
                                           wxSP_ARROW_KEYS,
                                           -1, 40000, OldSrid);
  oldSridSizer->Add(oldSridCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// fourth row: SRID
  wxBoxSizer *sridSizer = new wxBoxSizer(wxHORIZONTAL);
  mySizer->Add(sridSizer, 0, wxALIGN_RIGHT | wxLEFT, 20);
  wxStaticText *sridLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&new SRID:"));
  sridSizer->Add(sridLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxSpinCtrl *sridCtrl = new wxSpinCtrl(this, ID_SRID_SRID, wxEmptyString,
                                        wxDefaultPosition, wxSize(80, 20),
                                        wxSP_ARROW_KEYS,
                                        -1, 40000, Srid);
  sridSizer->Add(sridCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & SetSridDialog::OnOk);
}

void SetSridDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxSpinCtrl *oldSridCtrl = (wxSpinCtrl *) FindWindow(ID_SRID_OLD);
  wxSpinCtrl *sridCtrl = (wxSpinCtrl *) FindWindow(ID_SRID_SRID);
  OldSrid = oldSridCtrl->GetValue();
  Srid = sridCtrl->GetValue();
  wxDialog::EndModal(wxID_OK);
}

bool SearchSridDialog::Create(MyFrame * parent)
{
//
// creating the dialog
//
  MainFrame = parent;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Searching a SRID by its name")) ==
      false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void SearchSridDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// First row: SEARCH string
  wxBoxSizer *searchSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(searchSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *searchLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Search:"));
  searchSizer->Add(searchLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxTextCtrl *searchCtrl = new wxTextCtrl(this, ID_SEARCH, wxT(""),
                                          wxDefaultPosition, wxSize(150,
                                                                    22));
  searchSizer->Add(searchCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & SearchSridDialog::OnOk);
}

void SearchSridDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxTextCtrl *searchCtrl = (wxTextCtrl *) FindWindow(ID_SEARCH);
  String = searchCtrl->GetValue();
  if (String.Len() < 1)
    {
      wxMessageBox(wxT("You must specify a string to search for !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxDialog::EndModal(wxID_OK);
}

bool HelpDialog::Create(MyFrame * parent)
{
//
// creating the dialog
//
  MainFrame = parent;
  if (wxDialog::Create(parent, wxID_ANY, wxT("SQLite + SpatiaLite help"),
                       wxDefaultPosition, wxDefaultSize,
                       wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  MainFrame->OpenHelpPane();
  Centre();
// setting up an event handler [dialog closing]
  Connect(wxID_ANY, wxEVT_CLOSE_WINDOW,
          (wxObjectEventFunction) & HelpDialog::OnClose);
  return true;
}

void HelpDialog::OnClose(wxCloseEvent & WXUNUSED(event))
{
//
// this window has been closed
//
  MainFrame->CloseHelpPane();
  Destroy();
}

void HelpDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxHtmlWindow *helpWin = new wxHtmlWindow(this, ID_HELP_HTML,
                                           wxDefaultPosition, wxSize(400,
                                                                     200));
  wxString html;
  MainFrame->GetHelp(html);
  helpWin->SetPage(html);
  topSizer->Add(helpWin, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  Connect(wxID_ANY, wxEVT_SIZE, (wxObjectEventFunction) & HelpDialog::OnSize);
}

void HelpDialog::OnSize(wxSizeEvent & WXUNUSED(event))
{
//
// this window has changed its size
//
  wxSize sz = GetClientSize();
  wxHtmlWindow *helpWin = (wxHtmlWindow *) FindWindow(ID_HELP_HTML);
  helpWin->SetSize(sz.GetWidth() - 6, sz.GetHeight() - 6);
}

bool NetworkDialog::Create(MyFrame * parent)
{
//
// creating the dialog
//
  MainFrame = parent;
  FromColumn = wxT("");
  ToColumn = wxT("");
  GeomColumn = wxT("");
  GeomLength = true;
  CostColumn = wxT("");
  Bidirectional = true;
  OneWays = false;
  OneWayFromTo = wxT("");
  OneWayToFrom = wxT("");
  if (wxDialog::Create(parent, wxID_ANY, wxT("Build Network")) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void NetworkDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxBoxSizer *row0Sizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(row0Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: first column: the Main TABLE
  wxBoxSizer *tableSizer = new wxBoxSizer(wxHORIZONTAL);
  row0Sizer->Add(tableSizer, 0, wxALIGN_CENTRE_VERTICAL | wxALL, 0);
  wxStaticBox *tableBox = new wxStaticBox(this, wxID_STATIC,
                                          wxT("Base Table [graph]"),
                                          wxDefaultPosition,
                                          wxDefaultSize);
  wxBoxSizer *tableNameSizer = new wxStaticBoxSizer(tableBox, wxVERTICAL);
  tableSizer->Add(tableNameSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  int nTables;
  wxString *tables = MainFrame->GetTables(&nTables);
  wxListBox *tableCtrl = new wxListBox(this, ID_NET_TABLE,
                                       wxDefaultPosition, wxDefaultSize,
                                       nTables, tables, wxLB_SINGLE);
  delete[]tables;
  tableNameSizer->Add(tableCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
  wxSize size = tableCtrl->GetSize();
  size.SetHeight(size.GetHeight() / 2);
// first row: second column: the NodeFrom COLUMN
  wxBoxSizer *netSizer = new wxBoxSizer(wxHORIZONTAL);
  row0Sizer->Add(netSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticBox *netBox = new wxStaticBox(this, wxID_STATIC,
                                        wxT("Network configuration"),
                                        wxDefaultPosition,
                                        wxDefaultSize);
  wxBoxSizer *colSizer = new wxStaticBoxSizer(netBox, wxVERTICAL);
  netSizer->Add(colSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxBoxSizer *row1Sizer = new wxBoxSizer(wxHORIZONTAL);
  colSizer->Add(row1Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxBoxSizer *fromSizer = new wxBoxSizer(wxHORIZONTAL);
  row1Sizer->Add(fromSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticBox *fromBox = new wxStaticBox(this, wxID_STATIC,
                                         wxT("NodeFrom Column"),
                                         wxDefaultPosition,
                                         wxDefaultSize);
  wxBoxSizer *fromColSizer = new wxStaticBoxSizer(fromBox, wxVERTICAL);
  fromSizer->Add(fromColSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *fromCtrl = new wxListBox(this, ID_NET_FROM,
                                      wxDefaultPosition, size,
                                      0, NULL, wxLB_SINGLE);
  fromCtrl->Enable(false);
  fromColSizer->Add(fromCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// first row: third column: the NodeTo COLUMN
  wxBoxSizer *toSizer = new wxBoxSizer(wxHORIZONTAL);
  row1Sizer->Add(toSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticBox *toBox = new wxStaticBox(this, wxID_STATIC,
                                       wxT("NodeTo Column"),
                                       wxDefaultPosition,
                                       wxDefaultSize);
  wxBoxSizer *toColSizer = new wxStaticBoxSizer(toBox, wxVERTICAL);
  toSizer->Add(toColSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *toCtrl = new wxListBox(this, ID_NET_TO,
                                    wxDefaultPosition, size,
                                    0, NULL, wxLB_SINGLE);
  toCtrl->Enable(false);
  toColSizer->Add(toCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// first row: fourth column: the Geometry COLUMN
  wxBoxSizer *geoSizer = new wxBoxSizer(wxHORIZONTAL);
  row1Sizer->Add(geoSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticBox *geoBox = new wxStaticBox(this, wxID_STATIC,
                                        wxT("Geometry Column"),
                                        wxDefaultPosition,
                                        wxDefaultSize);
  wxBoxSizer *geoColSizer = new wxStaticBoxSizer(geoBox, wxVERTICAL);
  toSizer->Add(geoColSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *geoCtrl = new wxListBox(this, ID_NET_GEOM,
                                     wxDefaultPosition, size,
                                     0, NULL, wxLB_SINGLE);
  geoCtrl->Enable(false);
  geoColSizer->Add(geoCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// second row: first column: UNIDIRECTIONAL / BIDIRECTIONAL
  wxBoxSizer *row2Sizer = new wxBoxSizer(wxHORIZONTAL);
  colSizer->Add(row2Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxString dirs[2];
  dirs[0] = wxT("&Uni-Directional");
  dirs[1] = wxT("&Bi-Directional");
  wxRadioBox *dirSel = new wxRadioBox(this, ID_NET_BIDIR,
                                      wxT("&Arc connections"),
                                      wxDefaultPosition,
                                      wxDefaultSize, 2,
                                      dirs, 2,
                                      wxRA_SPECIFY_ROWS);
  dirSel->SetSelection(1);
  dirSel->Enable(false);
  row2Sizer->Add(dirSel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// second row: second column: the COST is GLenth selection
  wxString costs[2];
  costs[0] = wxT("&Using GLength(Geometry) as Cost");
  costs[1] = wxT("&Using Cost Column");
  wxRadioBox *costSel = new wxRadioBox(this, ID_NET_LENGTH,
                                       wxT("&Cost type"),
                                       wxDefaultPosition,
                                       wxDefaultSize, 2,
                                       costs, 2,
                                       wxRA_SPECIFY_ROWS);
  costSel->SetSelection(0);
  costSel->Enable(false);
  row2Sizer->Add(costSel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// second row: third column: the COST COLUMN    
  wxBoxSizer *costSizer = new wxBoxSizer(wxHORIZONTAL);
  row2Sizer->Add(costSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticBox *costBox = new wxStaticBox(this, wxID_STATIC,
                                         wxT("Cost Column"),
                                         wxDefaultPosition,
                                         wxDefaultSize);
  wxBoxSizer *costColSizer = new wxStaticBoxSizer(costBox, wxVERTICAL);
  costSizer->Add(costColSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *costCtrl = new wxListBox(this, ID_NET_COST,
                                      wxDefaultPosition, size,
                                      0, NULL, wxLB_SINGLE);
  costCtrl->Enable(false);
  costColSizer->Add(costCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// third row: second column: the OneWay Selection
  wxBoxSizer *row3Sizer = new wxBoxSizer(wxHORIZONTAL);
  colSizer->Add(row3Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxString oneWays[2];
  oneWays[0] = wxT("&Not using OneWay Columns");
  oneWays[1] = wxT("&Using OneWay Columns");
  wxRadioBox *oneWaySel = new wxRadioBox(this, ID_NET_ONEWAY,
                                         wxT("&OneWays"),
                                         wxDefaultPosition,
                                         wxDefaultSize, 2,
                                         oneWays, 2,
                                         wxRA_SPECIFY_ROWS);
  oneWaySel->SetSelection(0);
  oneWaySel->Enable(false);
  row3Sizer->Add(oneWaySel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// third row: second column: the OneWay FromTo COLUMN
  wxBoxSizer *fromToSizer = new wxBoxSizer(wxHORIZONTAL);
  row3Sizer->Add(fromToSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticBox *fromToBox = new wxStaticBox(this, wxID_STATIC,
                                           wxT("From -> To Column"),
                                           wxDefaultPosition,
                                           wxDefaultSize);
  wxBoxSizer *fromToColSizer = new wxStaticBoxSizer(fromToBox, wxVERTICAL);
  fromToSizer->Add(fromToColSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *fromToCtrl = new wxListBox(this, ID_NET_FROM_TO,
                                        wxDefaultPosition, size,
                                        0, NULL, wxLB_SINGLE);
  fromToCtrl->Enable(false);
  fromToColSizer->Add(fromToCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// fourth row: second column: the OneWay To From COLUMN
  wxBoxSizer *toFromSizer = new wxBoxSizer(wxHORIZONTAL);
  row3Sizer->Add(toFromSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticBox *toFromBox = new wxStaticBox(this, wxID_STATIC,
                                           wxT("To -> From Column"),
                                           wxDefaultPosition,
                                           wxDefaultSize);
  wxBoxSizer *toFromColSizer = new wxStaticBoxSizer(toFromBox, wxVERTICAL);
  toFromSizer->Add(toFromColSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxListBox *toFromCtrl = new wxListBox(this, ID_NET_TO_FROM,
                                        wxDefaultPosition, size,
                                        0, NULL, wxLB_SINGLE);
  toFromCtrl->Enable(false);
  toFromColSizer->Add(toFromCtrl, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & NetworkDialog::OnOk);
// appends event handlers for radio buttons etc
  Connect(ID_NET_TABLE, wxEVT_COMMAND_LISTBOX_SELECTED,
          (wxObjectEventFunction) & NetworkDialog::OnTable);
  Connect(ID_NET_BIDIR, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & NetworkDialog::OnDirection);
  Connect(ID_NET_LENGTH, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & NetworkDialog::OnCost);
  Connect(ID_NET_ONEWAY, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & NetworkDialog::OnOneWay);
}

void NetworkDialog::OnTable(wxCommandEvent & WXUNUSED(event))
{
//
// TABLE selection changed
//
  wxListBox *tableCtrl = (wxListBox *) FindWindow(ID_NET_TABLE);
  TableName = tableCtrl->GetStringSelection();
  int n_cols;
  wxString *columns = MainFrame->GetColumnNames(TableName, &n_cols);
  wxListBox *fromCtrl = (wxListBox *) FindWindow(ID_NET_FROM);
  fromCtrl->Clear();
  fromCtrl->InsertItems(n_cols, columns, 0);
  fromCtrl->Enable(true);
  wxListBox *toCtrl = (wxListBox *) FindWindow(ID_NET_TO);
  toCtrl->Clear();
  toCtrl->InsertItems(n_cols, columns, 0);
  toCtrl->Enable(true);
  wxListBox *geomCtrl = (wxListBox *) FindWindow(ID_NET_GEOM);
  geomCtrl->Clear();
  geomCtrl->InsertItems(n_cols, columns, 0);
  geomCtrl->Enable(true);
  wxListBox *costCtrl = (wxListBox *) FindWindow(ID_NET_COST);
  costCtrl->Clear();
  costCtrl->InsertItems(n_cols, columns, 0);
  costCtrl->Enable(false);
  wxListBox *fromToCtrl = (wxListBox *) FindWindow(ID_NET_FROM_TO);
  fromToCtrl->Clear();
  fromToCtrl->InsertItems(n_cols, columns, 0);
  fromToCtrl->Enable(false);
  wxListBox *toFromCtrl = (wxListBox *) FindWindow(ID_NET_TO_FROM);
  toFromCtrl->Clear();
  toFromCtrl->InsertItems(n_cols, columns, 0);
  toFromCtrl->Enable(false);
  wxRadioBox *dirSel = (wxRadioBox *) FindWindow(ID_NET_BIDIR);
  Bidirectional = true;
  dirSel->SetSelection(1);
  dirSel->Enable(true);
  wxRadioBox *costSel = (wxRadioBox *) FindWindow(ID_NET_LENGTH);
  GeomLength = true;
  costSel->SetSelection(0);
  costSel->Enable(true);
  wxRadioBox *oneWaySel = (wxRadioBox *) FindWindow(ID_NET_ONEWAY);
  OneWays = false;
  oneWaySel->SetSelection(0);
  oneWaySel->Enable(true);
}

void NetworkDialog::OnDirection(wxCommandEvent & WXUNUSED(event))
{
//
// BIDIRECTIONAL radio box
//
  wxRadioBox *oneWaySel = (wxRadioBox *) FindWindow(ID_NET_ONEWAY);
  wxRadioBox *dirSel = (wxRadioBox *) FindWindow(ID_NET_BIDIR);
  wxListBox *fromToCtrl = (wxListBox *) FindWindow(ID_NET_FROM_TO);
  wxListBox *toFromCtrl = (wxListBox *) FindWindow(ID_NET_TO_FROM);
  if (Bidirectional == true)
    {
      Bidirectional = false;
      dirSel->SetSelection(0);
      OneWays = false;
      oneWaySel->SetSelection(0);
      oneWaySel->Enable(false);
      fromToCtrl->Enable(false);
      toFromCtrl->Enable(false);
  } else
    {
      Bidirectional = true;
      dirSel->SetSelection(1);
      OneWays = false;
      oneWaySel->SetSelection(0);
      oneWaySel->Enable(true);
      fromToCtrl->Enable(false);
      toFromCtrl->Enable(false);
    }
}

void NetworkDialog::OnCost(wxCommandEvent & WXUNUSED(event))
{
//
// COST radio box
//
  wxRadioBox *costSel = (wxRadioBox *) FindWindow(ID_NET_LENGTH);
  wxListBox *costCtrl = (wxListBox *) FindWindow(ID_NET_COST);
  if (GeomLength == true)
    {
      GeomLength = false;
      costSel->SetSelection(1);
      costCtrl->Enable(true);
  } else
    {
      GeomLength = true;
      costSel->SetSelection(0);
      costCtrl->Enable(false);
    }
}

void NetworkDialog::OnOneWay(wxCommandEvent & WXUNUSED(event))
{
//
// OneWay radio box
//
  wxRadioBox *oneWaySel = (wxRadioBox *) FindWindow(ID_NET_ONEWAY);
  wxListBox *fromToCtrl = (wxListBox *) FindWindow(ID_NET_FROM_TO);
  wxListBox *toFromCtrl = (wxListBox *) FindWindow(ID_NET_TO_FROM);
  if (OneWays == true)
    {
      OneWays = false;
      oneWaySel->SetSelection(0);
      fromToCtrl->Enable(false);
      toFromCtrl->Enable(false);
  } else
    {
      OneWays = true;
      oneWaySel->SetSelection(1);
      fromToCtrl->Enable(true);
      toFromCtrl->Enable(true);
    }
}

void NetworkDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxListBox *tableCtrl = (wxListBox *) FindWindow(ID_NET_TABLE);
  TableName = tableCtrl->GetStringSelection();
  if (TableName.Len() < 1)
    {
      wxMessageBox(wxT("You must select some TABLE NAME !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxListBox *fromCtrl = (wxListBox *) FindWindow(ID_NET_FROM);
  FromColumn = fromCtrl->GetStringSelection();
  if (FromColumn.Len() < 1)
    {
      wxMessageBox(wxT("You must select some 'NodeFrom' COLUMN !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxListBox *toCtrl = (wxListBox *) FindWindow(ID_NET_TO);
  ToColumn = toCtrl->GetStringSelection();
  if (ToColumn.Len() < 1)
    {
      wxMessageBox(wxT("You must select some 'NodeTo' COLUMN !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  wxListBox *geomCtrl = (wxListBox *) FindWindow(ID_NET_GEOM);
  GeomColumn = geomCtrl->GetStringSelection();
  if (GeomColumn.Len() < 1)
    {
      wxMessageBox(wxT("You must select some 'Geometry' COLUMN !!!"),
                   wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
      return;
    }
  if (GeomLength == true)
    CostColumn = wxT("");
  else
    {
      wxListBox *costCtrl = (wxListBox *) FindWindow(ID_NET_COST);
      CostColumn = costCtrl->GetStringSelection();
      if (CostColumn.Len() < 1)
        {
          wxMessageBox(wxT("You must select some 'Cost' COLUMN !!!"),
                       wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
          return;
        }
    }
  if (Bidirectional == true && OneWays == true)
    {
      wxListBox *fromToCtrl = (wxListBox *) FindWindow(ID_NET_FROM_TO);
      OneWayFromTo = fromToCtrl->GetStringSelection();
      if (OneWayFromTo.Len() < 1)
        {
          wxMessageBox(wxT("You must select some 'OneWay From->To' COLUMN !!!"),
                       wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
          return;
        }
      wxListBox *toFromCtrl = (wxListBox *) FindWindow(ID_NET_TO_FROM);
      OneWayToFrom = toFromCtrl->GetStringSelection();
      if (OneWayToFrom.Len() < 1)
        {
          wxMessageBox(wxT("You must select some 'OneWay To->From' COLUMN !!!"),
                       wxT("spatialite-gui"), wxOK | wxICON_WARNING, this);
          return;
        }
  } else
    {
      OneWayFromTo = wxT("");
      OneWayToFrom = wxT("");
    }
  wxDialog::EndModal(wxID_OK);
}

bool ExifDialog::Create(MyFrame * parent, wxString & dir_path,
                        wxString & img_path)
{
//
// creating the dialog
//
  MainFrame = parent;
  DirPath = dir_path;
  ImgPath = img_path;
  Folder = false;
  Metadata = true;
  GpsOnly = false;
  if (wxDialog::Create(parent, wxID_ANY, wxT("Import EXIF Photos")) == false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void ExifDialog::CreateControls()
{
//
// creating individual control and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxBoxSizer *row0Sizer = new wxBoxSizer(wxVERTICAL);
  boxSizer->Add(row0Sizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: the path and file/folder selection
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  row0Sizer->Add(pathSizer, 0, wxALIGN_CENTRE_VERTICAL | wxALL, 0);
  wxStaticBox *pathBox = new wxStaticBox(this, wxID_STATIC,
                                         wxT("Import from source"),
                                         wxDefaultPosition,
                                         wxDefaultSize);
  wxBoxSizer *pthSizer = new wxStaticBoxSizer(pathBox, wxVERTICAL);
  pathSizer->Add(pthSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
  wxStaticText *pathLabel = new wxStaticText(this, ID_EXIF_PATH, ImgPath);
  pthSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 0);
  wxString imgFolder[2];
  imgFolder[0] = wxT("Import &selected image only");
  imgFolder[1] = wxT("Import &any EXIF from selected folder");
  wxRadioBox *imgFolderSel = new wxRadioBox(this, ID_EXIF_FOLDER,
                                            wxT("&Source selection"),
                                            wxDefaultPosition,
                                            wxDefaultSize, 2,
                                            imgFolder, 2,
                                            wxRA_SPECIFY_ROWS);
  imgFolderSel->SetSelection(0);
  pthSizer->Add(imgFolderSel, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// second row: the metadata and gps-only selection
  wxBoxSizer *modeSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(modeSizer, 0, wxALIGN_CENTRE_HORIZONTAL | wxALL, 0);
  wxString metadata[2];
  metadata[0] = wxT("Feed full EXIF &Metadata");
  metadata[1] = wxT("&Skip EXIF Metadata");
  wxRadioBox *metadataSel = new wxRadioBox(this, ID_EXIF_METADATA,
                                           wxT("&EXIF Metadata tables"),
                                           wxDefaultPosition,
                                           wxDefaultSize, 2,
                                           metadata, 2,
                                           wxRA_SPECIFY_ROWS);
  metadataSel->SetSelection(0);
  modeSizer->Add(metadataSel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxString gpsOnly[2];
  gpsOnly[0] = wxT("Import any EXIF file");
  gpsOnly[1] = wxT("Import EXIF only if containing &GPS tags");
  wxRadioBox *gpsOnlySel = new wxRadioBox(this, ID_EXIF_GPS_ONLY,
                                          wxT("&GPS position"),
                                          wxDefaultPosition,
                                          wxDefaultSize, 2,
                                          gpsOnly, 2,
                                          wxRA_SPECIFY_ROWS);
  gpsOnlySel->SetSelection(0);
  modeSizer->Add(gpsOnlySel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & ExifDialog::OnOk);
// appends event handlers for radio buttons etc
  Connect(ID_EXIF_FOLDER, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & ExifDialog::OnFolder);
  Connect(ID_EXIF_METADATA, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & ExifDialog::OnMetadata);
  Connect(ID_EXIF_GPS_ONLY, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & ExifDialog::OnGpsOnly);
}

void ExifDialog::OnFolder(wxCommandEvent & WXUNUSED(event))
{
//
// File/Folder radio box
//
  wxRadioBox *folderSel = (wxRadioBox *) FindWindow(ID_EXIF_FOLDER);
  wxStaticText *pathLabel = (wxStaticText *) FindWindow(ID_EXIF_PATH);
  if (Folder == true)
    {
      Folder = false;
      folderSel->SetSelection(0);
      pathLabel->SetLabel(ImgPath);
  } else
    {
      Folder = true;
      folderSel->SetSelection(1);
      pathLabel->SetLabel(DirPath);
    }
}

void ExifDialog::OnMetadata(wxCommandEvent & WXUNUSED(event))
{
//
// Metadata radio box
//
  wxRadioBox *metadataSel = (wxRadioBox *) FindWindow(ID_EXIF_METADATA);
  if (Metadata == true)
    {
      Metadata = false;
      metadataSel->SetSelection(1);
  } else
    {
      Metadata = true;
      metadataSel->SetSelection(0);
    }
}

void ExifDialog::OnGpsOnly(wxCommandEvent & WXUNUSED(event))
{
//
// GpsOnly radio box
//
  wxRadioBox *gpsOnlySel = (wxRadioBox *) FindWindow(ID_EXIF_GPS_ONLY);
  if (GpsOnly == true)
    {
      GpsOnly = false;
      gpsOnlySel->SetSelection(0);
  } else
    {
      GpsOnly = true;
      gpsOnlySel->SetSelection(1);
    }
}

void ExifDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxDialog::EndModal(wxID_OK);
}

bool AutoSaveDialog::Create(MyFrame * parent, wxString & path, int secs)
{
//
// creating the dialog
//
  MainFrame = parent;
  Path = path;
  Seconds = secs;
  if (wxDialog::Create(parent, wxID_ANY, wxT("MEMORY-DB AutoSave settings")) ==
      false)
    return false;
// populates individual controls
  CreateControls();
// sets dialog sizer
  GetSizer()->Fit(this);
  GetSizer()->SetSizeHints(this);
// centers the dialog window
  Centre();
  return true;
}

void AutoSaveDialog::CreateControls()
{
//
// creating individual controls and setting initial values
//
  wxBoxSizer *topSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(topSizer);
  wxBoxSizer *boxSizer = new wxBoxSizer(wxVERTICAL);
  topSizer->Add(boxSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5);
// first row: export path
  wxBoxSizer *pathSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(pathSizer, 0, wxALIGN_RIGHT | wxALL, 0);
  wxStaticText *pathLabel =
    new wxStaticText(this, wxID_STATIC, wxT("&Save as:"));
  pathSizer->Add(pathLabel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxString pth = Path;
  if (pth.Len() == 0)
    pth = wxT("*** not set: AutoSave IS DISABLED ***");
  PathCtrl = new wxTextCtrl(this, ID_AUTO_SAVE_PATH, pth, wxDefaultPosition,
                            wxSize(350, 22), wxTE_READONLY);
  pathSizer->Add(PathCtrl, 0, wxALIGN_RIGHT | wxALL, 5);
// second row: CHANGE PATH button
  wxBoxSizer *changeBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(changeBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *change =
    new wxButton(this, ID_AUTO_SAVE_CHANGE_PATH, wxT("&Set the export path"));
  changeBox->Add(change, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// third row: INTERVAL
  wxBoxSizer *modeSizer = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(modeSizer, 0, wxALIGN_LEFT | wxALL, 0);
  wxString modes[6];
  modes[0] = wxT("&Disable AutoSaving");
  modes[1] = wxT("Every &30 seconds");
  modes[2] = wxT("Every &minute");
  modes[3] = wxT("Every &2 minutes");
  modes[4] = wxT("Every &5 minutes");
  modes[5] = wxT("Every &10 minutes");
  IntervalCtrl = new wxRadioBox(this, ID_AUTO_SAVE_INTERVAL,
                                wxT("&AutoSave interval"),
                                wxDefaultPosition, wxDefaultSize, 6, modes, 6,
                                wxRA_SPECIFY_ROWS);
  if (Seconds <= 0)
    IntervalCtrl->SetSelection(0);
  else if (Seconds <= 30)
    IntervalCtrl->SetSelection(1);
  else if (Seconds <= 60)
    IntervalCtrl->SetSelection(2);
  else if (Seconds <= 120)
    IntervalCtrl->SetSelection(3);
  else if (Seconds <= 300)
    IntervalCtrl->SetSelection(4);
  else
    IntervalCtrl->SetSelection(5);
  modeSizer->Add(IntervalCtrl, 0, wxALIGN_RIGHT | wxALL, 5);

// OK - CANCEL buttons
  wxBoxSizer *okCancelBox = new wxBoxSizer(wxHORIZONTAL);
  boxSizer->Add(okCancelBox, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 0);
  wxButton *ok = new wxButton(this, wxID_OK, wxT("&OK"));
  okCancelBox->Add(ok, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
  wxButton *cancel = new wxButton(this, wxID_CANCEL, wxT("&Cancel"));
  okCancelBox->Add(cancel, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
// appends event handler for OK button
  Connect(wxID_OK, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & AutoSaveDialog::OnOk);
  Connect(ID_AUTO_SAVE_CHANGE_PATH, wxEVT_COMMAND_BUTTON_CLICKED,
          (wxObjectEventFunction) & AutoSaveDialog::OnChangePath);
  Connect(ID_AUTO_SAVE_INTERVAL, wxEVT_COMMAND_RADIOBOX_SELECTED,
          (wxObjectEventFunction) & AutoSaveDialog::OnIntervalChanged);
}

void AutoSaveDialog::OnChangePath(wxCommandEvent & WXUNUSED(event))
{
//
//  exporting the MEMORY-DB into an external DB 
//
  int retdlg;
  wxString lastDir;
  wxFileDialog *fileDialog = new wxFileDialog(this, wxT("Saving the MEMORY-DB"),
                                              wxT(""), wxT("db.sqlite"),
                                              wxT
                                              ("SQLite DB (*.sqlite)|*.sqlite|All files (*.*)|*.*"),
                                              wxFD_SAVE | wxFD_OVERWRITE_PROMPT,
                                              wxDefaultPosition,
                                              wxDefaultSize,
                                              wxT("filedlg"));
  lastDir = MainFrame->GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  retdlg = fileDialog->ShowModal();
  if (retdlg == wxID_OK)
    {
      // exporting the external DB
      wxString pth = fileDialog->GetPath();
      wxString extPth = wxT("*** not set: AutoSave IS DISABLED ***");
      MainFrame->SetExternalSqlitePath(pth);
      if (MainFrame->MemoryDbSave() == true)
        {
          wxMessageBox(wxT("Ok, MEMORY-DB was succesfully saved"),
                       wxT("spatialite-gui"), wxOK | wxICON_INFORMATION, this);
          wxFileName file(fileDialog->GetPath());
          lastDir = file.GetPath();
          MainFrame->SetLastDirectory(lastDir);
          extPth = MainFrame->GetExternalSqlitePath();
          PathCtrl->SetValue(extPth);
      } else
        PathCtrl->SetValue(extPth);
    }
}

void AutoSaveDialog::OnIntervalChanged(wxCommandEvent & WXUNUSED(event))
{
//
// Interval selection changed
//
  if (IntervalCtrl->GetSelection() == 0)
    Seconds = 0;
  else if (IntervalCtrl->GetSelection() == 1)
    Seconds = 30;
  else if (IntervalCtrl->GetSelection() == 2)
    Seconds = 60;
  else if (IntervalCtrl->GetSelection() == 3)
    Seconds = 120;
  else if (IntervalCtrl->GetSelection() == 4)
    Seconds = 300;
  else
    Seconds = 600;
}

void AutoSaveDialog::OnOk(wxCommandEvent & WXUNUSED(event))
{
//
// all done: 
//
  wxDialog::EndModal(wxID_OK);
}
