
% animio.sl:	simple S-Lang wrapper to homogenize interface to multiple
%		animation file formats;  initially written to shield
%		SLgtk imdisplay() utility from direct knowledge of GIF
%		file format; qualifiers unsupported by underlying modules
%		will be silently ignored; frame delays are in units of
%		millisec
%               This file is part of SLgtk, the S-Lang bindings to Gtk.
%               Copyright (C) 2003-2010 Massachusetts Institute of Technology
%               Copyright (C) 2002 Michael S. Noble (mnoble@space.mit.edu)

private variable Modules = {};
private variable Readers = Assoc_Type[Any_Type, NULL];
private variable Writers = Assoc_Type[Any_Type, NULL];

private define _require(module)  % {{{
{
   variable err = NULL;

   try (err) { require(module); }

   finally {
	if (err == NULL) {
	   list_append(Modules, module);
	   Readers[module] = eval("&$module"$ + "_read", _current_namespace);
	   Writers[module] = eval("&$module"$ + "_write", _current_namespace);
	}
	else if (err.error != OpenError)
	   throw err.error;
   }
}  % }}}

_require("gif");

define anim_read()  % {{{
{
   variable args = __pop_list(_NARGS);
   variable reader = qualifier("type", NULL);

   if (reader != NULL) {

	reader = Readers[reader];
	if (reader == NULL)
	   error("Invalid file type qualifier: $type"$);

	return (@reader) ( __push_list(args) ;; __qualifiers());
   }

   foreach reader (Readers) using ("values") {
	variable image = (@reader) (__push_list(args) ;; __qualifiers());
	if (image != NULL)
	   return image;
   }

   return NULL;
}  % }}}

define anim_write()  % {{{
{
   variable args = __pop_list(_NARGS);
   variable type = qualifier("type", NULL);

   if (type != NULL)
	type = Writers[type];

   if (type == NULL)
	error("A valid 'type=' qualifier must be passed to anim_write()");

   return (@type)( __push_list(args) ;; __qualifiers());

}  % }}}

provide("animio");
