%  SLgtk: S-Lang language bindings for GTK+ widget set
%
%  Copyright (c) 2003 Massachusetts Institute of Technology
%  Copyright (C) 2002 Michael S. Noble <mnoble@cfa.harvard.edu>
%
%  This software was partially developed by the MIT Center for Space
%  Research under contract SV1-61010 from the Smithsonian Institution.
%  
%  Permission to use, copy, modify, distribute, and sell this software
%  and its documentation for any purpose is hereby granted without fee,
%  provided that the above copyright notice appear in all copies and
%  that both that copyright notice and this permission notice appear in
%  the supporting documentation, and that the name of the Massachusetts
%  Institute of Technology not be used in advertising or publicity
%  pertaining to distribution of the software without specific, written
%  prior permission.  The Massachusetts Institute of Technology makes
%  no representations about the suitability of this software for any
%  purpose.  It is provided "as is" without express or implied warranty.
%  
%  THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY DISCLAIMS ALL WARRANTIES
%  WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
%  MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE MASSACHUSETTS
%  INSTITUTE OF TECHNOLOGY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
%  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
%  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
%  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
%  WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

require("toolbox");

static define canvas_mouse_drag(canvas,event)
{
   vmessage("mouse drag to (%S,%S)",event.x,event.y);
   return TRUE;
}

static define canvas_mouse_up(canvas,event)
{
   variable id = g_object_get_data (canvas, "drag_handler_id");
   g_signal_handler_disconnect(canvas,id);
   return FALSE;
}

static define canvas_mouse_down(canvas,event)
{
   variable id = g_signal_connect(canvas,"motion_notify_event",
	 					&canvas_mouse_drag);
   g_object_set_data (canvas, "drag_handler_id", id);
   return TRUE;
}

static define tbox_stub(tb,data)
{
   % Note that the "clicked" signal will be emitted for both the tool being
   % chosen AND the tool previously chosen.   This is a Gtk implementation 
   % blemish (discussed in the mail archives) which for historical reasons
   % has not been corrected yet.  The caller should be mindful of this, and 
   % implement their callbacks (i.e. the elements of tb.funcs) accordingly.
   %
   % The toolbox implementation attempts to compensate for this by calling
   % the func registered for a given button ONLY when that button was not
   % previously selected.
   vmessage("button pressed: %S",tb.curr);
}

static define canvas_new()
{
   variable c = gtk_layout_new(NULL,NULL);
   gtk_widget_add_events (c, GDK_BUTTON_PRESS_MASK 
			| GDK_BUTTON_RELEASE_MASK 
   			| GDK_POINTER_MOTION_MASK);
   () = g_signal_connect(c,"button_press_event",&canvas_mouse_down);
   () = g_signal_connect(c,"button_release_event",&canvas_mouse_up);
   variable label = gtk_label_new("Click and drag mouse to see coordinates");
   gtk_layout_put(c,label,50,80);
   return c;
}

static variable window = NULL;
public define create_slgtktoolbox(test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(window, "Graphical Toolbox");
	gtk_window_set_default_size(window,450,350);
	() = g_signal_connect (window,"destroy",&gtk_widget_destroyed,&window);

	variable main_vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(window,main_vbox);

	% Section main window into 2 pieces, the right portion for graphics
	% display, and the left for the graphical operations toolbox.
	variable main_hbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(main_vbox,main_hbox);

	% Create left portion of window: the visual toolbox
	variable tframe = gtk_frame_new("ToolBox");
	variable tbox = toolbox_new();

	toolbox_add_button(tbox, GTK_STOCK_INDEX, "Select", &tbox_stub,);
	toolbox_add_button(tbox, GTK_STOCK_ADD, "Add", &tbox_stub, );
	toolbox_add_button(tbox, GTK_STOCK_ZOOM_IN, "ZoomIn", &tbox_stub, );
	toolbox_add_button(tbox, GTK_STOCK_ZOOM_OUT, "ZoomOut", &tbox_stub, );

	toolbox_set_focusable(tbox, "ZoomIn", FALSE);
	toolbox_set_focusable(tbox, "ZoomOut", FALSE);

	gtk_container_add(tframe,tbox.widget);
	gtk_box_pack_start(main_hbox,tframe,FALSE,FALSE,0);

	% Create right portion of window: the drawing area
	variable cframe = gtk_frame_new("Canvas");
	variable canvas = canvas_new();
	gtk_container_add(cframe,canvas);
	gtk_container_add(main_hbox,cframe);

	test.lower = gtk_button_new_with_label("Quit");
	() = g_signal_connect_swapped(test.lower, "clicked",
						&gtk_widget_destroy,window);
	gtk_box_pack_end(main_vbox,test.lower,FALSE,FALSE,5);
   }

   if (gtk_widget_visible (window)) {
	gtk_widget_destroy (window);
   }
   else
	gtk_widget_show_all (window);
}
