static variable window = NULL;

static define rotate(button,cbdata)
{
   cbdata.tabpos = (cbdata.tabpos + 1) mod 4;
   gtk_notebook_set_tab_pos(cbdata.nb,cbdata.tabpos);
}

static define switch_page(notebook,nbpage,pagenum,data)
{
   vmessage("Notebook: page switched to %d",pagenum);
}

define create_notebook (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(window, "SLgtk Notebook");

	() = g_signal_connect (window, "destroy",
				&gtk_widget_destroyed,
				&window);

	variable box1 = gtk_vbox_new(FALSE,10);
	gtk_container_add(window,box1);

	variable box2 = gtk_vbox_new(FALSE,10);
	gtk_container_set_border_width(box2,10);
	gtk_box_pack_start(box1,box2,TRUE,TRUE,0);

	variable notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(notebook,GTK_POS_TOP);
	gtk_box_pack_start(box2,notebook,TRUE,TRUE,0);

	variable i,label,frame;
	for (i=1; i<6; i++) {
	   frame = gtk_frame_new(sprintf("Page %d",i));
	   gtk_container_set_border_width(frame,10);
	   gtk_widget_set_usize( frame, 200, 150);
	   label = gtk_label_new(sprintf("Page %d",i));
	   gtk_container_add(frame,label);
	   label = gtk_label_new(sprintf("Tab %d",i));
	   gtk_notebook_append_page(notebook,frame,label);
	   if (_gtk_version >= 20400) pop;
	}

	variable separator = gtk_hseparator_new();
	gtk_box_pack_start(box1,separator,FALSE,TRUE,0);

	box2 = gtk_hbox_new(FALSE,10);
	gtk_container_set_border_width(box2,10);
	gtk_box_pack_start(box1,box2,FALSE,TRUE,0);

	variable button = gtk_button_new_with_label("close");
	() = g_signal_connect_swapped(button,"clicked",
				&gtk_widget_destroy,window);
	gtk_box_pack_start(box2,button,TRUE,TRUE,0);
	test.lower = button;

	button = gtk_button_new_with_label("next");
	() = g_signal_connect_swapped(button,"clicked",
				&gtk_notebook_next_page,notebook);
	gtk_box_pack_start(box2,button,TRUE,TRUE,0);

	button = gtk_button_new_with_label("prev");
	() = g_signal_connect_swapped(button,"clicked",
				&gtk_notebook_prev_page,notebook);
	gtk_box_pack_start(box2,button,TRUE,TRUE,0);

	() = g_signal_connect(notebook,"switch_page",&switch_page,NULL);

	button = gtk_button_new_with_label("rotate");
	variable callback_data = struct { nb, tabpos};
	callback_data.nb = notebook;
	callback_data.tabpos = GTK_POS_TOP;
	() = g_signal_connect(button,"clicked",&rotate,callback_data);
	gtk_box_pack_start(box2,button,TRUE,TRUE,0);
	gtk_widget_set_flags(button,GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
