
AC_PREREQ(2.52)

AC_DEFUN(AC_SLGTK_BINARY_INIT, dnl {{{
[

abs_builddir=`pwd`
if test "$abs_builddir" = "$prefix" ; then
   AC_MSG_ERROR([Using the current directory as the installation directory is prohibited])
fi

AC_PATH_PROG([slsh],[slsh],[],
   			[$PATH /usr/local/bin /opt/local/bin /usr/bin /bin])

if test -z "$slsh" ; then
   AC_MSG_ERROR([Cannot find an slsh installation])
fi

slsh_dir=`AS_DIRNAME($slsh)`
slsh_parent_dir=`AS_DIRNAME($slsh_dir)`
if test "x$prefix" = "xNONE" ; then
   prefix=$slsh_parent_dir
else
   if test "$prefix" != "$slsh_parent_dir" ; then
	AC_MSG_WARN([$prefix != parent directory of bin/slsh])
   fi
fi

AC_MSG_CHECKING(SLang version as reported by slsh)
dnl Refer to autoconf quadrigraphs to understand the syntax employed here
slang_major_ver=`$slsh <<EOT
vmessage("%S",strtok(_slang_version_string,".")@<:@0@:>@);
EOT`
AC_MSG_RESULT($slang_major_ver)

AC_MSG_CHECKING(That module was compiled with same S-Lang major version as slsh)
$slsh slangver.sl
if test $? -eq 0 ; then
   AC_MSG_RESULT(yes)
else
   AC_MSG_ERROR(no)
fi

slgtk_conf_dir=$sysconfdir/slgtk
case $slang_major_ver in
  1*) MODULE_INSTALL_RELATIVE_PATH=slang/modules ;;
  *) MODULE_INSTALL_RELATIVE_PATH=slang/v$slang_major_ver/modules ;;
esac
MODULE_INSTALL_DIR=$libdir/$MODULE_INSTALL_RELATIVE_PATH

SL_FILES_INSTALL_DIR=$datadir/slsh/local-packages
AC_SUBST(MODULE_INSTALL_DIR)
AC_SUBST(MODULE_INSTALL_RELATIVE_PATH)
AC_SUBST(SL_FILES_INSTALL_DIR)

AC_SUBST(slsh)
AC_SUBST(slgtk_conf_dir)
]) dnl }}}

AC_DEFUN(AC_SLGTK_BINARY_FONTCONFIG, dnl {{{
[

dnl  Copyright © 2003 Keith Packard {{{

dnl  {{{
dnl  Permission to use, copy, modify, distribute, and sell this software and its
dnl  documentation for any purpose is hereby granted without fee, provided that
dnl  the above copyright notice appear in all copies and that both that
dnl  copyright notice and this permission notice appear in supporting
dnl  documentation, and that the name of Keith Packard not be used in
dnl  advertising or publicity pertaining to distribution of the software without
dnl  specific, written prior permission.  Keith Packard makes no
dnl  representations about the suitability of this software for any purpose.  It
dnl  is provided "as is" without express or implied warranty.
dnl 
dnl  KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
dnl  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
dnl  EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
dnl  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
dnl  DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
dnl  TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
dnl  PERFORMANCE OF THIS SOFTWARE.
dnl  }}}

case "$host" in
  *-*-mingw*)
    os_win32=yes
    ;;
  *)
    os_win32=no
esac
dnl AM_CONDITIONAL(OS_WIN32, test "$os_win32" = "yes")

if test "$os_win32" = "yes"; then
  AC_CHECK_PROG(ms_librarian, lib.exe, yes, no)
fi
dnl AM_CONDITIONAL(MS_LIB_AVAILABLE, test x$ms_librarian = xyes)

#
# Set default font directory
#

AC_ARG_WITH(default-fonts,     [  --with-default-fonts=DIR      Use fonts from DIR when config is busted], default_fonts="$withval", default_fonts=yes)

case "$default_fonts" in
yes)
	if test "$os_win32" = "yes"; then
		FC_DEFAULT_FONTS="WINDOWSFONTDIR"
		AC_DEFINE_UNQUOTED(FC_DEFAULT_FONTS, "WINDOWSFONTDIR", 
				   [Windows font directory])
	else
		FC_DEFAULT_FONTS="/usr/share/fonts"
		AC_DEFINE_UNQUOTED(FC_DEFAULT_FONTS, "/usr/share/fonts", 
				   [System font directory])
	fi
	;;
*)
	FC_DEFAULT_FONTS="$default_fonts"
	AC_DEFINE_UNQUOTED(FC_DEFAULT_FONTS, "$default_fonts",
			   [System font directory])
	;;
esac

AC_SUBST(FC_DEFAULT_FONTS)

#
# Add more fonts if available.  By default, add only the directories
# with outline fonts; those with bitmaps can be added as desired in
# local.conf or ~/.fonts.conf
#
AC_ARG_WITH(add-fonts,        [  --with-add-fonts=DIR1,DIR2,...Find additional fonts in DIR1,DIR2,... ], add_fonts="$withval", add_fonts=yes)

case "$add_fonts" in
yes)
	FC_ADD_FONTS=""
	for dir in /usr/X11R6/lib/X11 /usr/X11/lib/X11 /usr/lib/X11; do
		case x"$FC_ADD_FONTS" in
		x)
			sub="$dir/fonts"
			if test -d "$sub"; then
				case x$FC_ADD_FONTS in
				x)
					FC_ADD_FONTS="$sub"
					;;
				*)
					FC_ADD_FONTS="$FC_ADD_FONTS,$sub"
					;;
				esac
			fi
			;;
		esac
	done
	AC_DEFINE_UNQUOTED(FC_ADD_FONTS,"$add_fonts",[Additional font directories])
	;;
no)
	FC_ADD_FONTS=""
	;;
*)
	FC_ADD_FONTS="$add_fonts"
	AC_DEFINE_UNQUOTED(FC_ADD_FONTS,"$add_fonts",[Additional font directories])
	;;
esac

AC_SUBST(FC_ADD_FONTS)

FC_FONTPATH=""

case "$FC_ADD_FONTS" in
"")
	;;
*)
	FC_FONTPATH=`echo $FC_ADD_FONTS | 
			sed -e 's/^/<dir>/' -e 's/$/<\/dir>/' -e 's/,/<\/dir> <dir>/g'`
	;;
esac

AC_SUBST(FC_FONTPATH)

#
# Set default cache directory path
#
AC_ARG_WITH(cache-dir,         [ --with-cache-dir=DIR           Use DIR to store cache files (default /var/cache/fontconfig)], fc_cachedir="$withval", fc_cachedir=yes)

case $fc_cachedir in
no|yes)
	fc_cachedir=`eval echo "${localstatedir}/cache/"${PACKAGE}`
	;;
*)
	;;
esac
AC_SUBST(fc_cachedir)
FC_CACHEDIR=${fc_cachedir}
AC_SUBST(FC_CACHEDIR)
dnl  }}}

]) dnl }}}
