#include "petscsys.h"
#include "petscfix.h"
/* solve.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssolve_ EPSSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssolve_ epssolve
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetiterationnumber_ EPSGETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetiterationnumber_ epsgetiterationnumber
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetoperationcounters_ EPSGETOPERATIONCOUNTERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetoperationcounters_ epsgetoperationcounters
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetconverged_ EPSGETCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetconverged_ epsgetconverged
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetinvariantsubspace_ EPSGETINVARIANTSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetinvariantsubspace_ epsgetinvariantsubspace
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetinvariantsubspaceleft_ EPSGETINVARIANTSUBSPACELEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetinvariantsubspaceleft_ epsgetinvariantsubspaceleft
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeteigenpair_ EPSGETEIGENPAIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeteigenpair_ epsgeteigenpair
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeteigenvalue_ EPSGETEIGENVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeteigenvalue_ epsgeteigenvalue
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeteigenvector_ EPSGETEIGENVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeteigenvector_ epsgeteigenvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeteigenvectorleft_ EPSGETEIGENVECTORLEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeteigenvectorleft_ epsgeteigenvectorleft
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeterrorestimate_ EPSGETERRORESTIMATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeterrorestimate_ epsgeterrorestimate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeterrorestimateleft_ EPSGETERRORESTIMATELEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeterrorestimateleft_ epsgeterrorestimateleft
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscomputeresidualnorm_ EPSCOMPUTERESIDUALNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscomputeresidualnorm_ epscomputeresidualnorm
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscomputeresidualnormleft_ EPSCOMPUTERESIDUALNORMLEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscomputeresidualnormleft_ epscomputeresidualnormleft
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscomputerelativeerror_ EPSCOMPUTERELATIVEERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscomputerelativeerror_ epscomputerelativeerror
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscomputerelativeerrorleft_ EPSCOMPUTERELATIVEERRORLEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscomputerelativeerrorleft_ epscomputerelativeerrorleft
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssorteigenvalues_ EPSSORTEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssorteigenvalues_ epssorteigenvalues
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssorteigenvaluesreal_ EPSSORTEIGENVALUESREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssorteigenvaluesreal_ epssorteigenvaluesreal
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscompareeigenvalues_ EPSCOMPAREEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscompareeigenvalues_ epscompareeigenvalues
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetstartvector_ EPSGETSTARTVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetstartvector_ epsgetstartvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetstartvectorleft_ EPSGETSTARTVECTORLEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetstartvectorleft_ epsgetstartvectorleft
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epssolve_(EPS *eps, int *__ierr ){
*__ierr = EPSSolve(*eps);
}
void PETSC_STDCALL  epsgetiterationnumber_(EPS *eps,PetscInt *its, int *__ierr ){
*__ierr = EPSGetIterationNumber(*eps,its);
}
void PETSC_STDCALL  epsgetoperationcounters_(EPS *eps,PetscInt* ops,PetscInt* dots,PetscInt* lits, int *__ierr ){
*__ierr = EPSGetOperationCounters(*eps,ops,dots,lits);
}
void PETSC_STDCALL  epsgetconverged_(EPS *eps,PetscInt *nconv, int *__ierr ){
*__ierr = EPSGetConverged(*eps,nconv);
}
void PETSC_STDCALL  epsgetinvariantsubspace_(EPS *eps,Vec *v, int *__ierr ){
*__ierr = EPSGetInvariantSubspace(*eps,v);
}
void PETSC_STDCALL  epsgetinvariantsubspaceleft_(EPS *eps,Vec *v, int *__ierr ){
*__ierr = EPSGetInvariantSubspaceLeft(*eps,v);
}
void PETSC_STDCALL  epsgeteigenpair_(EPS *eps,PetscInt *i,PetscScalar *eigr,PetscScalar *eigi,Vec Vr,Vec Vi, int *__ierr ){
*__ierr = EPSGetEigenpair(*eps,*i,eigr,eigi,
	(Vec)PetscToPointer((Vr) ),
	(Vec)PetscToPointer((Vi) ));
}
void PETSC_STDCALL  epsgeteigenvalue_(EPS *eps,PetscInt *i,PetscScalar *eigr,PetscScalar *eigi, int *__ierr ){
*__ierr = EPSGetEigenvalue(*eps,*i,eigr,eigi);
}
void PETSC_STDCALL  epsgeteigenvector_(EPS *eps,PetscInt *i,Vec Vr,Vec Vi, int *__ierr ){
*__ierr = EPSGetEigenvector(*eps,*i,
	(Vec)PetscToPointer((Vr) ),
	(Vec)PetscToPointer((Vi) ));
}
void PETSC_STDCALL  epsgeteigenvectorleft_(EPS *eps,PetscInt *i,Vec Wr,Vec Wi, int *__ierr ){
*__ierr = EPSGetEigenvectorLeft(*eps,*i,
	(Vec)PetscToPointer((Wr) ),
	(Vec)PetscToPointer((Wi) ));
}
void PETSC_STDCALL  epsgeterrorestimate_(EPS *eps,PetscInt *i,PetscReal *errest, int *__ierr ){
*__ierr = EPSGetErrorEstimate(*eps,*i,errest);
}
void PETSC_STDCALL  epsgeterrorestimateleft_(EPS *eps,PetscInt *i,PetscReal *errest, int *__ierr ){
*__ierr = EPSGetErrorEstimateLeft(*eps,*i,errest);
}
void PETSC_STDCALL  epscomputeresidualnorm_(EPS *eps,PetscInt *i,PetscReal *norm, int *__ierr ){
*__ierr = EPSComputeResidualNorm(*eps,*i,norm);
}
void PETSC_STDCALL  epscomputeresidualnormleft_(EPS *eps,PetscInt *i,PetscReal *norm, int *__ierr ){
*__ierr = EPSComputeResidualNormLeft(*eps,*i,norm);
}
void PETSC_STDCALL  epscomputerelativeerror_(EPS *eps,PetscInt *i,PetscReal *error, int *__ierr ){
*__ierr = EPSComputeRelativeError(*eps,*i,error);
}
void PETSC_STDCALL  epscomputerelativeerrorleft_(EPS *eps,PetscInt *i,PetscReal *error, int *__ierr ){
*__ierr = EPSComputeRelativeErrorLeft(*eps,*i,error);
}
void PETSC_STDCALL  epssorteigenvalues_(EPS *eps,PetscInt *n,PetscScalar *eigr,PetscScalar *eigi,PetscInt *perm, int *__ierr ){
*__ierr = EPSSortEigenvalues(*eps,*n,eigr,eigi,perm);
}
void PETSC_STDCALL  epssorteigenvaluesreal_(EPS *eps,PetscInt *n,PetscReal *eig,PetscInt *perm, int *__ierr ){
*__ierr = EPSSortEigenvaluesReal(*eps,*n,eig,perm);
}
void PETSC_STDCALL  epscompareeigenvalues_(EPS *eps,PetscScalar *ar,PetscScalar *ai,PetscScalar *br,PetscScalar *bi,PetscInt *result, int *__ierr ){
*__ierr = EPSCompareEigenvalues(*eps,*ar,*ai,*br,*bi,result);
}
void PETSC_STDCALL  epsgetstartvector_(EPS *eps,PetscInt *i,Vec vec,PetscTruth *breakdown, int *__ierr ){
*__ierr = EPSGetStartVector(*eps,*i,
	(Vec)PetscToPointer((vec) ),breakdown);
}
void PETSC_STDCALL  epsgetstartvectorleft_(EPS *eps,PetscInt *i,Vec vec,PetscTruth *breakdown, int *__ierr ){
*__ierr = EPSGetStartVectorLeft(*eps,*i,
	(Vec)PetscToPointer((vec) ),breakdown);
}
#if defined(__cplusplus)
}
#endif
