/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMPacket_h)
#define	XIMPacket_h

struct tagXIMPacket	;
typedef struct tagXIMPacket	XIMPacket ;

#include "XIMInputContext.h"

typedef enum {
	XIMPS_NO	= 0,
	XIMPS_SPOOL,
	XIMPS_SYNC_NORMAL,
	XIMPS_SYNC_PREEDIT_START,
	XIMPS_SYNC_PREEDIT_CARET,
	XIMPS_SPOOL_PREEDIT,
	XIMPS_SPOOL_PREEDIT_START,
	XIMPS_SPOOL_PREEDIT_CARET,
}	XIMPacketSyncMode ;

XIMPacket*			XIMPacket_Create			(Boolean) ;
void				XIMPacket_AddRef			(XIMPacket*) ;
void				XIMPacket_Release 			(XIMPacket*) ;
Boolean				XIMPacket_SetHeader			(XIMPacket*, int, int) ;
Boolean				XIMPacket_SetEndian			(XIMPacket*, Boolean) ;
Boolean				XIMPacket_SetInputContext	(XIMPacket*, XIMInputContext*) ;
Boolean				XIMPacket_SetSyncMode		(XIMPacket*, XIMPacketSyncMode) ;
XIMPacketSyncMode	XIMPacket_GetSyncMode		(XIMPacket*) ;
XIMInputContext*	XIMPacket_GetInputContext	(XIMPacket*) ;
int					XIMPacket_SetLength			(XIMPacket*) ;
CARD8*				XIMPacket_GetData			(XIMPacket*) ;
int					XIMPacket_GetDataSize		(XIMPacket*) ;
Boolean				XIMPacket_AddCard8			(XIMPacket*, CARD8) ;
Boolean				XIMPacket_AddCard16			(XIMPacket*, CARD16) ;
Boolean				XIMPacket_AddCard32			(XIMPacket*, CARD32) ;
Boolean				XIMPacket_AddBitmask16		(XIMPacket*, BITMASK16) ;
Boolean				XIMPacket_AddBitmask32		(XIMPacket*, BITMASK32) ;
Boolean				XIMPacket_AddString8		(XIMPacket*, const char*, int) ;
Boolean				XIMPacket_AddCard8N			(XIMPacket*, int) ;
Boolean				XIMPacket_AddPad			(XIMPacket*, size_t) ;
Boolean				XIMPacket_SetCard8			(XIMPacket*, int, CARD8) ;
Boolean				XIMPacket_SetCard16			(XIMPacket*, int, CARD16) ;
Boolean				XIMPacket_SetCard32			(XIMPacket*, int, CARD32) ;
Boolean				XIMPacket_GetCard16			(XIMPacket*, int, CARD16*) ;
void				XIMPacket_Clear				(XIMPacket*) ;
void				XIMPacket_Release			(XIMPacket*) ;
void				XIMPacket_Show				(XIMPacket*) ;
void				XIMPacket_GetHeader			(XIMPacket*, int*, int*) ;
Boolean				XIMPacket_GetEndian			(XIMPacket*) ;

#endif

