# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html generation, processing

=end
module SiSU_HTML
  require 'pstore'
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'defaults'                           # defaults.rb
    include SiSU_Viz
  require_relative 'html_table'                         # html_table.rb
  require_relative 'html_format'                        # html_format.rb
    include SiSU_HTML_Format
  require_relative 'html_segments'                      # html_segments.rb
    include SiSU_HTML_seg
  require_relative 'html_scroll'                        # html_scroll.rb
  require_relative 'html_promo'                         # html_promo.rb
    include SiSU_HTML_promo
  require_relative 'html_tune'                          # html_tune.rb
    include SiSU_HTML_Tune
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @md=@particulars.md
        @fnb=@md.fnb
        @env=@particulars.env
        loc=@env.url.output_tell
        unless @opt.cmd =~/q/
          tool=if @opt.cmd =~/[MVvz]/; "#{@env.program.web_browser} file://#{@md.file.output_path.html_seg.dir}/#{@md.file.base_filename.html_segtoc}"
          else                          "[#{@opt.f_pth[:lng_is]}] #{@opt.fns}"
          end
          @opt.cmd=~/[MVvz]/ \
          ? SiSU_Screen::Ansi.new(@opt.cmd,'HTML',tool).green_hi_blue
          : SiSU_Screen::Ansi.new(@opt.cmd,'HTML',tool).green_title_hi
          SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"file://#{@md.file.output_path.html_seg.dir}/#{@md.file.base_filename.html_segtoc}").flow if @opt.cmd =~/[MV]/
        end
        SiSU_Env::Info_skin.new(@md).select
        data=nil
        @tuned_file_array=SiSU_HTML::Source::Html_environment.new(@particulars).tuned_file_instructions
        data=@tuned_file_array
        scr_endnotes=SiSU_HTML::Source::Endnotes.new(data,@md).scroll
        toc=SiSU_HTML::Source::Toc.new(@md,data).songsheet
        links_guide=SiSU_HTML::Source::Links_guide.new(data,@md).toc
        data=@tuned_file_array
        scr_toc=SiSU_HTML::Source::Scroll_head_and_segtoc.new(@md,toc,links_guide).in_common #watch
        SiSU_HTML::Source::Seg.new(@md,data).songsheet
        data=@tuned_file_array
        scr=SiSU_HTML::Source::Scroll.new(@md,data,scr_endnotes).songsheet
        scroll=SiSU_HTML::Source::Scroll_output.new(scr_toc,scr[:body],scr[:metadata],scr[:owner_details],scr[:tails],@md).publish
        SiSU_HTML::Source::Output.new(scroll,@md).scroll
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        unless @opt.cmd =~/[MV]/ #check maintenance flag
          texfiles=Dir["#{@env.processing_path.tune}/#{@opt.fns}*"]
          texfiles.each do |f|
            if FileTest.file?(f)
              File.unlink(f)
            end
          end
        end
        SiSU_Env::Clear.new(@opt.cmd,@opt.fns,@md).param_instantiate
        @@flag,@@scr,@@seg,@@seg_endnotes,@@seg_subtoc,@@seg_ad={},{},{},{},{},{}
        @@seg_total,@@tracker,@@loop_count,@@tablehead,@@number_of_cols=0,0,0,0,0
        @@seg_name,@@seg_name_html,@@seg_subtoc_array,@@seg_endnotes_array,@@segtocband,@@tablefoot=Array.new(7){[]}
        @@filename_seg,@@seg_url,@@fn,@@to_lev4,@@get_hash_to,@@get_hash_fn='','','','','','',''
        @@is4=@@is3=@@is2=@@is1=@@heading1=@@heading2=@@heading3=@@heading4=0
      end
    end
    private
    class Html_environment
      def initialize(particulars)
        @particulars=particulars
        @md,@env=particulars.md,particulars.env
        @vz=SiSU_Env::Get_init.instance.skin
        @env,@css,@symlnk=particulars.env,SiSU_Style::CSS.new,SiSU_Env::Create_system_link.new #home
      end
      def link_images
        @symlnk.images
      end
      def directories
        title=File.basename(@md.fns,'.rb')
      end
      def tuned_file_instructions
        @tell=SiSU_Screen::Ansi.new(@md.opt.cmd)
        @md.opt.cmd=@md.opt.cmd.gsub(/H/,'h')
        @md.file_type='html' if @md.opt.cmd =~/[hon]/
        directories
        newfilename=%{#{@env.path.output}/#{@md.fnb}/#{@md.fn[:index]}} if @md.file_type =~/html/
        dal_array=@particulars.dal_array # dal file drawn here
        @tuned_file_array=SiSU_HTML_Tune::Tune.new(dal_array,@md).songsheet
        @tuned_file_array
      end
    end
    class Links_guide
      @links_guide_toc=[]
      def initialize(data,md)
        @data,@md=data,md
        @links_guide_=SiSU_Env::Create_site.new(@md.opt.cmd).html_quick_ref?
      end
      def toc
        @links_guide_toc=[]
        if @links_guide_
          format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
          guide_type='horzontal' #values: horizontal or vertical
          @links_guide_toc << format_head_toc.links_guide_open(guide_type)
          if defined? @md.lnk \
          and @md.lnk
            @md.lnk.each do |l|
              if defined? l[:say]
                target=if l[:url] !~/^\.(\.)?\//; 'external'
                else                              '_top'
                end
                s_lnk_url,s_lnk_lnk=l[:url],l[:say]
                txt_obj={ lnk_url: s_lnk_url, lnk_txt: s_lnk_lnk, target: target }
                lev_dob_ocn=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
                @links_guide_toc << lev_dob_ocn.links_guide if s_lnk_lnk
              end
            end
          end
          format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
          @links_guide_toc << format_head_toc.links_guide_close #(guide_type)
          @links_guide_toc
        else ''
        end
      end
    end
    class Endnotes
      include SiSU_HTML_Format
      def initialize(data,md)
        @data,@md=data,md
      end
      def scroll
        @scr_endnotes=[]
        format_head_scroll=SiSU_HTML_Format::Head_scroll.new(@md)
        @data.each do |dob|
          pg=dob.dup
          unless pg.is =~/^code/
            if pg.obj =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})[\d*+]+ /
              endnote_array=[]
              if pg.obj=~/#{Mx[:en_a_o]}[\d*+].+?#{Mx[:en_a_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_a_o]}[\d*+]+(.+?)#{Mx[:en_a_c]}/m)
              end
              if pg.obj=~/#{Mx[:en_b_o]}[\d*]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_b_o]}[\d*]+(.+?)#{Mx[:en_b_c]}/m)
              end
              if pg.obj=~/#{Mx[:en_b_o]}[\d+]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_b_o]}[\d+]+(.+?)#{Mx[:en_b_c]}/m)
              end
              endnote_array.flatten.each do |note|
                txt_obj={ txt: note }
                format_scroll=SiSU_HTML_Format::Format_scroll.new(@md,txt_obj)
                @scr_endnotes << format_scroll.endnote_body
              end
            end
          end
        end
        @scr_endnotes
      end
    end
    class Toc <Links_guide
      @@toc={ seg: [], seg_mini: [], scr: [] }
      @@seg_url=''
      @@firstseg=nil
      def initialize(md=nil,data='')
        @data,@md=data,md
        @vz=SiSU_Env::Get_init.instance.skin
        @tell=SiSU_Screen::Ansi.new(@md.opt.cmd) if @md
      end
      def songsheet #extracts toc for scroll & seg
        SiSU_Screen::Ansi.new(@md.opt.cmd,'Toc').txt_grey if @md.opt.cmd =~/[MVv]/
        toc=nil
        @@firstseg=nil
        @@toc={ seg: [], seg_mini: [], scr: [] }
        @data.each do |dob|
          if dob.is=='heading' \
          or dob.is=='heading_insert'
            dob_toc=dob.dup
            toc=if dob_toc.is =='heading' \
            or dob.is=='heading_insert'
              toc=case dob_toc.ln
              when 1; Toc.new(@md,dob_toc).level_1
              when 2; Toc.new(@md,dob_toc).level_2
              when 3; Toc.new(@md,dob_toc).level_3
              when 4; Toc.new(@md,dob_toc).level_4
              when 5; Toc.new(@md,dob_toc).level_5
              when 6; Toc.new(@md,dob_toc).level_6
              else nil
              end
            end
            toc.each do |k,d|
              d.gsub!(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
            end if toc
            if @@firstseg.nil? \
            and dob.ln==4 \
            and dob.name =~/\S+/
              @@firstseg=dob.name
            end
            if toc
              begin
                @@toc[:seg] << toc[:seg] if toc[:seg]
                @@toc[:seg_mini] << toc[:seg_mini] if toc[:seg_mini]
                @@toc[:scr] << toc[:scr] if toc[:scr]
              rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
              end
            end
          end
        end
        @md.firstseg=@@firstseg
        @@toc
      end
      def minitoc
        minitoc=@@toc[:seg_mini].join("\n")
        '<div class="toc">' + minitoc + '</div>'
      end
    protected
      def rss #sort all wrong, disabled but kept
        @@toc[:seg] <<<<WOK
<center>
<table><tr><td>
<p><font color="#222222" #{@font.face} size="2">
(relatively static) RSS feeds for DOCUMENTS:<br />
<a href="../rssfeed/documents.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/documents.xml<br />
<a href="../rssfeed/tradelaw.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/tradelaw.xml<br />
<a href="../rssfeed/environmental.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/environmental.xml<br />
<center><a href="mailto:info@address.com" target="_top">info@address.com</a></center>
</font></p>
</td></tr></table>
WOK
      end
#not used -->
      def level_endnotes
        if @md.flag_endnotes
          format_head_scroll=SiSU_HTML_Format::Head_scroll.new(@md)
          @@toc[:scr] << format_head_scroll.toc_endnote
        end
      end
      def level_concordance
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        @@toc[:seg_mini] << format_head_toc.mini_seg_concordance
      end
      def level_metadata
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        @@toc[:scr] << format_head_toc.metadata
        @@toc[:seg] << format_head_toc.seg_metadata
        @@toc[:seg_mini] << format_head_toc.mini_seg_metadata
      end
      def level_word_index
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@d0c)
        @@toc[:scr] << format_head_toc.concordance
        @@toc[:seg] << format_head_toc.concordance
        @@toc[:seg_mini] << format_head_toc.mini_concordance
      end
# <-- not used
      def level_1
        dob=@data
        linkname,link=dob.obj.strip,dob.ocn
        if link \
        and link !~/#/ #% keep eye on link
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,link)
        end
        title=if dob.obj !~/Metadata/; linkname
        else
          link='metadata'
          %{<b><a href="#{link}#{@md.lang_code_insert}#{Sfx[:html]}">#{linkname}</a></b>}
        end
        toc={}
        txt_obj={ txt: title }
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:seg]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          format_toc.lev0
        else format_toc.lev1
        end
        toc[:seg_mini]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          x=if @md.concord_make
            format_toc.mini_concord_tail
          else format_toc.mini_tail
          end
        else format_toc.mini_lev1
        end
        title=if dob.ocn ==0
          if dob.name =~/^meta/ \
          and dob.obj =~/Document Information/
            %{<a href="#docinfo">#{linkname}</a>}
          else linkname
          end
        else
          @@toc[:scr] <<  '<br />'
          link=if dob.ln; dob.ln
          else ''
          end
          %{<b><a href="##{link}">#{linkname}</a></b>}
        end
        txt_obj={ txt: title }
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          format_toc.lev0
        else format_toc.lev1
        end
        toc
      end
      def level_2
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        p_num=if ocn \
        and ocn !~/#/
          SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        else nil
        end
        txt_obj={ txt: linkname }
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev2
        toc[:seg_mini]=format_toc.mini_lev2
        if p_num
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev2
        end
        toc
      end
      def level_3
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        p_num=if ocn \
        and ocn !~/#/
          SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        else nil
        end
        txt_obj={ txt: linkname }
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev3
        toc[:seg_mini]=format_toc.mini_lev3
        if p_num
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev3
        end
        toc
      end
      def level_4
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn) if ocn
        if dob.ln ==4
          seg_link=%{  <a href="#{dob.name}#{@md.lang_code_insert}#{Sfx[:html]}" target="_top">
    #{dob.obj}
  </a> }
          @@seg_url=dob.name
        elsif dob.obj =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
          seg_link=dob.obj.gsub(/^(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/,
            %{<a href="\\1#{@md.lang_code_insert}#{Sfx[:html]}" } +
            %{target="_top">\\1 \\2</a> })
        end
        p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn) if ocn
        @file=SiSU_Env::SiSU_file.new(@md) if @md
        txt_obj=if seg_link=~/sisu_manifest\.html/
          man_link=if @file.output_dir_structure.by_language_code? \
          or @file.output_dir_structure.by_filetype?
            seg_link.gsub(/sisu_manifest\.html/,"../../manifest/#{@file.base_filename.manifest}")
          else seg_link
          end
          { txt: man_link }
        else { txt: seg_link }
        end
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev4
        toc[:seg_mini]=format_toc.mini_lev4
        title=%{#{p_num.goto}#{linkname}</a>} if p_num
        txt_obj=if title=~/sisu_manifest.html/
          man_link=title.gsub(/sisu_manifest.html/,"../manifest/#{@file.base_filename.manifest}")
          { txt: man_link }
        else { txt: title }
        end
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev4
        toc
       #end
      end
      def level_5
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        toc={}
        if ocn \
        and ocn !~/#/
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
          lnk_n_txt=%{  <a href="#{@@seg_url}#{@md.lang_code_insert}#{Sfx[:html]}##{ocn}">
    #{linkname}
  </a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev5
          toc[:seg_mini]=format_toc.mini_lev5
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev5
        end
        toc
      end
      def level_6
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        toc={}
        if ocn \
        and ocn !~/#/
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
          lnk_n_txt=%{  <a href="#{@@seg_url}#{@md.lang_code_insert}#{Sfx[:html]}##{ocn}">
  #{linkname}
</a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev6
          toc[:seg_mini]=format_toc.mini_lev6
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev6
        end
        toc
      end
      def level_crosslink
        dob=@data
        if dob !~/^4~!/
          dob.gsub!(/^4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width =\"80\"></td>
  <td><a href="http://\\1" target="_top">
    #{@png.crosslink_ext}
      &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        else
          dob.gsub!(/^4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width ="80">
  </td><td>
    <a href="\\1" target="_top">
      #{@png.crosslink}
        &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        end
      end
    end
    class Scroll_head_and_segtoc < Toc
      def initialize(md='',toc='',links_guide_toc='')
        @md,@toc,@links_guide_toc=md,toc,links_guide_toc
        @vz=SiSU_Env::Get_init.instance.skin
      end
      def in_common
        toc_shared=[]
        @segtoc=[]
        SiSU_Screen::Ansi.new(@md.opt.cmd,'Scroll & Segtoc').txt_grey if @md.opt.cmd =~/[MVv]/
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        dochead=format_head_toc.head
        dochead.gsub!(/toc\.(html)/,'doc.\1') #kludge
        ads=SiSU_HTML_promo::Ad.new(@md)
        toc_shared << dochead << ads.div.major
        @segtoc << format_head_toc.head << ads.div.major
        toc_shared << format_head_toc.toc_head_escript if SiSU_HTML_Format::Head_toc.method_defined? :toc_head_escript
        @segtoc << format_head_toc.toc_head_escript if SiSU_HTML_Format::Head_toc.method_defined? :toc_head_escript
        toc_shared << format_head_toc.scroll_head_navigation_band
        if defined? @md.rights.all
          rights=format_head_toc.rights.all
          rights=SiSU_HTML_Tune::Clean_html.new(rights).clean
        end
        if @md.prefix_b
          prefix_b=format_head_toc.notes.prefix_b
          prefix_b=SiSU_HTML_Tune::Clean_html.new(prefix_b).clean
        end
        @segtoc << format_head_toc.seg_head_navigation_band
        toc_shared << format_head_toc.scroll_head_title_banner_open
        @segtoc << format_head_toc.seg_head_title_banner_open
        tmp_head=nil
        doc_title_endnote=@md.title.full.gsub(/(\*+)/,'<sup><a href="#endnotes">\1</a></sup>')
        tmp_head=doc_title_endnote + "\n"
        txt_obj={ txt: tmp_head }
        format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
        toc_shared << format_txt_obj.center_bold
        @segtoc << format_txt_obj.center_bold
        if defined? @md.creator.author
          creator_endnote=@md.creator.author.gsub(/(\*+)/,%{&nbsp;<sup><a href="#notes">\\1</a></sup>})
          tmp_head=creator_endnote + "\n"
          txt_obj={ txt: tmp_head }
          format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
          toc_shared << format_txt_obj.center_bold
          @segtoc << format_txt_obj.center_bold
        end
        toc_shared << "#{@vz.table_close*1}\n"
        @segtoc << "#{@vz.table_close*1}\n"
        tmp_head=nil
        if @md.prefix_a
          tmp_head ||= %{<p />#{@md.prefix_a}\n}
          toc_shared << tmp_head.dup
          @segtoc << tmp_head.dup
        end
        tmp_head=nil
        toc_shared << @links_guide_toc
        if defined? @md.rights.all #and ? @md.rights.all
          toc_shared << rights
        end
        if defined? @md.prefix_b
          toc_shared << prefix_b
        end
        #Table of Contents added/appended here
        toc_shared << @toc[:scr]
        @segtoc << @links_guide_toc
        @segtoc << @toc[:seg]
        if defined? @md.rights.all \
        and not @md.rights.all.empty?
          @segtoc << rights
        end
        @segtoc << prefix_b if @md.prefix_b
        #Segtoc tail added here
        @segtoc << "</p>\n" #bugfix sort later DEBUGNOW
        @segtoc << @seg_toc_band_bottom
        ads=SiSU_HTML_promo::Ad.new(@md)
        @segtoc << format_head_toc.seg_navigation_tail << ads.div.close << ads.display << format_head_toc.html_close
        @segtoc.flatten!.compact!
        Output.new(@segtoc,@md).segtoc
        @segtoc=[]
        @toc[:scr],@toc[:seg]=[],[]
        toc_shared
      end
    end
    class Table < SiSU_HTML_table::Table_html
    end
    class Scroll < SiSU_HTML_scroll::Scroll
    end
    class Scroll_output
      def initialize(scr_toc,scr_body,scr_metadata,scr_owner_details,scr_tails,md)
        @scr_toc,@scr_body,@scr_metadata,@scr_owner_details,@scr_tails,@md=scr_toc,scr_body,scr_metadata,scr_owner_details,scr_tails,md
      end
      def publish
        scroll=[]
        hr='<center><hr width=90% /></center>'
        scroll << @scr_toc << '<div class="scroll">' << hr << @scr_body << @scr_endnotes << hr << @scr_owner_details << '</div>' << @scr_tails
        scroll.flatten!.compact!
      end
    end
    class Seg < SiSU_HTML_seg::Seg
    end
    class Output
      def initialize(data='',md='')
        @data,@md=data,md
        @file=SiSU_Env::SiSU_file.new(@md)
      end
      def scroll
        begin
          @filename_html_scroll=@file.write_file.html_scroll
          @data.each do |para|
            para.strip!
            para.gsub!(/<:.+?>/,'')
            para.gsub!(Xx[:html_relative2],@file.path_rel_links.html_scroll_2)
            para.gsub!(Xx[:html_relative1],@file.path_rel_links.html_scroll_1)
            #para.gsub!(/#{Xx[:html_relative]}/,@file.path_rel_links.html_scroll)
            para.gsub!(/#{Rx[:mx_fa_clean]}/,'')
            unless para =~/\A\s*\Z/
              @filename_html_scroll.puts para,"\n"
            end
          end
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
        ensure; @filename_html_scroll.close
        end
      end
      def segtoc
        begin
          @filename_html_segtoc=@file.write_file.html_segtoc
          @data.each do |para|
            para.strip!
            para.gsub!(/<!.+?!>/,'')
            para.gsub!(Xx[:html_relative2],@file.path_rel_links.html_seg_2)
            para.gsub!(Xx[:html_relative1],@file.path_rel_links.html_seg_1)
            unless para =~/\A\s*\Z/
              @filename_html_segtoc.puts para,"\n"
            end
          end
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.opt.cmd,@md.fns).error
        ensure
          @filename_html_segtoc.close
          unless FileTest.file?("#{@file.output_path.html_seg.dir}/#{@md.file.base_filename.html_seg_index}")
            pwd_set=Dir.pwd
            idx_lnk=@file.base_filename.html_segtoc
            mlnk=@file.base_filename.html_seg_index
            Dir.chdir(@file.output_path.html_seg.dir)
            FileUtils::rm_f(mlnk)
            FileUtils::ln_s(idx_lnk, mlnk)
            Dir.chdir(pwd_set)
          end
        end
      end
    end
  end
end
__END__
