/*
 * This file is part of the Shiboken Python Binding Generator project.
 *
 * Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "photon.h"

namespace Photon
{
int callCalculateForValueDuplicatorPointer(ValueDuplicator* value)
{
    return value->calculate();
}
int callCalculateForValueDuplicatorReference(ValueDuplicator& value)
{
    return value.calculate();
}
int countValueIdentities(const std::list<ValueIdentity>& values)
{
    return values.size();
}
int countValueDuplicators(const std::list<TemplateBase<DuplicatorType> >& values)
{
    return values.size();
}
} // namespace Photon
