////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2009
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

#if !defined(__INCLUDE_RandomGeneratorh_INCLUDE__)
#define __INCLUDE_RandomGeneratorh_INCLUDE__

#include <common/fixed.h>
#include <net/NetBuffer.h>

class RandomGenerator
{
public:
	virtual ~RandomGenerator();

	virtual unsigned int getRandUInt() = 0;
	virtual fixed getRandFixed() = 0;
};

class FileRandomGenerator : public RandomGenerator
{
public:
	FileRandomGenerator();
	virtual ~FileRandomGenerator();

	void seed(unsigned int seed);
	unsigned int getSeed();

	virtual unsigned int getRandUInt();
	virtual fixed getRandFixed();

	bool writeMessage(NetBuffer &buffer);
	bool readMessage(NetBufferReader &reader);

protected:
	static unsigned int bufferSize_;
	static unsigned int *buffer_;
	unsigned int position_;

private:
	FileRandomGenerator(const FileRandomGenerator &other);
	FileRandomGenerator &operator=(const FileRandomGenerator &other);

};

#endif
