# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xqt import *
from xutilities import message
from xmainwindow import getMainWindow

# -----------------------------------------------

def getText(value):
    from xutilities import str
    try:
        text = str(value)
    except UnicodeEncodeError:
        text = unicode(value)
        pass
    from xdata import XObject
    if isinstance(value, XObject):
        text = "%s object"%(value.__class__.__name__)
        pass
    return text
##    if 0:
##        pass
##    elif value is None:
##        text = str(value)
##    elif isinstance(value, (int, float, str, )):
##        text = str(value)
##    elif isinstance(value, list):
##        value = [ getText(v) for v in value ]
##        text = str(value)
##    elif isinstance(value, tuple):
##        value = tuple([ getText(v) for v in value ])
##        text = str(value)
##    elif isinstance(value, dict):
##        new_value = {}
##        for key, val in value.items():
##            key = getText(key)
##            val = getText(val)
##            new_value[key] = val
##            pass
##        text = str(value)
##    else:
##        from xtree import getMainXTree
##        xtree = getMainXTree()
##        xtree = xtree.getXTreeByNode(value)
##        if xtree:
##            text = xtree.full_name
##        else:
##            text = "%s object"%(value.__class__.__name__)
##            pass
##        pass
    return text

# -----------------------------------------------

class XEditorDialogBase(QDialog):
    
    def __init__(self, parent):
        message(parent, cls=XEditorDialogBase)
        QDialog.__init__(self, parent)
        self.setWFlags(Qt.WDestructiveClose)
        self.connect(parent, PYSIGNAL("browser_selection_changed"),
                     self.browserSelectionChanged)
        return
    
    def browserSelectionChanged(self, selection):
        message(selection)
        self.emit(PYSIGNAL("browser_selection_changed"), (selection, ))
        return
    
    pass

class XAttributeEditorDialog(XEditorDialogBase):
    
    def __init__(self, parent, xobject, xattribute):
        message(parent, xobject, xattribute, cls=XAttributeEditorDialog)
        XEditorDialogBase.__init__(self, parent)
        self.setCaption(xattribute.name)
        #
        cls = xobject.__class__
        if xattribute.name == "instance name":
            value = xobject.__instance__name__
        else:
            value = getattr(xobject, xattribute.name)
            pass
        #
        editor = cls.createEditor(xattribute, self, xobject, value, getText(value))
        editor_layout = QHBoxLayout(None)
        editor_layout.addWidget(editor)
        #
        button_ok = QPushButton(self,"OK")
        button_ok.setText(self.trUtf8("OK"))
        self.connect(button_ok, SIGNAL("clicked()"), self.sendOK)
        button_layout = QHBoxLayout(None)
        button_layout.addWidget(button_ok)
        #
        grid_layout = QGridLayout(self, 2)
        grid_layout.addLayout(editor_layout, 0, 0)
        grid_layout.addLayout(button_layout, 1, 0)
        #
        self.initial_value = value
        self.value_editor = editor
        self.xattribute = xattribute
        self.xobject = xobject
        #
        return
    
    def sendOK(self):
        message("sendOK", cls=XAttributeEditorDialog)
	button_ok = self.sender()
	button_ok.blockSignals(True)
        #
        initial_value = self.initial_value
        value_editor = self.value_editor
        #
        value, text = value_editor.getValueAndText()
        #
        try:
            # E.A. : Try ... Except if dev
            # has redefined __eq__
            test_eq = ( value == initial_value )
        except:
            test_eq = ( id(value) == id(initial_value) )
            pass
        if test_eq :
            self.close()
            return
        #
        obj = self.xobject
        if self.xattribute.name == "instance name":
            cmd = "obj.renameFromGUI(initial_value, value)"
        else:
            name = self.xattribute.name
            from xutilities import name2capname
            capname = name2capname(name)
            cmd = "obj.set%s(value)"%(capname)
            pass
        #
        try:
            self.xattribute.xtype(value)
            exec cmd
        except:
            from xutilities import verbose
            getMainWindow().displayException(long=verbose())
            button_ok.blockSignals(False)
            return
        #
        if self.xattribute.name == "instance name":
            if hasattr(obj, "__corba__object__"):
                from xsalome import getORB
                ior = getORB().object_to_string(obj.__corba__object__)
                import salome
                myStudyId = salome.sg.getActiveStudyId()
                myStudy = salome.myStudyManager.GetStudyByID(myStudyId)
                myBuilder = myStudy.NewBuilder()
                mySObject = myStudy.FindObjectIOR(ior)
                l = myStudy.FindDependances(mySObject)
                for sobj in l:
                    attr = myBuilder.FindOrCreateAttribute(sobj, "AttributeComment")
                    from SALOMEDS import AttributeComment
                    attr._narrow(AttributeComment).SetValue(value)
                    pass
                pass
            getMainWindow().oldObjectModified(obj)
            pass
        #
        self.close()
        #
        return
    
    pass

class XGuiXObjectEditorDialog(XEditorDialogBase):
    
    def __init__(self, cls, parent, instance_name, object_to_edit, editor):
        
        # --
        #
        
        from xdata import XList
        if isinstance(cls, XList):
            target_type = "xlist"
        else:
            target_type = "XObject"
            pass
        
        # --
        #
        
        self.cls = cls
        self.instance_name = instance_name
        self.object_to_edit = object_to_edit
        self.editor = editor
        
        # --
        #
        
        XEditorDialogBase.__init__(self, parent)
        if target_type == "xlist":
            self.setCaption("XList")
        else:
            self.setCaption(cls.__name__)
            pass
        
        # --
        # put the whole in a grid layout
        # QGridLayout(parent, nRows=1, nCols=1, margin=0, space=-1, name=0)
        
        xobject_editor_layout = QHBoxLayout(None)
        if target_type == "xlist":
            xlist1_button_layout = QHBoxLayout(None)
            # xlist2_button_layout = QHBoxLayout(None)
            xlist2_button_layout = xlist1_button_layout
            pass
        button_layout = QHBoxLayout(None)
        if target_type == "xlist":
            nRows = 3
        else:
            views = cls.getEditionViews(self, object_to_edit)
            if len(views) <= 1:
                nRows = 2
            else:
                nRows = 3
                self.__views__ = views
                pass
            pass
        grid_layout = QGridLayout(self, nRows, 1, 10)
        grid_layout.addLayout(xobject_editor_layout, 0, 0)
        if target_type == "xlist":
            grid_layout.addLayout(xlist1_button_layout, nRows-2, 0)
            # grid_layout.addLayout(xlist2_button_layout, nRows-2, 0)
            # --
            button = QPushButton(self,"New")
            button.setText(self.trUtf8("New"))
            xlist1_button_layout.addWidget(button)
            self.connect(button, SIGNAL("clicked()"), self.sendNew)
            button = QPushButton(self,"Delete")
            button.setText(self.trUtf8("Delete"))
            xlist1_button_layout.addWidget(button)
            self.connect(button, SIGNAL("clicked()"), self.sendDelete)
            # --
            button = QPushButton(self,"Up")
            button.setText(self.trUtf8("Up"))
            xlist2_button_layout.addWidget(button)
            self.connect(button, SIGNAL("clicked()"), self.sendUp)
            button = QPushButton(self,"Down")
            button.setText(self.trUtf8("Down"))
            xlist2_button_layout.addWidget(button)
            self.connect(button, SIGNAL("clicked()"), self.sendDown)
            # --
        else:
            if nRows == 3:
                view_layout = QHBoxLayout(None)
                grid_layout.addLayout(view_layout, nRows-2, 0)
                name = cls.getEditionViewsGroupName()
                if pyqt_module_name == "qt":
                    group = QButtonGroup(1, QGroupBox.Vertical, name, self)
                    group.setExclusive(True)
                else:
                    group = QGroupBox(name)
                    hbox = QHBoxLayout()
                    group.setLayout(hbox)
                    pass
                group.connect(group, SIGNAL("clicked(int)"), self.viewHasChanged)
                view_layout.addWidget(group)
                default_view = cls.getEditionDefaultView(self, object_to_edit, self.__views__)
                self.__id2view__ = []
                for view in self.__views__:
                    self.__id2view__.append(view)
                    rb = QRadioButton(view, group)
                    if pyqt_module_name == "PyQt4":
                        hbox.addWidget(rb)
                        def f(grp=group, i=len(self.__id2view__)-1):
                            grp.emit(SIGNAL("clicked(int)"), (i, ))
                            return
                        rb.connect(rb, SIGNAL("pressed()"), f)
                        pass
                    if view==default_view:
                        self.__current__view__ = view
                        rb.setChecked(True)
                        pass
                    pass
                pass
            else:
                self.__current__view__ = "All"
                pass
            pass
        grid_layout.addLayout(button_layout, nRows-1, 0)
        
        # --
        # the property editor
        
        xobject_editor = XGuiXObjectEditor(self)
        xobject_editor.reset(cls, instance_name, object_to_edit)
        xobject_editor_layout.addWidget(xobject_editor)
        
        # --
        # We need a reference to xobject_editor
        # for the ok button
        
        self.xobject_editor = xobject_editor
        
        # --
        # the buttons
        # ok
        button_ok = QPushButton(self,"OK")
        button_ok.setText(self.trUtf8("OK"))
        button_layout.addWidget(button_ok)
        self.connect(button_ok, SIGNAL("clicked()"), self.sendOK)
        #
        if editor is None:
            if object_to_edit is None:
                button_apply = QPushButton(self,"Apply")
                button_apply.setText(self.trUtf8("Apply"))
                button_layout.addWidget(button_apply)
                self.connect(button_apply, SIGNAL("clicked()"), self.sendApply)
                pass
            pass
        #
        if object_to_edit is None:
            # # apply
            # button_apply = QPushButton(self,"Apply")
            # button_apply.setText(self.trUtf8("Apply"))
            # button_layout.addWidget(button_apply)
            # cancel
            button_cancel = QPushButton(self,"Cancel")
            button_cancel.setText(self.trUtf8("Cancel"))
            button_layout.addWidget(button_cancel)
            self.connect(button_cancel, SIGNAL("clicked()"), self, SLOT("close()"))
            pass
        
        # --
        #
        
        if nRows == 3:
            self.resize(400, 350)
        else:
            self.resize(400, 300)
            pass
        
        return
    
    def viewHasChanged(self, val):
        self.__current__view__ = self.__id2view__[val]
        self.xobject_editor.reset(self.cls, self.instance_name, self.object_to_edit, "viewHasChanged")
        return
    
    def sendCommon(self, method):
        message("begin")
	button_ok = self.sender()
	button_ok.blockSignals(True)
        
        # --
        # IMPORTANT,
        # First, test the current item
        # unselect the current item if it exists
        
        xobject_editor = self.xobject_editor
        item = xobject_editor.current_item
        if item:
            xobject_editor.setSelected(item, 0)
            if item.status != "Valid":
                button_ok.blockSignals(False)
                return
            if item.edited:
                button_ok.blockSignals(False)
                return
            pass
        
        # --
        #
        
        cls = self.cls
        from xdata import XList
        if isinstance(cls, XList):
            self.sendOKForList()
            button_ok.blockSignals(False)
            return 
        
        object_to_edit = self.object_to_edit
        
        # --
        #
        
        if object_to_edit is None:
            name2item = xobject_editor.name2item
            xattributes = xobject_editor.__xattributes__
            
            # --
            # Check if all the properties are setted
            # if not, display message and return
            no_valid_names = []
            for x in xattributes:
                if name2item[x.name].status == "Valid": continue
                no_valid_names.append(x.name)
                pass
            if no_valid_names:
                if len(no_valid_names) == 1: msg = 'the attribute\n'
                else:                        msg = 'the attributes\n'
                for name in no_valid_names:
                    msg += name
                    if no_valid_names.index(name) < len(no_valid_names)-2:    msg += ', '
                    elif no_valid_names.index(name) == len(no_valid_names)-2: msg += ' and '
                    pass
                msg += '\n'
                if len(no_valid_names) == 1: msg += 'is '
                else:                        msg += 'are '
                msg += 'not valid'
                QMessageBox.warning(self, "Warning", msg)
                button_ok.blockSignals(False)
                return
            
            # --
            # Try to create the object
            
            args, kwargs = (), {}
            for x in cls.getAllInitXAttributes():
                key = x.name
                item = name2item[key]
                value = item.value
                if key == "name":
                    if value is None:
                        if x is cls.__name__xattribute__:
                            continue
                        pass
                    pass
                kwargs[key] = value
                pass
            
            message(kwargs)
            
            try:
                if self.editor is None:
                    instance_name = name2item["instance_name"].value
                    cmd = "%s = cls(**kwargs)"%(instance_name)
                    message(cmd)
                    exec cmd
                else:
                    self.editor.setValue(cls(**kwargs))
                    pass
                pass
            except:
                from xutilities import verbose
                getMainWindow().displayException(long=verbose())
                button_ok.blockSignals(False)
                return
            
            pass
        
        if method == "OK":
            self.close()
        elif method == "Apply":
            button_ok.blockSignals(False)
            prefix = cls.getInstancePrefix()
            from xdata import getXObjects
            names = [ x.__instance__name__ for x in getXObjects() ]
            num = 0
            while 1:
                num += 1
                name = "%s_%s"%(prefix, num)
                if name not in names: break
                pass
            instance_name = name
            xobject_editor.reset(cls, instance_name, object_to_edit)
        else:
            raise Exception('method %s is not recognized by sendCommon'%(method))
        
        return

    def sendOK(self):
        self.sendCommon("OK")
        return
    
    def sendApply(self):
        self.sendCommon("Apply")
        return
    
    def resizeEvent(self, ev):
        message(ev)
        cls_editor = self.xobject_editor
        cls_editor.placeValueEditor()
        return
    
    def sendNew(self):
        self.xobject_editor.sendNew()
        return
    
    def sendDelete(self):
        self.xobject_editor.sendDelete()
        return
    
    def sendUp(self):
        self.xobject_editor.sendUp()
        return
    
    def sendDown(self):
        self.xobject_editor.sendDown()
        return
    
    def sendOKForList(self):
        xobject_editor = self.xobject_editor
        name2item = xobject_editor.name2item
        xattributes = xobject_editor.__xattributes__
        
        # --
        # Check if all the properties are setted
        # if not, display message and return
        
        no_valid_names = []
        for x in xattributes:
            if name2item[x.name].status == "Valid": continue
            no_valid_names.append(x.name)
            pass
        if no_valid_names:
            if len(no_valid_names) == 1: msg = 'the item\n'
            else:                        msg = 'the items\n'
            for name in no_valid_names:
                msg += name
                if no_valid_names.index(name) < len(no_valid_names)-2:    msg += ', '
                elif no_valid_names.index(name) == len(no_valid_names)-2: msg += ' and '
                pass
            msg += '\n'
            if len(no_valid_names) == 1: msg += 'is '
            else:                        msg += 'are '
            msg += 'not valid'
            QMessageBox.warning(self, "Warning", msg)
            return
        
        # --
        # Create or update the list
        
        object_to_edit = self.object_to_edit
        
        l_new = []
        for x in xattributes:
            item = name2item[x.name]
            value = item.value
            l_new.append(value)
            pass
        
##        if object_to_edit is not None:
##            l_old = object_to_edit
##            n_old = len(l_old)
##            n_new = len(l_new)
##            for i in range(n_new):
##                if i < n_old :
##                    l_old[i] = l_new[i]
##                else:
##                    l_old.append(l_new[i])
##                    pass
##                pass
##            l_old[n_new:] = []
##        else:
        object_to_edit = l_new
##            pass
        
        try:
            self.cls(object_to_edit)
            self.editor.setValue(object_to_edit)
        except:
            from xutilities import verbose
            getMainWindow().displayException(long=verbose())
            return
        
        self.close()
        return
    
    pass

# -----------------------------------------------
# -----------------------------------------------

from xdataqlistview import XDataQListView

class XGuiXObjectEditor(XDataQListView):
    
    def __init__(self, parent):
        
        # --
        #
        
        self.cls = None
        self.instance_name = None
        self.object_to_edit = None
        
        # --
        #
        
        XDataQListView.__init__(self, parent)
        XDataQListView.setRootIsDecorated(self, 1)
        self.setSelectionMode(QListView.Single)
        self.addColumn("Property")
        self.addColumn("Value")
        self.value_editor = None
        self.current_item = None
        
        # --
        #
        
        self.connect(parent, PYSIGNAL("browser_selection_changed"), self.browserSelectionChanged)
        self.connect(self.header(), SIGNAL("sizeChange(int, int, int)"), self.onHeaderResized)
        # self.connect(self, SIGNAL("contextMenuRequested(QListViewItem*, const QPoint&, int)"), self.onPopupMenu)
        
        # --
        #
        
        from xmainmenubar import DynamicTip
        if pyqt_module_name == "qt":
            self.t = DynamicTip(self)
            pass
        
        return
    
    if pyqt_module_name != "qt":
        def event(self, event):
            if event.type() == QEvent.ToolTip:
                pos = event.pos()
                pos.setY(pos.y()-self.header().height())
                r, text = self.tip(pos)
                if text:
                    QToolTip.showText(event.globalPos(), text)
                    pass
                pass
            return XDataQListView.event(self, event)
        pass
    
    def tip( self, p ):
        # --
        # Header height offset
        # p.setY(p.y()-self.header().sectionRect(0).bottom())
        # --
        # Find the item pointed
        item = self.itemAt(p)
        if item is None: return QRect( 0,0, -1,-1 ), None
        # --
        #
        cls = self.cls
        xattr = item.xattribute
        text = cls.getToolTip(xattr)
        # --
        #
        if pyqt_module_name == "qt":
            r = self.itemRect(item)
        else:
            r = None
            pass
        return r , text
    
    def onHeaderResized(self):
        self.placeValueEditor()
        pass
    
    def browserSelectionChanged(self, selection):
        message(selection)
        self.emit(PYSIGNAL("browser_selection_changed"), (selection, ))
        return
    
##    def inplaceObjectCreated(self, item, obj):
##        if id(item) != id(self.selectedItem()):
##            self.setSelected(item, 1)
##        else:
##            self.value_editor.block_selection = 0
    
##        from xguitools import isXList
##        isList, lis_seq = isXList(item.xattribute)
##        value, text     = self.value_editor.getValueAndText()
    
##        if isList:
##            if value is None or (not isinstance(value, list)):
##                value = [obj]
##            else:
##                value.append(obj)
##                pass
##            self.value_editor.setValue(value)            
##        else:
##            self.value_editor.setValue(obj)
##            pass
##        return
    
##    def listItemAdded(self, item, value):
##        self.inplaceObjectCreated(item, value)
##        return
    
##    def listItemDeleted(self, item, value):
##        if id(item) != id(self.selectedItem()):
##            self.setSelected(item, 1)
##        else:
##            self.value_editor.block_selection = 0
##            pass
    
##        from xguitools import isXList
##        isList, lis_seq = isXList(item.xattribute)
##        if isList:
##            self.value_editor.setValue(value)
##            pass
##        return
    
##    def onPopupMenu(self, item, point, column):
##        if column == 0:
##            qt_menu = QPopupMenu(self)
    
##            # "Default value" popup command
##            if item.xattribute.hasDefaultValue():
##                id = qt_menu.insertItem("Default value")
##                qt_menu.connectItem(id, self.setDefaultValue)
##                pass
##            #
##            # In-place creation/editing popup commands
##            #
##            from xtypes import XInstance, XMulTypes, XList, XTuple, XNone
    
##            classes = []
##            isEditable = 0
##            isList = 0
##            isNewAllowed = 0
##            if isinstance(item.xattribute.getXtype(), XInstance):
##                classes = item.xattribute.getXtype().getClasses()
##                isEditable = 1
##                pass
##            elif isinstance(item.xattribute.getXtype(), (XList, XTuple)):
##                classes = item.xattribute.getXtype().getSequence()
##                if classes is not None and isinstance(classes[0], XInstance):
##                    classes = classes[0].getClasses()
##                    isNewAllowed = 1
##                isList = 1
##                pass
##            elif isinstance(item.xattribute.getXtype(), XMulTypes):
##                classes = item.xattribute.getXtype().getXtypes()
##                if isinstance(classes[0], XNone):
##                    if isinstance(classes[1], XInstance):
##                        classes = classes[1].getClasses()
##                        isEditable = 1
##                    elif isinstance(classes[1], (XList, XTuple)):
##                        classes = classes[1].getSequence()
##                        if classes[0] is not None and isinstance(classes[0], XInstance):
##                            classes = classes[0].getClasses()
##                            isNewAllowed = 1
##                            pass
##                        isList = 1
##                        pass
##                    pass
##                pass
##            #
##            #for c in classes:
##            #    print c
##            #    pass
##            #print isList, isNewAllowed
    
##            if not isEditable and not isNewAllowed:
##                classes = []
##                pass
##            #
##            # In-place editing
##            # IMPORTANT!
##            # value.__instance__name__ should be None for in-place editing
##            #
##            if isEditable:
##                value, text = self.value_editor.getValueAndText()
    
##                try:
##                    if value is not None and value.__instance__name__ is None:
##                        id = qt_menu.insertItem("Edit")
##                        qt_menu.connectItem(id, self.edit)
##                        pass
##                    pass
##                except AttributeError:
##                    pass
##                pass
##            #
##            # In-place creation
##            #
##            from xguitools import inplaceCreationMenu
##            inplaceCreationMenu(self, qt_menu, item, classes)
##            #
##            # List-specific commands
##            #
##            if isList:
##                if qt_menu.count() > 0:
##                    qt_menu.insertSeparator()
##                    pass
    
##                id = qt_menu.insertItem("Add item")
##                qt_menu.connectItem(id, self.listAdd)
##                id = qt_menu.insertItem("Delete items")
##                qt_menu.connectItem(id, self.listDelete)
##                pass
##            #
##            if qt_menu.count() > 0:
##                qt_menu.popup(point)
##                pass
    
##            pass
##        pass
    
##    def setDefaultValue(self):
##        self.value_editor.setValue(self.selectedItem().xattribute.getDefaultValue())
##        return
    
##    def edit(self):
##        value, text = self.value_editor.getValueAndText()
##        cls = value.__class__
##        self.selectedItem().activated_inplace = 1
##        self.value_editor.block_selection = 1
    
##        from xdatagui import getMainWindow
##        dialog = cls.createDialog(getMainWindow(), None, value, 1)
##        dialog.connect(dialog, PYSIGNAL("old_object_modified"), self.selectedItem().inplaceObjectCreated)
##        dialog.show()
##        return
    
##    def listAdd(self):
##        self.selectedItem().activated_inplace = 1
##        self.value_editor.block_selection = 1
    
##        from xdatagui import getMainWindow
##        from xdatalisteditor import XGuiAddDlg
    
##        from xguitools import isXList
##        isList, list_seq = isXList(self.selectedItem().xattribute)
    
##        dlg = XGuiAddDlg(list_seq, getMainWindow())
##        self.connect(dlg, PYSIGNAL("listitem_added"), self.selectedItem().listItemAdded)
##        dlg.show()
##        return
    
##    def listDelete(self):
##        value, text = self.value_editor.getValueAndText()
##        if value is None or not isinstance(value, list):
##            return
    
##        self.selectedItem().activated_inplace = 1
##        self.value_editor.block_selection = 1
    
##        from xdatagui import getMainWindow
##        from xdatalisteditor import XGuiDeleteDlg        
    
##        dlg = XGuiDeleteDlg(value, getMainWindow())
##        self.connect(dlg, PYSIGNAL("listitem_deleted"), self.selectedItem().listItemDeleted)
##        dlg.show()
##        return
    
    def reset(self, cls, instance_name, object_to_edit, method=None):
        message(cls, instance_name, object_to_edit, cls="XGuiXObjectEditor")
        
        # --
        #
        
        self.cls = cls
        self.instance_name = instance_name
        self.object_to_edit = object_to_edit
        self.inplace_activation = 0

        # --
        #

        # self.clear()
        for item in self.items:
            item.setVisible(0)
            pass
        self.items = []
        
        # --
        #
        
        from xdata import XList
        if isinstance(cls, XList):
            __xattributes__  = []
            if object_to_edit is not None:
                for i in range(len(object_to_edit)):
                    from xdata import XAttribute
                    index = i%len(cls.sequence)
                    x = XAttribute(str(i), xtype=cls.sequence[index])
                    __xattributes__.append(x)
                    pass
                pass
            __user__xattributes__ = __xattributes__[:]
            pass
        else:
            __xattributes__  = list(cls.getAllInitXAttributes(name_first=1))
            if object_to_edit is not None:
                for x in cls.__object__xattributes__:
                    if x.mode == "rw": __xattributes__.append(x)
                    pass
                pass
            parent = self.parent()
            __user__xattributes__ = cls.getXAttributesForEditionView(parent, object_to_edit, parent.__current__view__)
            __user__xattributes__ = __user__xattributes__[:]
            pass
        
        # --
        #
        
        is_instance_name = 0
        if object_to_edit is None:
            if instance_name is not None:
                # instance_name is None for inplace creation ...
                is_instance_name = 1
                from xdata import XString, XAttribute
                instance_name_xattribute = XAttribute("instance_name", xtype=XString(len_min=1))
                __xattributes__.insert(0, instance_name_xattribute)
                __user__xattributes__.insert(0, instance_name_xattribute)
                pass
            pass
        
        # --
        # We need a ref. to __xattributes__ for the
        # dialog OK button
        
        self.__xattributes__ = __xattributes__
        
        # --
        # We need a ref. to name2item for the
        # dialog OK button
        
        if method != "viewHasChanged":
            self.name2item = {}
            pass
        
        for x in __xattributes__:
            name = x.name
            message("xattribute:", name, x, cls=XGuiXObjectEditor)
            if name == "instance_name":
                isvalue = 1
                value = instance_name
                text = value
            else:
                if object_to_edit is None:
                    #
                    name2item = self.name2item
                    xattributes = self.__xattributes__
                    values = {}
                    for xx in xattributes:
                        key = xx.name
                        try:
                            myitem = name2item[key]
                        except KeyError:
                            continue
                        if myitem.status != "Valid": continue
                        value = myitem.value
                        values[key] = value
                        pass
                    #
                    has_default_value, value = cls.getDialogInitialValue(x, values, self.parent())
                    if has_default_value:
                        isvalue = 1
                        text = str(value)
                    else:
                        isvalue = 0
                        value = None
                        text = None
                        pass
                    pass
                else:
                    isvalue = 1
                    if isinstance(cls, XList):
                        value = object_to_edit[int(name)]
                    else:
                        from xutilities import name2capname
                        capname = name2capname(name)
                        exec "value = object_to_edit.get%s()"%(capname)
                        pass
                    text = getText(value)
                    pass
                pass
            message("isvalue, value, text:", isvalue, value, text)
            
            parent = self
            if is_instance_name:
                if name == "name":
                    if cls.__xnamedobject__:
                        myitem = self.name2item["instance_name"]
                        value = myitem.value
                        text = value
                        parent = self.items[0]
                        pass
                    pass
                pass
            message("isvalue, value, text:", isvalue, value, text)
            
            # begin{G.F}
            show,color=cls.show_item(name,object_to_edit)
            if (show!=0):
                if isvalue:
                    self.addItem(name, xattr=x, parent=parent, value_text=(value, text, ))
                else:
                    self.addItem(name, xattr=x, parent=parent)
                    pass
                pass
            if color:
                parent.items[-1].color=color
                # end{G.F}
                pass
            
            item = parent.items[-1]
            if x not in __user__xattributes__:
                # parent.takeItem(item)
                item.setVisible(0)
                # parent.items.remove(item)
            else:
                item.setVisible(1)
                pass
            
            pass
        
        return
    
    def addItem(self, name, **kwargs):
        message(name, kwargs, cls="XGuiXObjectEditor")
        
        xattr = kwargs['xattr']
        parent = kwargs['parent']
        
        try:
            value, text = kwargs['value_text']
            isvalue = 1
            status = "Valid"
        except KeyError:
            value, text = None, None
            isvalue = 0
            status = "NoValid"
            pass
        
        try:
            last = self.items[-1]
        except IndexError:
            last = None
            pass

        try:
            item = self.name2item[name]
        except KeyError:
            item = XGuiXObjectEditorItem(parent, last)
            pass
        
        parent.items.append(item)
        item.xattribute = xattr
        item.setText(0, xattr.name)
        item.isvalue = isvalue
        if isvalue:
            item.value = value
            pass
        if text is None:
            text = ""
            pass
        item.setText(1, text)
        item.status = status
        #
        self.name2item[name] = item
        return
    
    def theSelectionChanged(self):
        
        message("current_item", self.current_item, cls="XGuiXObjectEditor")
        
        # --
        # Verify that the number of selected items
        # is 0 or 1 (it should be ensure by
        # self.setSelectionMode(QListView.Single)
        # at __init__ but we never know ...)
        
        items = self.selectedItems()
        # message(items, cls="XGuiXObjectEditor")
        if len(items) == 0:
            item = None
        elif len(items) == 1:
            item = items[0]
        else:
            return
        
        message("item", item, cls="XGuiXObjectEditor")
        
        # --
        #
        
        if item is self.current_item:
            return
        
        # --
        #
        
        if self.inplace_activation:
            self.setSelected(self.current_item, 1)
            return
        
        # --
        #
        
        if not hasattr(self, '__test__ko__'):
            try:
                self.testCurrentItem()
                pass
            except:
                setattr(self, '__test__ko__', 1)
                if item:
                    self.setSelected(item, 0)
                else:
                    self.theSelectionChanged()
                    pass
                delattr(self, '__test__ko__')
                from xutilities import verbose
                getMainWindow().displayException(long=verbose())
                value_editor = self.value_editor
                value_editor.setFocus()
                return
            pass
        else:
            self.setSelected(self.current_item, 1)
            return
        
        # --
        # Then, replace the current item
        
        self.current_item = item
        
        # --
        # If there is no new item, nothing to do
        
        if item is None: return
        
        # --
        #
        
        try:
            text = str(item.text(1))
        except UnicodeEncodeError:
            text = unicode(item.text(1))
            pass
        xattr = item.xattribute
        
        # --
        #
        
        from xdata import XList
        if isinstance(self.cls, XList):
            xattribute, cls, parent = xattr, XList, self
            args = [xattribute, cls, parent]
        else:
            xattribute, parent = xattr, self
            args = [xattribute, parent]
            pass
        
        # --
        #
        
        if self.object_to_edit :
            args += [ self.object_to_edit ]
        else:
            name2item = self.name2item
            xattributes = self.__xattributes__
            kwargs = {}
            for x in xattributes:
                key = x.name
                myitem = name2item[key]
                if myitem.status != "Valid": continue
                value = myitem.value
                kwargs[key] = value
                pass
            args += [ kwargs ]
            pass
        
        # --
        #
        
        if item.isvalue:
            if item.value.__class__ in [list, tuple]:
                # text = text[1:-1]
                pass
            args += [item.value, text]
            pass
        
        # --
        #
        
        message(args)
        value_editor = self.cls.createEditor(*args)
        #
        self.connect(value_editor, PYSIGNAL("inplace_activation"), self.setInplaceActivation)
        self.connect(value_editor, PYSIGNAL("canceled"), self.editorCanceled)
        #
        self.value_editor = value_editor
        if item.activated_inplace:
            self.value_editor.block_selection = 1
            pass
        self.placeValueEditor()
        value_editor.show()
        value_editor.setFocus()
        
        return

    def editorCanceled(self):
        item = self.current_item
        self.current_item = None
        self.value_editor.close()
        self.setSelected(item, 0)
        return
    
    def setInplaceActivation(self, value):
        message(value, cls=XGuiXObjectEditor)
        self.inplace_activation = value
        return
    
    def placeValueEditor(self):
        item = self.current_item
        if item is None: return
        value_editor = self.value_editor
        if value_editor is None: return
        if pyqt_module_name == "PyQt4":
            self.setItemWidget(item, 1, value_editor)
            return
        r = self.itemRect(item)
        r.setX(self.header().sectionPos(1))
        r.setWidth(self.header().sectionSize(1)-1)
        value_editor.resize(r.size())
        x, y = self.viewportToContents(r.x(), r.y())
        self.moveChild(value_editor, x, y)
        return
    
    def testCurrentItem(self):
        item = self.current_item
        if item is None: return
        value_editor = self.value_editor
        if value_editor is None: return
        message(item, value_editor)
        #
        value, text = value_editor.getValueAndText()
        #
        if item.isvalue:
            initial_value = item.value
            try:
                # E.A. : Try ... Except if dev
                # has redefined __eq__
                test_eq = ( value == initial_value )
            except:
                test_eq = ( id(value) == id(initial_value) )
                pass
            if test_eq and item.edited == 0:
                value_editor.close()
                return
            pass
        #
        message("eeee", cls=XGuiXObjectEditor)
        #
        xattr = item.xattribute
        xtype = xattr.xtype
        #
        item.edited = 1
        #
        value = xattr.xtype(value)
        #
        if self.object_to_edit:
            from xdata import XList
            if isinstance(self.cls, XList):
                pass
            else:
                obj = self.object_to_edit
                name = xattr.name
                from xutilities import name2capname
                capname = name2capname(name)
                cmd = "obj.set%s(value)"%(capname)
                message("before ", cmd, cls=XGuiXObjectEditor)
                exec cmd
                message("after ", cmd, cls=XGuiXObjectEditor)
                pass
            pass
        #
        item.edited = 0
        item.isvalue = 1
        item.value = value
        if text is None:
            text = ""
            pass
        item.setText(1, text)
        item.status = "Valid"
        #
        value_editor.close()
        return
    
    def sendNew(self):
        #
        index = len(self.__xattributes__)%len(self.cls.sequence)
        #
        name = str(len(self.name2item.keys()))
        from xdata import XAttribute
        x = XAttribute(name, xtype=self.cls.sequence[index])
        self.addItem(name, xattr=x, parent=self)
        self.__xattributes__.append(x)
        return
    
    def sendDelete(self):
        items = self.selectedItems()
        # message(items, cls="XGuiXObjectEditor")
        if len(items) != 1:
            return
        item = items[0]
        self.setSelected(item, 0)
        n = int(item.xattribute.name)
        #
        self.takeItem(item)
        self.items.remove(item)
        x = item.xattribute
        self.__xattributes__.remove(x)
        #
        self.name2item.clear()
        for i in range(len(self.items)):
            name = str(i)
            item = self.items[i]
            item.setText(0, name)
            x = item.xattribute
            setattr(x, '__name', name)
            self.name2item[name] = item
            pass
        #
        try:
            item = self.items[n]
        except IndexError:
            try:
                item = self.items[n-1]
            except IndexError:
                return
            pass
        self.setSelected(item, 1)
        #
        return
    
    def sendUp(self):
        items = self.selectedItems()
        # message(items, cls="XGuiXObjectEditor")
        if len(items) != 1:
            return
        item = items[0]
        n = int(item.xattribute.name)
        if n == 0 : return
        message("n =",n )
        self.items[n] = self.items[n-1]
        self.items[n-1] = item
        #
        for i in (n-1, n, ):
            name = str(i)
            item = self.items[i]
            item.setText(0, name)
            x = item.xattribute
            setattr(x, '__name', name)
            self.name2item[name] = item
            pass
        #
        l = range(n)
        l.reverse()
        for i in l:
            self.takeItem(self.items[i])
            pass
        for i in l:
            self.insertItem(self.items[i])
            pass
        #
        self.__xattributes__ = []
        for item in self.items:
            self.__xattributes__.append(item.xattribute)
            pass
        #
        self.setSelected(self.items[n-1], 1)
        #
        return
    
    def sendDown(self):
        items = self.selectedItems()
        # message(items, cls="XGuiXObjectEditor")
        if len(items) != 1:
            return
        item = items[0]
        n = int(item.xattribute.name)
        if n == len(self.items)-1 : return
        message("n =",n )
        self.setSelected(self.items[n], 0)
        self.items[n] = self.items[n+1]
        self.items[n+1] = item
        #
        for i in (n+1, n, ):
            name = str(i)
            item = self.items[i]
            item.setText(0, name)
            x = item.xattribute
            setattr(x, '__name', name)
            self.name2item[name] = item
            pass
        #
        l = range(n+1)
        l.reverse()
        for i in l:
            self.takeItem(self.items[i])
            pass
        for i in l:
            self.insertItem(self.items[i])
            pass
        #
        self.__xattributes__ = []
        for item in self.items:
            self.__xattributes__.append(item.xattribute)
            pass
        #
        self.setSelected(self.items[n+1], 1)
        #
        return
    
    pass

# -----------------------------------------------
# -----------------------------------------------

from xdataqlistview import XDataQListViewItem

class XGuiXObjectEditorItem(XDataQListViewItem):
    
    def __init__(self, parent, after):
        XDataQListViewItem.__init__(self, parent, after)
        self.activated_inplace = 0
        self.edited = 0
        return
    
##    def inplaceObjectCreated(self, obj):
##        self.activated_inplace = 0
##        self.edited = 1
##        self.listView().inplaceObjectCreated(self, obj)
##        return
    
##    def listItemAdded(self, value):
##        self.activated_inplace = 0
##        self.edited = 1
##        self.listView().listItemAdded(self, value)
##        return
    
##    def listItemDeleted(self, listobj):
##        self.activated_inplace = 0
##        self.edited = 1
##        self.listView().listItemDeleted(self, listobj)
##        return    
    
##    def blockSelection(self, block):
##        self.listView().value_editor.block_selection = block
##        return
    
    pass

