# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession

class TestCase(unittest.TestCase):
    def test(self):
        #
        salome = XSalomeSession(modules=["DATATEST1"])
        #
        from xdictusecases import TestXDict1
        test_xdict = TestXDict1()
        d = test_xdict.dict
        self.failUnlessEqual(len(d.keys()), 3)
        self.failUnlessEqual(d['a'], 1)
        epsilon = 1.e-4
        error = abs(1.3-d['b'])
        self.failUnless(error < epsilon)
        self.failUnlessEqual(d['c'], 'toto')
        #
        test_xdict.modifyDict()
        d = test_xdict.dict
        self.failUnlessEqual(len(d.keys()), 4)
        self.failUnlessEqual(d['a'], 1)
        epsilon = 1.e-4
        error = abs(1.3-d['b'])
        self.failUnless(error < epsilon)
        self.failUnlessEqual(d['c'], 'toto')
        self.failUnlessEqual(d['d'], 'tutu')
        #
        test_xdict.replaceDict({'a': 1})
        d = test_xdict.dict
        self.failUnlessEqual(d, {'a': 1})
        #
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
