# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession
salome = XSalomeSession(modules=["SOLVER1"])

class TestCase(unittest.TestCase):
    def test(self):
        # Pure corba
        component = salome.lcc.FindOrLoadComponent("FactoryServerPy", "SOLVER1")
        self.failUnless(component)
        from SOLVER1_CORBA import SOLVER1_Component
        component = component._narrow(SOLVER1_Component)
        self.failUnless(component)
        x = component.newKalifLauncher()
        x.solve()
        # Wrapping python
        from gainheritence import KalifLauncher
        x = KalifLauncher()
        x.solve()
        #
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
