# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --
from xdata import *
import math
class A( XObject ):
    __init__xattributes__ = [
        XAttribute( 'radius', xtype=XFloat() ),
        XAttribute( 'height', xtype=XFloat() ),
        ]
    __object__xattributes__ = [
        XAttribute( 'volume', xtype=XFloat() ),
        ]
    def getVolume(self):
        return self.radius*self.radius*self.height*math.pi
    pass

class B( A ):
    __init__xattributes__ = A.__init__xattributes__ + [
        XAttribute( 'porosity', xtype=XFloat(min=0., max=1.) ),
        ]
    __object__xattributes__ = A.__object__xattributes__
    
    def getVolume(self) :
        return A.getVolume(self) * (1.-self.porosity)
    pass

import unittest
class Test( unittest.TestCase ):
    def testA(self):
        a = A( 0.004095, 0.0115 )
        self.failUnlessEqual( a.volume, 0.004095*0.004095*0.0115*math.pi )
        return
    def testB(self):
        b = B( 0.004095, 0.0115, 0.05 )
        self.failUnlessEqual( b.volume, 0.004095*0.004095*0.0115*math.pi*(1. - 0.05) )
        self.failUnlessRaises(XAttributeError, b.setVolume, 1.2)
        self.failUnlessRaises(XAttributeError, setattr, b, "volume", 1.2)
        self.failUnlessRaises(XAttributeError, b.__setattr__, "volume", 1.2)
        return
    pass

unittest.main()
