# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

# ----------------------------------------------------
# -- test if __init__xattributes__ is a list of XAttribute
# ----------------------------------------------------

def testBad():
    class TestBadProperties(XObject):
        __init__xattributes__ = 123
        pass
    return

def testBad2():
    class TestBadProperties2(XObject):
        __init__xattributes__ = [ 123 ]
        pass
    return

class BadTestCase(unittest.TestCase):
    def test(self):
        self.failUnlessRaises(XValueError, testBad)
        self.failUnlessRaises(XValueError, testBad2)
        return
    pass

# ----------------------------------------------------
# -- test if __init__xattributes__ is correct in
# -- python syntax
# ----------------------------------------------------

def testSameNames():
    class TestSameNames(XObject):
        __init__xattributes__ = [
            XAttribute("toto", xtype=XInt()),
            XAttribute("toto", xtype=XInt()),
            ]
        pass
    return

def testBadOrder():
    class TestBadOrder(XObject):
        __init__xattributes__ = [
            XAttribute("x", xtype=XInt(), default_value=1),
            XAttribute("y", xtype=XInt()),
            ]
        pass
    return

class BadXattributesTestCase(unittest.TestCase):
    def test(self):
        self.failUnlessRaises(XAttributeError, testSameNames)
        self.failUnlessRaises(XAttributeError, testBadOrder)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
