# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

#
# test creation in __init__
#

def f(x, y):
    return x

class InitCreationTestCase(unittest.TestCase):
    def test(self):
        x = f(x = XNamedObject(), y = XNamedObject())
        x = f(x = XNamedObject(),
              y = XNamedObject())
        return
    pass

# ----------------------------------------------------
# -- test setCreationInformations
# ----------------------------------------------------

XNamedObject()
x_in_main = XNamedObject()

class ABCD(XNamedObject):
    def __init__(self, *args, **kwargs):
        self.x = XNamedObject()
        yyy = XNamedObject()
        self.y = yyy
        return
    pass

abcd = ABCD()

class xGetInstanceNameTestCase(unittest.TestCase):
    def test_main(self):
        #
        self.failUnlessEqual(x_in_main.__instance__name__, 'x_in_main')
        self.failUnlessEqual(x_in_main.__code__next__operation__, 'STORE_NAME')
        #
        self.failUnlessEqual(abcd.__instance__name__, 'abcd')
        self.failUnlessEqual(abcd.__code__next__operation__, 'STORE_NAME')
        self.failUnlessEqual(abcd.x.__instance__name__, 'x')
        self.failUnlessEqual(abcd.x.__code__next__operation__, 'STORE_ATTR')
        self.failUnlessEqual(abcd.y.__instance__name__, 'yyy')
        self.failUnlessEqual(abcd.y.__code__next__operation__, 'STORE_FAST')
        #
        return
    def test(self):
        #
        x = XNamedObject()
        self.failUnlessEqual(x.__instance__name__, "x")
        self.failUnlessEqual(x.__code__next__operation__, 'STORE_FAST')
        #
        self.x = XNamedObject()
        self.failUnlessEqual(self.x.__instance__name__, "x")
        self.failUnlessEqual(self.x.__code__next__operation__, 'STORE_ATTR')
        return
    def testABCD(self):
        a = ABCD()
        self.failUnlessEqual(a.__instance__name__, "a")
        self.failUnlessEqual(a.x.__instance__name__, "x")
        return
    def test_RETURN_VALUE(self):
        #
        def f():
            return XNamedObject()
        #
        x = f()
        self.failUnlessEqual(x.__instance__name__, "x")
        self.failUnlessEqual(x.__code__next__operation__, 'STORE_FAST')
        self.x = f()
        self.failUnlessEqual(self.x.__instance__name__, "x")
        self.failUnlessEqual(self.x.__code__next__operation__, 'STORE_ATTR')
        return
    pass


# ----------------------------------------------------
# ----------------------------------------------------

class XNamedObjectTestCase(unittest.TestCase):
    def test(self):
        self.failUnlessRaises(XValueError, XNamedObject, "")
        #
        a = XNamedObject()
        self.failUnlessRaises(XValueError, a.setName, "")
        #
        a = XNamedObject()
        self.failUnlessEqual(a.getName(), "a")
        a.name = "toto"
        self.failUnlessEqual(a.name, "toto")
        #
        a = XNamedObject(name="toto")
        self.failUnlessEqual(a.getName(), "toto")
        #
        return
    pass

# ----------------------------------------------------
# ----------------------------------------------------

class XNamedA(XNamedObject):
    pass

class XNamedATestCase(unittest.TestCase):
    def test(self):
        a = XNamedA()
        self.failUnlessEqual(a.getName(), "a")
        return
    pass

# ----------------------------------------------------
# ----------------------------------------------------

class A(XNamedObject):
    def __init__(self, *args, **kwargs):
        try:
            self.nb += 1
        except AttributeError:
            self.nb = 1
            pass
        return
    pass

class ATestCase(unittest.TestCase):
    def test(self):
        a = A()
        self.failUnlessEqual(a.getName(), "a")
        self.failUnlessEqual(a.nb, 1)
        a = A("toto")
        self.failUnlessEqual(a.getName(), "toto")
        self.failUnlessEqual(a.nb, 1)
        a = A(name="toto")
        self.failUnlessEqual(a.getName(), "toto")
        self.failUnlessEqual(a.nb, 1)
        return
    pass

# ----------------------------------------------------
# ----------------------------------------------------

class KObject(XNamedObject):
    def setName(self, name):
        try:
            self.nb += 1
        except AttributeError:
            self.nb = 1
            pass
        return
    pass

class KGrid(KObject):
    def __init__(self, *args, **kwargs):
        KObject.__init__(self)
        self.vtk_grid = None
        self.menu = None
        return
    pass

class KTestCase(unittest.TestCase):
    def testKObject(self):
        k = KObject()
        self.failUnlessEqual(k.getName(), "k")
        self.failUnlessEqual(k.nb, 1)
        return
    def testKGrid(self):
        k = KGrid()
        self.failUnlessEqual(k.getName(), "k")
        self.failUnlessEqual(k.menu, None)
        self.failUnlessEqual(k.nb, 1)
        return
    pass

# ----------------------------------------------------
# ----------------------------------------------------

class B(XNamedObject):
    __init__xattributes__ = [
        XAttribute("x", default_value=0.0),
        ]
    pass

class BTestCase(unittest.TestCase):
    def test(self):
        b = B(3.2)
        self.failUnlessEqual(b.getName(), 'b')
        return
    pass

# ----------------------------------------------------
# ----------------------------------------------------

class MusicaObjectTest(XNamedObject):
    __init__xattributes__  = [
        XAttribute("x", xtype=XFloat(min=0.0)),
        XAttribute("y", xtype=XFloat(min=0.0)),
        XAttribute("z", xtype=XFloat(min=0.0), default_value=0.0),
        ]
    pass

class MusicaObjectTestXYZ(MusicaObjectTest):
    __init__xattributes__  = [
        XAttribute("xyz", xtype=XTuple(len=3, sequence=XFloat(min=0.0))),
        ]
    def __init__(self, *args, **kwargs):
        MusicaObjectTest.__init__(self, *self.xyz)
        return
    pass

class MusicaObjectTestCase1(unittest.TestCase):
    def test(self):
        #
        m = MusicaObjectTest("1.2", 2, 3.7)
        self.failUnlessEqual(m.getName(), "m")
        m = MusicaObjectTest("1.2", 2, 3.7, name="toto")
        self.failUnlessEqual(m.getName(), "toto")
        #
        x = MusicaObjectTest(1,
                             2,
                             3)
        self.failUnlessEqual(x.getName(), "x")
        #
        x = \
          MusicaObjectTest (
            1,
            2,
            3,
            )
        self.failUnlessEqual(x.getName(), "x")
        #
        self.xxx = MusicaObjectTest(
            1,
            2,
            3,
            )
        self.failUnlessEqual(self.xxx.getName(), "xxx")
        #
        return
    def testXYZ(self):
        a = MusicaObjectTestXYZ((1, 2, 3))
        self.failUnlessEqual(a.getName(), 'a')
        a = MusicaObjectTestXYZ((1, 2, 3), name="toto")
        self.failUnlessEqual(a.getName(), 'toto')
        return
    pass

# ----------------------------------------------------
# ----------------------------------------------------

class MusicaObjectTestCase(unittest.TestCase):
    def test(self):
        #
        def ffff(x):
            print x.name
            return
        #
        # self.failUnlessRaises(XAttributeError, ffff, XNamedObject())
        # self.failUnlessRaises(XAttributeError, ffff, x=XNamedObject())
        return
    pass

# ----------------------------------------------------
# ----------------------------------------------------

if __name__ == '__main__':
    unittest.main()
    pass
