//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  VISU VISUGUI : GUI of VISU component
//  File   : VisuGUI_FilterScalarsDlg.h
//  Author : vsv
//  Module : VISU
//
#ifndef VISUGUI_FILTERSCALARSDLG_H
#define VISUGUI_FILTERSCALARSDLG_H

#include <QDialog>

#include "SALOME_GenericObjPointer.hh"

class VisuGUI;

class QLineEdit;
class QGroupBox;

namespace VISU
{
  class ColoredPrs3d_i;
}


class VisuGUI_FilterScalarsDlg: public QDialog
{
  Q_OBJECT;

 public:
  VisuGUI_FilterScalarsDlg( VisuGUI* theModule );
  ~VisuGUI_FilterScalarsDlg();

protected slots:

  virtual void accept();
  virtual void reject(); 

private slots:

  void onHelp();
  void onSelectionEvent();

private:
  VisuGUI* myVisuGUI;
  SALOME::GenericObjPtr< VISU::ColoredPrs3d_i > myColoredPrs3d;

  QGroupBox* myRangeBox;
  QLineEdit* myMinEdit;
  QLineEdit* myMaxEdit;
};


#endif
