//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#include "InterpKernelException.hxx"

#include <iostream>

INTERP_KERNEL::Exception::Exception(const char *what):_reason(what)
{
  std::cerr << "AN INTERP_KERNEL::EXCEPTION HAS BEEN THROWN : " << what << "**********" << std::endl;
}

INTERP_KERNEL::Exception::Exception(const char *what, const char *file, int line):_reason(what)
{
}

INTERP_KERNEL::Exception::~Exception() throw ()
{
}

const char *INTERP_KERNEL::Exception::what() const throw()
{
  return _reason.c_str();
}
