#  Copyright (C) 2005-2008  OPEN CASCADE
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#
TEMPLATE = lib
TARGET = LIGHT
DESTDIR = ../../lib
MOC_DIR = ../../moc
OBJECTS_DIR = ../../obj/$$TARGET

CASROOT = $$(CASROOT)
CAS_CPPFLAGS = $${CASROOT}/inc

VTKHOME = $$(VTKHOME)
VTK_INCLUDES = $${VTKHOME}/include/vtk

PYTHONVER=2.4
PYTHONHOME=$$(PYTHONHOME)
PYTHONINC=$${PYTHONHOME}/include/python$${PYTHONVER}

INCLUDEPATH += ../../include $${CAS_CPPFLAGS} $${VTK_INCLUDES} $${PYTHONINC}
INCLUDEPATH += ../LightApp
LIBS += -L../../lib -lLightApp

CONFIG -= debug release debug_and_release
CONFIG += qt thread debug dll shared

win32:DEFINES += WIN32
DEFINES += LIGHTGUI_EXPORTS

HEADERS  = LIGHTGUI.h
HEADERS += LIGHTGUI_Selection.h
HEADERS += LIGHTGUI_DataObject.h
HEADERS += LIGHTGUI_DataModel.h
HEADERS += LIGHTGUI_TextPrs.h
HEADERS += LIGHTGUI_TextPrs.h

SOURCES  = LIGHTGUI.cxx
SOURCES += LIGHTGUI_Selection.cxx
SOURCES += LIGHTGUI_DataObject.cxx
SOURCES += LIGHTGUI_DataModel.cxx
SOURCES += LIGHTGUI_TextPrs.cxx

TRANSLATIONS = resources/LIGHTGUI_msg_en.ts \
               resources/LIGHTGUI_images.ts

ICONS = resources/*.png

includes.files = $$HEADERS
includes.path = ../../include

resources.files = $$ICONS resources/*.qm
resources.path = ../../resources

INSTALLS += includes resources
