#! /usr/bin/env python
#  -*- coding: iso-8859-1 -*-
#  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
#
#  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
#  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#
## \file killSalome.py
#  Stop all %SALOME servers from all sessions by killing them
#

import os, sys, re, signal

from killSalomeWithPort import killMyPort, getPiDict

def killAllPorts():
    """
    Kill all SALOME sessions belonging to the user.
    """
    user = os.getenv('USER')
    # new-style dot-prefixed pidict file
    #fpidict   = getPiDict('(\d*)',hidden=True)
    #problem with WIN32 path slashes
    fpidict   = getPiDict('#####',hidden=True)
    dirpidict = os.path.dirname(fpidict)
    fpidict   = os.path.basename(fpidict)
    fpidict = fpidict.replace('#####', '(\d*)')
    fnamere   = re.compile("^%s$" % fpidict)
    try:
        for f in os.listdir(dirpidict):
            mo = fnamere.match(f)
            try:
                killMyPort(mo.group(1))
            except:
                pass
            pass
        pass
    except:
        pass
    # provide compatibility with old-style pidict file (not dot-prefixed)
    #fpidict   = getPiDict('(\d*)',hidden=False)
    fpidict   = getPiDict('#####',hidden=True)
    dirpidict = os.path.dirname(fpidict)
    fpidict   = os.path.basename(fpidict)
    fpidict = fpidict.replace('#####', '(\d*)')
    fnamere   = re.compile("^%s$" % fpidict)
    try:
        for f in os.listdir(dirpidict):
            mo = fnamere.match(f)
            try:
                killMyPort(mo.group(1))
            except:
                pass
            pass
        pass
    except:
        pass
    # kill other processes
    if sys.platform != 'win32':
        import commands
        cmd = "ps -fea | grep '%s' | grep 'ghs3d' | grep 'f /tmp/GHS3D_' | grep -v 'grep' | awk '{print $2}'" % user
        prc = commands.getoutput(cmd)
        for field in prc.split():
            try:
                os.kill(int(field), signal.SIGKILL)
            except:
                pass
            pass
        pass
    pass

if __name__ == "__main__":
    killAllPorts()
    pass
    
