\name{RKWard_workplace}
\alias{rk.save.workplace}
\alias{rk.restore.workplace}

\title{Save or restore RKWard workplace}

\description{
}

\usage{
rk.save.workplace(file=NULL, description=NULL)
rk.restore.workplace(file=NULL, close.windows=TRUE)
}

\arguments{
\item{file}{a character string giving the url of the file to save to, or NULL for automatic selection of a suitable file (see Details).}
\item{description}{For internal use, only. A character string describing the workplace status to save. Generally, you should leave this as the default value (\code{NULL}).}
\item{close.windows}{a logical; whether current windows should be closed before restoring.}
}

\details{
\code{rk.save.workplace} can be used to save a representation of the RKWard workplace (i.e. which scripts, data edtiors and other windows are shown) to a file. \code{rk.restore.workplace} restores an RKWard workplace as saved by \code{rk.save.workplace}.

If the \code{file} parameter is omitted (or \code{NULL}), a suitable filename is selected automatically. If a workspace has been loaded, this is the URL of the workspace with an appended \code{.rkworkplace}. Otherwise a filename in the RKWard directory, as generated by \link{rk.get.tempfile.name}.

NOTE: Not all types of windows can be saved and restored. Esp. graphics device windows will not be restored (but WILL be closed by \code{rk.restore.workplace()}, if \code{close.windows} is TRUE).
}

\value{
Both functions return \code{NULL}.
}

\seealso{
\url{rkward://page/rkward_for_r_users}, \link{rk.get.workspace.url}
}

\author{Thomas Friedrichsmeier \email{rkward-devel@lists.sourceforge.net}}

\examples{
## Not run
rk.save.workplace ()
rk.restore.workplace ()
## End not run
}

\keyword{utilities}
