/* $Id: implicit.h,v 1.3 2005/12/19 06:52:42 rockyb Exp $
Copyright (C) 2004, 2005
Free Software Foundation, Inc.
This file is part of GNU Make.

GNU Make is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Make is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Make; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/** \file implicit.h
 *
 *  \brief Implicit rule searching for GNU Make.
 */

/*! For a P_FILE which has no commands specified, try to figure out some
   from the implicit pattern rules.
   Returns true if a suitable implicit rule was found,
   after modifying P_FILE to contain the appropriate commands and deps,
   or returns false if no implicit rule was found.  
*/
extern bool try_implicit_rule (file_t *p_file, unsigned int i_depth);
