% File src/library/base/man/Sys.time.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2010 R Core Development Team
% Distributed under GPL 2 or later

\name{Sys.time}
\alias{Sys.time}
\alias{Sys.Date}

\title{Get Current Date and Time}
\description{
  \code{Sys.time} and \code{Sys.Date} returns the system's idea of the
  current date with and without time.
}
\usage{
Sys.time()
Sys.Date()
}
\details{
  \code{Sys.time} returns an absolute date-time value which can be
  converted to various time zones and may return different days.

  \code{Sys.Date} returns the current day in the current \link{timezone}.
}
\value{
  \code{Sys.time} returns an object of class \code{"POSIXct"} (see
  \link{DateTimeClasses}).  On almost all systems it will have
  sub-second accuracy: on systems conforming to POSIX 1003.1-2001 the
  time will be reported in microsecond increments.  On Windows it
  increments in clock ticks (1/60 of a second) reported to millisecond
  accuracy.

  \code{Sys.Date} returns an object of class \code{"Date"} (see \link{Date}).
}
\note{
  \code{Sys.time} may return fractional seconds, but they are ignored by
  the default conversions (e.g. printing) for class \code{"POSIXct"}.
  See the examples and \code{\link{format.POSIXct}} for ways to reveal them.
}
\seealso{
  \code{\link{date}} for the system time in a fixed-format character
  string; the elapsed time component of \code{\link{proc.time}} 
  for possibly finer resolution in changes in time.

  \code{\link{Sys.timezone}}.
}
\examples{
Sys.time()
## print with possibly greater accuracy:
op <- options(digits.secs=6)
Sys.time()
options(op)

## locale-specific version of date()
format(Sys.time(), "\%a \%b \%d \%X \%Y")

Sys.Date()
}
\keyword{utilities}
\keyword{chron}
