/*
    Copyright (C) 2008, 2009 Andres Cabrera
    mantaraya36@gmail.com

    This file is part of QuteCsound.

    QuteCsound is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    QuteCsound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#ifndef QUTEWIDGET_H
#define QUTEWIDGET_H

#include <QtGui>
#include <QtXml>

#define QCS_CURRENT_XML_VERSION "2"
#define QCS_CURVE_BUFFER_SIZE 256
//#define USE_WIDGET_MUTEX

class QuteWidget : public QWidget
{
  Q_OBJECT
  public:
    QuteWidget(QWidget* parent);
    ~QuteWidget();

    virtual void setWidgetGeometry(int x, int y, int w, int h);
    virtual void setValue(double);  // These should only be reimplemented if something special needs to be done with the value.
    virtual void setValue2(double);
    virtual void setValue(QString);

    virtual void widgetMessage(QString path, QString text);
    virtual void widgetMessage(QString path, double value);

    virtual QString getWidgetLine() = 0;
    virtual QString getCabbageLine();
    virtual QString getCsladspaLine();
    virtual QString getWidgetXmlText() = 0;
    virtual QString getChannelName();
    virtual QString getChannel2Name();
    virtual double getValue();
    virtual double getValue2();
    virtual QString getStringValue();

    QString getUuid();
    virtual QString getWidgetType() = 0;
    virtual void refreshWidget() { ;}

    virtual void applyInternalProperties();

    void createXmlWriter(QXmlStreamWriter &s);
    void markChanged();
    void canFocus(bool can);

    bool m_valueChanged;
    bool m_value2Changed;

  public slots:
    void popUpMenu(QPoint pos);
    void openProperties();

  protected:
    QSpinBox *xSpinBox;
    QSpinBox *ySpinBox;
    QSpinBox *wSpinBox;
    QSpinBox *hSpinBox;
    QLabel *channelLabel;
    QLineEdit *nameLineEdit;
    QWidget *m_widget;
    QDialog *dialog;
    QGridLayout *layout;  // For preference dialog
    double m_value, m_value2;
    QString m_stringValue;
    QString m_channel, m_channel2;

#ifdef  USE_WIDGET_MUTEX
    QReadWriteLock widgetLock;
#endif
    QString xmlText;

    virtual void contextMenuEvent(QContextMenuEvent *event);

    virtual void createPropertiesDialog();
    virtual void applyProperties();

    QList<QAction *> getParentActionList();
    QList<QAction *> getParentPresetList();

  protected slots:
    void apply();
    void deleteWidget();

  private:

    QAction *propertiesAct;

    QPushButton *applyButton;
    QPushButton *cancelButton;
    QPushButton *acceptButton;

  signals:
    void newValue(QPair<QString,double> channelValue);
    void newValue(QPair<QString,QString> channelValue);
    void widgetChanged(QuteWidget* widget);
    void deleteThisWidget(QuteWidget *thisWidget);
    void propertiesAccepted();
};

#endif
