/*
 * Decompiled with CFR 0.152.
 */
package king.points;

import driftwood.r3.Transform;
import java.awt.Color;
import king.core.Engine;
import king.core.Engine2D;
import king.core.KPaint;
import king.points.BallPoint;
import king.points.ProxyPoint;

public class SpherePoint
extends BallPoint {
    static final int N_DISKS = 16;
    static final double[] sin = new double[16];
    static final double[] cos = new double[16];
    DiskProxyPoint[] proxies = new DiskProxyPoint[15];

    public SpherePoint(String string) {
        super(string);
        for (int i = 1; i < 16; ++i) {
            this.proxies[i - 1] = new DiskProxyPoint(this, i);
        }
    }

    public void doTransform(Engine engine, Transform transform, double d) {
        super.doTransform(engine, transform, d);
        for (int i = 1; i < 16; ++i) {
            engine.addPaintable(this.proxies[i - 1], (double)this.z + sin[i] * (double)this.r);
        }
    }

    public void paint2D(Engine2D engine2D) {
        KPaint kPaint = this.getDrawingColor(engine2D);
        if (kPaint.isInvisible()) {
            return;
        }
        Color color = kPaint.getPaint(engine2D.backgroundMode, 0.0, engine2D.colorCue, 255);
        engine2D.painter.paintSphereDisk(color, this.x, this.y, this.z, this.r);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            SpherePoint.sin[i] = (double)i / 16.0;
            SpherePoint.cos[i] = Math.sqrt(1.0 - sin[i] * sin[i]);
        }
    }

    public static class DiskProxyPoint
    extends ProxyPoint {
        int diskLevel;

        protected DiskProxyPoint(BallPoint ballPoint, int n) {
            super(ballPoint);
            this.diskLevel = n;
        }

        public void paint2D(Engine2D engine2D) {
            KPaint kPaint = this.getDrawingColor(engine2D);
            if (kPaint.isInvisible()) {
                return;
            }
            Color color = kPaint.getPaint(engine2D.backgroundMode, sin[this.diskLevel], engine2D.colorCue, 255);
            double d = cos[this.diskLevel] * (double)((BallPoint)this.proxyFor).r;
            engine2D.painter.paintSphereDisk(color, this.getDrawX(), this.getDrawY(), this.getDrawZ(), d);
        }
    }
}

