/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.r3.Transform;
import driftwood.util.Props;
import driftwood.util.SoftLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import king.BasicTool;
import king.KMessage;
import king.KinCanvas;
import king.KingMain;
import king.KingPrefs;
import king.Plugin;
import king.ToolServices;
import king.core.Engine;
import king.core.Kinemage;
import king.core.Painter;
import king.core.Transformable;

public class ToolBox
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
Transformable,
KMessage.Subscriber {
    static final String MENU_MAIN = "<main menu>";
    static final String MENU_NONE = "<not shown>";
    static final String MENU_IMPORT = "<import>";
    static final String MENU_EXPORT = "<export>";
    public KingMain kMain;
    public KinCanvas kCanvas;
    public ToolServices services;
    public Collection<Transformable> transformables;
    ArrayList plugins;
    BasicTool activeTool;
    final BasicTool defaultTool;
    JMenuItem activeToolMI = null;
    JMenuItem defaultToolMI = null;
    ClassLoader pluginClassLoader;
    static final long RESET_TOOL = 28L;

    public ToolBox(KingMain kingMain, KinCanvas kinCanvas) {
        this.kMain = kingMain;
        this.kCanvas = kinCanvas;
        this.services = new ToolServices(this);
        this.transformables = new ArrayList<Transformable>();
        this.pluginClassLoader = this.makeClassLoader();
        this.plugins = new ArrayList();
        this.defaultTool = this.activeTool = new BasicTool(this);
        this.plugins.add(this.activeTool);
        this.loadPlugins();
        this.activeTool.start();
        this.kMain.subscribe(this);
    }

    protected ClassLoader makeClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (this.kMain.isTrusted()) {
                File file = new File(this.kMain.getPrefs().jarFileDirectory, "plugins");
                if (!(file.exists() && file.canRead() && file.isDirectory())) {
                    return classLoader;
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].exists() || !fileArray[i].canRead() || !fileArray[i].isFile() || !fileArray[i].getName().toLowerCase().endsWith(".jar")) continue;
                    try {
                        arrayList.add(fileArray[i].toURL());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        SoftLog.err.println(malformedURLException.getMessage());
                    }
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), classLoader);
                return uRLClassLoader;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(SoftLog.err);
        }
        return classLoader;
    }

    void loadPlugins() {
        int n;
        ArrayList arrayList = new ArrayList(this.scanForPlugins());
        do {
            n = arrayList.size();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.canLoadPlugin(string)) continue;
                this.addPluginByName(string);
                iterator.remove();
            }
        } while (n > arrayList.size());
        Collections.sort(this.plugins, new PluginComparator());
    }

    Collection scanForPlugins() {
        Closeable closeable;
        URL uRL;
        Enumeration<URL> enumeration;
        Cloneable cloneable;
        try {
            cloneable = (Props)this.kMain.getPrefs().getDefaults();
            enumeration = this.pluginClassLoader.getResources("king/king_prefs");
            while (enumeration.hasMoreElements()) {
                uRL = enumeration.nextElement();
                try {
                    closeable = uRL.openStream();
                    ((Properties)cloneable).load((InputStream)closeable);
                    ((InputStream)closeable).close();
                }
                catch (IOException iOException) {
                    SoftLog.err.println("Plugin SPI error: " + iOException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
        cloneable = new ArrayList();
        try {
            enumeration = this.pluginClassLoader.getResources("META-INF/services/king.Plugin");
            while (enumeration.hasMoreElements()) {
                uRL = enumeration.nextElement();
                try {
                    String string;
                    closeable = new LineNumberReader(new InputStreamReader(uRL.openStream()));
                    while ((string = ((LineNumberReader)closeable).readLine()) != null) {
                        if ((string = string.trim()).equals("") || string.startsWith("#")) continue;
                        cloneable.add(string);
                    }
                }
                catch (IOException iOException) {
                    SoftLog.err.println("Plugin SPI error: " + iOException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
        return cloneable;
    }

    boolean canLoadPlugin(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.plugins.iterator();
        while (object.hasNext()) {
            hashSet.add(object.next().getClass().getName());
        }
        try {
            object = Class.forName(string, true, this.pluginClassLoader);
            Method method = ((Class)object).getMethod("isAppletSafe", new Class[0]);
            Boolean bl = (Boolean)method.invoke(null, new Object[0]);
            if (!this.kMain.isTrusted() && !bl.booleanValue()) {
                return false;
            }
            Method method2 = ((Class)object).getMethod("getDependencies", new Class[0]);
            Collection collection = (Collection)method2.invoke(null, new Object[0]);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (hashSet.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            if (this.kMain.isTrusted()) {
                SoftLog.err.println(throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
            }
            return false;
        }
    }

    public List getPluginList() {
        return Collections.unmodifiableList(this.plugins);
    }

    public String getPluginMenuName(Plugin plugin) {
        KingPrefs kingPrefs = this.kMain.getPrefs();
        String string = kingPrefs.getString(plugin.getClass().getName() + ".menuName", MENU_MAIN).trim();
        if (string.equals("")) {
            string = MENU_MAIN;
        }
        return string;
    }

    private boolean addPluginByName(String string) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(string)) continue;
            return true;
        }
        try {
            Plugin plugin;
            Class[] classArray = new Class[]{ToolBox.class};
            Object[] objectArray = new Object[]{this};
            Class<?> clazz = Class.forName(string, true, this.pluginClassLoader);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            plugin = (Plugin)constructor.newInstance(objectArray);
            this.plugins.add(plugin);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(SoftLog.err);
            SoftLog.err.println("While trying to load '" + string + "': " + throwable.getMessage());
            return false;
        }
        return true;
    }

    public void addPluginsToToolsMenu(JMenu jMenu) {
        JMenu jMenu2;
        Object object;
        this.activeToolMI = null;
        this.defaultToolMI = null;
        HashMap<Object, JMenu> hashMap = new HashMap<Object, JMenu>();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Plugin plugin : this.plugins) {
            JMenuItem jMenuItem = plugin.getToolsMenuItem();
            if (jMenuItem != null) {
                object = this.getPluginMenuName(plugin);
                if (MENU_MAIN.equals(object)) {
                    jMenu.add(jMenuItem);
                } else if (!(MENU_NONE.equals(object) || MENU_IMPORT.equals(object) || MENU_EXPORT.equals(object))) {
                    jMenu2 = (JMenu)hashMap.get(object);
                    if (jMenu2 == null) {
                        jMenu2 = new JMenu((String)object);
                        hashMap.put(object, jMenu2);
                    }
                    jMenu2.add(jMenuItem);
                }
            }
            if (!(plugin instanceof BasicTool) || jMenuItem == null) continue;
            buttonGroup.add(jMenuItem);
            if (plugin == this.defaultTool) {
                this.defaultToolMI = jMenuItem;
            }
            if (plugin != this.activeTool) continue;
            this.activeToolMI = jMenuItem;
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList, new MenuComparator());
        object = arrayList.iterator();
        while (object.hasNext()) {
            jMenu2 = (JMenu)object.next();
            jMenu.add(jMenu2);
        }
        if (this.activeToolMI != null) {
            this.activeToolMI.setSelected(true);
        }
    }

    public void addPluginsToHelpMenu(JMenu jMenu) {
        for (Plugin plugin : this.plugins) {
            JMenuItem jMenuItem = plugin.getHelpMenuItem();
            if (jMenuItem == null) continue;
            jMenu.add(jMenuItem);
        }
    }

    public void addPluginsToSpecialMenu(String string, JMenu jMenu) {
        for (Plugin plugin : this.plugins) {
            JMenuItem jMenuItem;
            String string2 = this.getPluginMenuName(plugin);
            if (!string.equals(string2) || (jMenuItem = plugin.getToolsMenuItem()) == null) continue;
            jMenu.add(jMenuItem);
        }
    }

    public void toolActivated(BasicTool basicTool) {
        this.activeTool.stop();
        this.activeTool = basicTool;
        this.activeTool.start();
    }

    public void activateDefaultTool() {
        if (this.defaultToolMI != null) {
            this.defaultToolMI.setSelected(true);
        }
        this.toolActivated(this.defaultTool);
    }

    public void deliverMessage(KMessage kMessage) {
        if (kMessage.testProg(28L)) {
            this.services.clearEverything();
            Kinemage kinemage = this.kMain.getKinemage();
            if (kinemage != null) {
                this.services.doFlatland.setSelected(kinemage.atFlat);
            }
            this.activeTool.reset();
        }
    }

    public void listenTo(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            ActionMap actionMap = jComponent.getActionMap();
            InputMap inputMap = jComponent.getInputMap(0);
            ReflectiveAction reflectiveAction = new ReflectiveAction("", null, this, "onArrowUp");
            ReflectiveAction reflectiveAction2 = new ReflectiveAction("", null, this, "onArrowDown");
            ReflectiveAction reflectiveAction3 = new ReflectiveAction("", null, this, "onArrowLeft");
            ReflectiveAction reflectiveAction4 = new ReflectiveAction("", null, this, "onArrowRight");
            actionMap.put("arrow-up", reflectiveAction);
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "arrow-up");
            inputMap.put(KeyStroke.getKeyStroke(38, 1), "arrow-up");
            inputMap.put(KeyStroke.getKeyStroke(38, 2), "arrow-up");
            inputMap.put(KeyStroke.getKeyStroke(38, 3), "arrow-up");
            actionMap.put("arrow-down", reflectiveAction2);
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "arrow-down");
            inputMap.put(KeyStroke.getKeyStroke(40, 1), "arrow-down");
            inputMap.put(KeyStroke.getKeyStroke(40, 2), "arrow-down");
            inputMap.put(KeyStroke.getKeyStroke(40, 3), "arrow-down");
            actionMap.put("arrow-left", reflectiveAction3);
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "arrow-left");
            inputMap.put(KeyStroke.getKeyStroke(37, 1), "arrow-left");
            inputMap.put(KeyStroke.getKeyStroke(37, 2), "arrow-left");
            inputMap.put(KeyStroke.getKeyStroke(37, 3), "arrow-left");
            actionMap.put("arrow-right", reflectiveAction4);
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "arrow-right");
            inputMap.put(KeyStroke.getKeyStroke(39, 1), "arrow-right");
            inputMap.put(KeyStroke.getKeyStroke(39, 2), "arrow-right");
            inputMap.put(KeyStroke.getKeyStroke(39, 3), "arrow-right");
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.activeTool.mouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.activeTool.mouseMoved(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.activeTool.mouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.activeTool.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.activeTool.mouseExited(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.kCanvas.requestFocus();
        this.activeTool.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.activeTool.mouseReleased(mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.activeTool.mouseWheelMoved(mouseWheelEvent, mouseWheelEvent.getWheelRotation());
    }

    public void onArrowUp(ActionEvent actionEvent) {
        this.activeTool.onArrowUp(actionEvent);
    }

    public void onArrowDown(ActionEvent actionEvent) {
        this.activeTool.onArrowDown(actionEvent);
    }

    public void onArrowRight(ActionEvent actionEvent) {
        this.activeTool.onArrowRight(actionEvent);
    }

    public void onArrowLeft(ActionEvent actionEvent) {
        this.activeTool.onArrowLeft(actionEvent);
    }

    public void doTransform(Engine engine, Transform transform) {
        for (Transformable transformable : this.transformables) {
            transformable.doTransform(engine, transform);
        }
        this.services.doTransform(engine, transform);
        this.activeTool.doTransform(engine, transform);
    }

    public void overpaintCanvas(Painter painter) {
        this.services.overpaintCanvas(painter);
        this.activeTool.overpaintCanvas(painter);
    }

    static class MenuComparator
    implements Comparator {
        MenuComparator() {
        }

        public int compare(Object object, Object object2) {
            JMenu jMenu = (JMenu)object;
            JMenu jMenu2 = (JMenu)object2;
            return jMenu.getText().compareTo(jMenu2.getText());
        }
    }

    static class PluginComparator
    implements Comparator {
        PluginComparator() {
        }

        public int compare(Object object, Object object2) {
            boolean bl = object instanceof BasicTool;
            boolean bl2 = object2 instanceof BasicTool;
            if (bl && !bl2) {
                return -1;
            }
            if (bl2 && !bl) {
                return 1;
            }
            return object.toString().compareTo(object2.toString());
        }
    }
}

