/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEUNITSDIALOG_H
#define QALCULATEUNITSDIALOG_H

#include <kdialog.h>
#include <qmap.h>
#include <qvaluevector.h>

class Unit;
class QalculateEditUnitDialog;
class KListView;
class QListViewItem;
class QPushButton;
class KLineEdit;
class QLabel;
class KComboBox;
class QGroupBox;

/**
@author Niklas Knutsson
*/
class QalculateUnitsDialog : public KDialog {

	Q_OBJECT

public:

	QalculateUnitsDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateUnitsDialog();

	QalculateEditUnitDialog *unit_edit_dialog;
	QString selected_category;
	Unit *selected_unit, *selected_to_unit;
	void addUnitTreeItem(Unit *f);
	QMap<QListViewItem*, Unit*> unitItems;
	QMap<QListViewItem*, QString> categoryItems;
	QValueVector<Unit*> comboItems;

	QGroupBox *convertGroup;
	KListView *categoryView;
	KListView *unitView;
	QPushButton *newButton;
	QPushButton *editButton;
	QPushButton *deleteButton;
	QPushButton *deactivateButton;
	QPushButton *insertButton;
	QPushButton *helpButton;
	QPushButton *buttonClose;
	QPushButton *convertResultButton;
	QPushButton *convertButton;
	QLabel *fromLabel, *equalsLabel;
	KLineEdit *toEdit, *fromEdit;
	KComboBox *toCombo;

	bool block_unit_convert;

public slots:

	void updateUnitTree();
	void unitDoubleClicked(QListViewItem*);
	void unitSelected();
	void categorySelected();
	void insertUnit();
	void deactivateUnit();
	void deleteUnit();
	void editUnit();
	void newUnit();
	void convertResult();
	void convertClicked();
	void convert();
	void convertReversed();
	void toUnitSelected(int);
	
protected slots:
	
	void slotHelp();	

signals:

	void unitsChanged();
	void insertRequest(Unit*);
	void convertRequest(Unit*);
	
protected:

	void keyPressEvent(QKeyEvent *e);

};

#endif
