/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEINSERTMATRIXVECTORDIALOG_H
#define QALCULATEINSERTMATRIXVECTORDIALOG_H

#include <kdialogbase.h>

class QTable;
class QLabel;
class QSpinBox;
class QRadioButton;
class KComboBox;
class KLineEdit;
class QPushButton;
class MathStructure;
class QalculateEditNamesDialog;
class KnownVariable;

/**
@author Niklas Knutsson
*/
class QalculateInsertMatrixVectorDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateInsertMatrixVectorDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateInsertMatrixVectorDialog();

	QString newMatrix();
	QString newVector();
	QString editMatrixVector(const MathStructure *initial_value = NULL, bool create_vector = false, bool is_text_struct = false, bool is_result = false);

	QLabel *elementsLabel;
	QRadioButton *matrixButton, *vectorButton;
	QTable *elementsTable;
	QSpinBox *rowsBox, *columnsBox;
	QString matrixstr;
	QPushButton *insertSelectionButton;

public slots:

	void typeChanged(int);
	void rowsChanged(int);
	void columnsChanged(int);
	void onSelectionChanged();
	
protected slots:
	
	void slotOk();
	void insertSelection();

};

#endif
