# Conversion of files between different charsets and surfaces.
# Copyright  1996-1999, 2000-2002 Free Software Foundation, Inc.
# Contributed by Franois Pinard <pinard@iro.umontreal.ca>, 1996.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with the `recode' Library; see the file `COPYING.LIB'.
# If not, write to the Free Software Foundation, Inc., 59 Temple Place -
# Suite 330, Boston, MA 02111-1307, USA.

import recode

declares = [
    ('ISO-10646-UCS-4',
     'UCS', 'UCS-4', 'ISO-10646-UCS-4', 'ISO_10646', '10646', 'u4'),
    ('ISO-10646-UCS-2',
     # UNICODE-1-1 is explicitly defined as big-endian,
     # and must not carry a byte order mark.  RFC 1641.
     # 'UNICODE-1-1',
     'UCS-2', 'BMP', 'u2', 'rune',
     'unicode_internal'),
    ('combined-UCS-2', 'co'),
    ]

# FIXME: UCS-4 not implemented.

# FIXME: Combined should really be some kind of surface.

class Combined(recode.GenericStep):
    internal_coding = 'combined-UCS-2'
    external_coding = recode.UNICODE_STRING
    data = [
        # Diacriticized letters.
        (u'\u00C0', u'\u0041\u0300'),
        (u'\u00C1', u'\u0041\u0301'),
        (u'\u00C2', u'\u0041\u0302'),
        (u'\u00C3', u'\u0041\u0303'),
        (u'\u00C4', u'\u0041\u0308'),
        (u'\u00C5', u'\u0041\u030A'),
        (u'\u00C7', u'\u0043\u0327'),
        (u'\u00C8', u'\u0045\u0300'),
        (u'\u00C9', u'\u0045\u0301'),
        (u'\u00CA', u'\u0045\u0302'),
        (u'\u00CB', u'\u0045\u0308'),
        (u'\u00CC', u'\u0049\u0300'),
        (u'\u00CD', u'\u0049\u0301'),
        (u'\u00CE', u'\u0049\u0302'),
        (u'\u00CF', u'\u0049\u0308'),
        (u'\u00D1', u'\u004E\u0303'),
        (u'\u00D2', u'\u004F\u0300'),
        (u'\u00D3', u'\u004F\u0301'),
        (u'\u00D4', u'\u004F\u0302'),
        (u'\u00D5', u'\u004F\u0303'),
        (u'\u00D6', u'\u004F\u0308'),
        (u'\u00D8', u'\u004F\u0338'),
        (u'\u00D9', u'\u0055\u0300'),
        (u'\u00DA', u'\u0055\u0301'),
        (u'\u00DB', u'\u0055\u0302'),
        (u'\u00DC', u'\u0055\u0308'),
        (u'\u00DD', u'\u0059\u0301'),
        (u'\u00E0', u'\u0061\u0300'),
        (u'\u00E1', u'\u0061\u0301'),
        (u'\u00E2', u'\u0061\u0302'),
        (u'\u00E3', u'\u0061\u0303'),
        (u'\u00E4', u'\u0061\u0308'),
        (u'\u00E5', u'\u0061\u030A'),
        (u'\u00E7', u'\u0063\u0327'),
        (u'\u00E8', u'\u0065\u0300'),
        (u'\u00E9', u'\u0065\u0301'),
        (u'\u00EA', u'\u0065\u0302'),
        (u'\u00EB', u'\u0065\u0308'),
        (u'\u00EC', u'\u0069\u0300'),
        (u'\u00ED', u'\u0069\u0301'),
        (u'\u00EE', u'\u0069\u0302'),
        (u'\u00EF', u'\u0069\u0308'),
        (u'\u00F1', u'\u006E\u0303'),
        (u'\u00F2', u'\u006F\u0300'),
        (u'\u00F3', u'\u006F\u0301'),
        (u'\u00F4', u'\u006F\u0302'),
        (u'\u00F5', u'\u006F\u0303'),
        (u'\u00F6', u'\u006F\u0308'),
        (u'\u00F8', u'\u006F\u0338'),
        (u'\u00F9', u'\u0075\u0300'),
        (u'\u00FA', u'\u0075\u0301'),
        (u'\u00FB', u'\u0075\u0302'),
        (u'\u00FC', u'\u0075\u0308'),
        (u'\u00FD', u'\u0079\u0301'),
        (u'\u00FF', u'\u0079\u0308'),
        (u'\u0100', u'\u0041\u0304'),
        (u'\u0101', u'\u0061\u0304'),
        (u'\u0102', u'\u0041\u0306'),
        (u'\u0103', u'\u0061\u0306'),
        (u'\u0104', u'\u0041\u0328'),
        (u'\u0105', u'\u0061\u0328'),
        (u'\u0106', u'\u0043\u0301'),
        (u'\u0107', u'\u0063\u0301'),
        (u'\u0108', u'\u0043\u0302'),
        (u'\u0109', u'\u0063\u0302'),
        (u'\u010A', u'\u0043\u0307'),
        (u'\u010B', u'\u0063\u0307'),
        (u'\u010C', u'\u0043\u030C'),
        (u'\u010D', u'\u0063\u030C'),
        (u'\u010E', u'\u0044\u030C'),
        (u'\u010F', u'\u0064\u030C'),
        (u'\u0110', u'\u0044\u0335'),
        (u'\u0111', u'\u0064\u0335'),
        (u'\u0112', u'\u0045\u0304'),
        (u'\u0113', u'\u0065\u0304'),
        (u'\u0114', u'\u0045\u0306'),
        (u'\u0115', u'\u0065\u0306'),
        (u'\u0116', u'\u0045\u0307'),
        (u'\u0117', u'\u0065\u0307'),
        (u'\u0118', u'\u0045\u0328'),
        (u'\u0119', u'\u0065\u0328'),
        (u'\u011A', u'\u0045\u030C'),
        (u'\u011B', u'\u0065\u030C'),
        (u'\u011C', u'\u0047\u0302'),
        (u'\u011D', u'\u0067\u0302'),
        (u'\u011E', u'\u0047\u0306'),
        (u'\u011F', u'\u0067\u0306'),
        (u'\u0120', u'\u0047\u0307'),
        (u'\u0121', u'\u0067\u0307'),
        (u'\u0122', u'\u0047\u0327'),
        (u'\u0123', u'\u0067\u0327'),
        (u'\u0124', u'\u0048\u0302'),
        (u'\u0125', u'\u0068\u0302'),
        (u'\u0126', u'\u0048\u0335'),
        (u'\u0127', u'\u0068\u0335'),
        (u'\u0128', u'\u0049\u0303'),
        (u'\u0129', u'\u0069\u0303'),
        (u'\u012A', u'\u0049\u0304'),
        (u'\u012B', u'\u0069\u0304'),
        (u'\u012C', u'\u0049\u0306'),
        (u'\u012D', u'\u0069\u0306'),
        (u'\u012E', u'\u0049\u0328'),
        (u'\u012F', u'\u0069\u0328'),
        (u'\u0130', u'\u0049\u0307'),
        (u'\u0134', u'\u004A\u0302'),
        (u'\u0135', u'\u006A\u0302'),
        (u'\u0136', u'\u004B\u0327'),
        (u'\u0137', u'\u006B\u0327'),
        (u'\u0139', u'\u004C\u0301'),
        (u'\u013A', u'\u006C\u0301'),
        (u'\u013B', u'\u004C\u0327'),
        (u'\u013C', u'\u006C\u0327'),
        (u'\u013D', u'\u004C\u030C'),
        (u'\u013E', u'\u006C\u030C'),
        (u'\u0141', u'\u004C\u0337'),
        (u'\u0142', u'\u006C\u0337'),
        (u'\u0143', u'\u004E\u0301'),
        (u'\u0144', u'\u006E\u0301'),
        (u'\u0145', u'\u004E\u0327'),
        (u'\u0146', u'\u006E\u0327'),
        (u'\u0147', u'\u004E\u030C'),
        (u'\u0148', u'\u006E\u030C'),
        (u'\u014C', u'\u004F\u0304'),
        (u'\u014D', u'\u006F\u0304'),
        (u'\u014E', u'\u004F\u0306'),
        (u'\u014F', u'\u006F\u0306'),
        (u'\u0150', u'\u004F\u030B'),
        (u'\u0151', u'\u006F\u030B'),
        (u'\u0154', u'\u0052\u0301'),
        (u'\u0155', u'\u0072\u0301'),
        (u'\u0156', u'\u0052\u0327'),
        (u'\u0157', u'\u0072\u0327'),
        (u'\u0158', u'\u0052\u030C'),
        (u'\u0159', u'\u0072\u030C'),
        (u'\u015A', u'\u0053\u0301'),
        (u'\u015B', u'\u0073\u0301'),
        (u'\u015C', u'\u0053\u0302'),
        (u'\u015D', u'\u0073\u0302'),
        (u'\u015E', u'\u0053\u0327'),
        (u'\u015F', u'\u0073\u0327'),
        (u'\u0160', u'\u0053\u030C'),
        (u'\u0161', u'\u0073\u030C'),
        (u'\u0162', u'\u0054\u0327'),
        (u'\u0163', u'\u0074\u0327'),
        (u'\u0164', u'\u0054\u030C'),
        (u'\u0165', u'\u0074\u030C'),
        (u'\u0166', u'\u0054\u0335'),
        (u'\u0167', u'\u0074\u0335'),
        (u'\u0168', u'\u0055\u0303'),
        (u'\u0169', u'\u0075\u0303'),
        (u'\u016A', u'\u0055\u0304'),
        (u'\u016B', u'\u0075\u0304'),
        (u'\u016C', u'\u0055\u0306'),
        (u'\u016D', u'\u0075\u0306'),
        (u'\u016E', u'\u0055\u030A'),
        (u'\u016F', u'\u0075\u030A'),
        (u'\u0170', u'\u0055\u030B'),
        (u'\u0171', u'\u0075\u030B'),
        (u'\u0172', u'\u0055\u0328'),
        (u'\u0173', u'\u0075\u0328'),
        (u'\u0174', u'\u0057\u0302'),
        (u'\u0175', u'\u0077\u0302'),
        (u'\u0176', u'\u0059\u0302'),
        (u'\u0177', u'\u0079\u0302'),
        (u'\u0178', u'\u0059\u0308'),
        (u'\u0179', u'\u005A\u0301'),
        (u'\u017A', u'\u007A\u0301'),
        (u'\u017B', u'\u005A\u0307'),
        (u'\u017C', u'\u007A\u0307'),
        (u'\u017D', u'\u005A\u030C'),
        (u'\u017E', u'\u007A\u030C'),
        (u'\u0180', u'\u0062\u0335'),
        (u'\u0197', u'\u0049\u0335'),
        (u'\u019A', u'\u006C\u0335'),
        (u'\u019B', u'\u03BB\u0335'),
        (u'\u019F', u'\u004F\u0335'),
        (u'\u01A0', u'\u004F\u031B'),
        (u'\u01A1', u'\u006F\u031B'),
        (u'\u01AB', u'\u0074\u0321'),
        (u'\u01AE', u'\u0054\u0322'),
        (u'\u01AF', u'\u0055\u031B'),
        (u'\u01B0', u'\u0075\u031B'),
        (u'\u01CD', u'\u0041\u030C'),
        (u'\u01CE', u'\u0061\u030C'),
        (u'\u01CF', u'\u0049\u030C'),
        (u'\u01D0', u'\u0069\u030C'),
        (u'\u01D1', u'\u004F\u030C'),
        (u'\u01D2', u'\u006F\u030C'),
        (u'\u01D3', u'\u0055\u030C'),
        (u'\u01D4', u'\u0075\u030C'),
        (u'\u01D5', (u'\u0055\u0308\u0304', u'\u00DC\u0304')),
        (u'\u01D6', (u'\u0075\u0308\u0304', u'\u00FC\u0304')),
        (u'\u01D7', (u'\u0055\u0308\u0301', u'\u00DC\u0301')),
        (u'\u01D8', (u'\u0075\u0308\u0301', u'\u00FC\u0301')),
        (u'\u01D9', (u'\u0055\u0308\u030C', u'\u00DC\u030C')),
        (u'\u01DA', (u'\u0075\u0308\u030C', u'\u00FC\u030C')),
        (u'\u01DB', (u'\u0055\u0308\u0300', u'\u00DC\u0300')),
        (u'\u01DC', (u'\u0075\u0308\u0300', u'\u00FC\u0300')),
        (u'\u01DE', (u'\u0041\u0308\u0304', u'\u00C4\u0304')),
        (u'\u01DF', (u'\u0061\u0308\u0304', u'\u00E4\u0304')),
        (u'\u01E0', u'\u0041\u0307\u0304'),
        (u'\u01E1', u'\u0061\u0307\u0304'),
        (u'\u01E2', u'\u00C6\u0304'),
        (u'\u01E3', u'\u00E6\u0304'),
        (u'\u01E4', u'\u0047\u0335'),
        (u'\u01E5', u'\u0067\u0335'),
        (u'\u01E6', u'\u0047\u030C'),
        (u'\u01E7', u'\u0067\u030C'),
        (u'\u01E8', u'\u004B\u030C'),
        (u'\u01E9', u'\u006B\u030C'),
        (u'\u01EA', u'\u004F\u0328'),
        (u'\u01EB', u'\u006F\u0328'),
        (u'\u01EC', (u'\u004F\u0328\u0304', u'\u01EA\u0304')),
        (u'\u01ED', (u'\u006F\u0328\u0304', u'\u01EB\u0304')),
        (u'\u01EE', u'\u01B7\u030C'),
        (u'\u01EF', u'\u0292\u030C'),
        (u'\u01F0', u'\u006A\u030C'),
        (u'\u0386', u'\u0391\u0384'),
        (u'\u0388', u'\u0395\u0384'),
        (u'\u0389', u'\u0397\u0384'),
        (u'\u038A', u'\u0399\u0384'),
        (u'\u038C', u'\u039F\u0384'),
        (u'\u038E', u'\u03A5\u0384'),
        (u'\u038F', u'\u03A9\u0384'),
        (u'\u0390', u'\u03B9\u0385'),
        (u'\u03AA', u'\u0399\u0308'),
        (u'\u03AB', u'\u03A5\u0308'),
        (u'\u03AC', u'\u03B1\u0384'),
        (u'\u03AD', u'\u03B5\u0384'),
        (u'\u03AE', u'\u03B7\u0384'),
        (u'\u03AF', u'\u03B9\u0384'),
        (u'\u03B0', u'\u03C5\u0385'),
        (u'\u03CA', u'\u03B9\u0308'),
        (u'\u03CB', u'\u03C5\u0308'),
        (u'\u03CC', u'\u03BF\u0384'),
        (u'\u03CD', u'\u03C5\u0384'),
        (u'\u03CE', u'\u03C9\u0384'),
        (u'\u03D3', u'\u03D2\u0384'),
        (u'\u03D4', u'\u03D2\u0308'),
        (u'\u0401', u'\u0415\u0308'),
        (u'\u0403', u'\u0413\u0301'),
        (u'\u0407', u'\u0406\u0308'),
        (u'\u040C', u'\u041A\u0301'),
        (u'\u040E', u'\u0423\u0306'),
        (u'\u0419', u'\u0418\u0306'),
        (u'\u0439', u'\u0438\u0306'),
        (u'\u0451', u'\u0435\u0308'),
        (u'\u0453', u'\u0433\u0301'),
        (u'\u0457', u'\u0456\u0308'),
        (u'\u045C', u'\u043A\u0301'),
        (u'\u045E', u'\u0443\u0306'),
        (u'\u0476', u'\u0474\u030F'),
        (u'\u0477', u'\u0475\u030F'),
        (u'\u0492', u'\u0413\u0335'),
        (u'\u0493', u'\u0433\u0335'),
        (u'\u0498', u'\u0417\u0327'),
        (u'\u0499', u'\u0437\u0327'),
        (u'\u04AA', u'\u0421\u0327'),
        (u'\u04AB', u'\u0441\u0327'),
        (u'\u04B0', u'\u04AE\u0335'),
        (u'\u04B1', u'\u04AF\u0335'),
        (u'\u04BE', u'\u04BC\u0328'),
        (u'\u04BF', u'\u04BD\u0328'),
        (u'\u04C1', u'\u0416\u0306'),
        (u'\u04C2', u'\u0436\u0306'),
        (u'\u04C5', u'\u041A\u0328'),
        (u'\u04C6', u'\u043A\u0328'),
        (u'\u04C9', u'\u0425\u0328'),
        (u'\u04CA', u'\u0445\u0328'),
        (u'\u0958', u'\u0915\u093C'),
        (u'\u0959', u'\u0916\u093C'),
        (u'\u095A', u'\u0917\u093C'),
        (u'\u095B', u'\u091C\u093C'),
        (u'\u095C', u'\u0921\u093C'),
        (u'\u095D', u'\u0922\u093C'),
        (u'\u095E', u'\u092B\u093C'),
        (u'\u095F', u'\u092F\u093C'),
        (u'\u09DC', u'\u09A1\u09BC'),
        (u'\u09DD', u'\u09A2\u09BC'),
        (u'\u09DF', u'\u09AF\u09BC'),
        (u'\u0A59', u'\u0A16\u0A3C'),
        (u'\u0A5A', u'\u0A17\u0A3C'),
        (u'\u0A5B', u'\u0A1C\u0A3C'),
        (u'\u0A5C', u'\u0A21\u0A3C'),
        (u'\u0A5E', u'\u0A2B\u0A3C'),
        (u'\u0B5C', u'\u0B21\u0B3C'),
        (u'\u0B5D', u'\u0B22\u0B3C'),
        (u'\u0B5F', u'\u0B2F\u0B3C'),
        (u'\u1014', u'\u1004\u104C'),
        (u'\u1015', u'\u1005\u104C'),
        (u'\u1016', u'\u1006\u104C'),
        # Ligatures, digraphs.
        (u'\u00C6', u'\u0041\u0045'),
        (u'\u00E6', u'\u0061\u0065'),
        (u'\u0132', u'\u0049\u004A'),
        (u'\u0133', u'\u0069\u006A'),
        (u'\u013F', u'\u004C\u00B7'),
        (u'\u0140', u'\u006C\u00B7'),
        (u'\u0149', u'\u0027\u006E'),
        (u'\u0152', u'\u004F\u0045'),
        (u'\u0153', u'\u006F\u0065'),
        (u'\u01C4', (u'\u0044\u005A\u030C', u'\u0044\u017D')),
        (u'\u01C5', (u'\u0044\u007A\u030C', u'\u0044\u017E')),
        (u'\u01C6', (u'\u0064\u007A\u030C', u'\u0064\u017E')),
        (u'\u01C7', u'\u004C\u004A'),
        (u'\u01C8', u'\u004C\u006A'),
        (u'\u01C9', u'\u006C\u006A'),
        (u'\u01CA', u'\u004E\u004A'),
        (u'\u01CB', u'\u004E\u006A'),
        (u'\u01CC', u'\u006E\u006A'),
        (u'\u02A3', u'\u0064\u007A'),
        (u'\u02A4', u'\u0064\u0292'),
        (u'\u02A5', u'\u0064\u0291'),
        (u'\u02A6', u'\u0074\u0073'),
        (u'\u02A7', u'\u0074\u0283'),
        (u'\u02A8', u'\u0074\u0255'),
        (u'\u0409', u'\u041B\u042C'),
        (u'\u040A', u'\u041D\u042C'),
        (u'\u0459', u'\u043B\u044C'),
        (u'\u045A', u'\u043D\u044C'),
        (u'\u0EDC', u'\u0EAB\u0E99'),
        (u'\u0EDD', u'\u0EAB\u0EA1'),
        (u'\u203C', u'\u0021\u0021'),
        (u'\u203D', u'\u003F\u0021'),
        ]
