#!/usr/bin/python
# -*- coding: utf-8 -*-

#  Copyright © 2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, os
import datetime
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
os.environ['COLUMNS'] = '1000'
try:
    __builtins__._ = lambda x: x
    __builtins__.ngettext = lambda s, p, n: (s if n == 1 else p)
except AttributeError:
    __builtins__['_'] = lambda x: x
    __builtins__['ngettext'] = lambda s, p, n: (s if n == 1 else p)
    

def set_domain(localedir, lang):
    os.environ['LANGUAGE'] = lang
    try:
        from pybiklib import config
        import gettext
        gettext.install(config.PACKAGE, localedir, names=['ngettext'])
    except ImportError:
        print 'gettext not found.'

template = ur'''
.\"This file is generated automatically.
.TH {app} 6 "{date}" ""

.SH {NAME}
{program} - {description}

.SH {SYNOPSIS}
.B {program}
{options}
.br

.SH {OPTIONS}'''
template_option = ur'''
.B
.IP {option}
{help}'''

def write_manpage(outfile):
    from pybiklib import main, config
    parser = main.arg_parser()
    options = parser.format_usage()
    options = options.lstrip('usage:')
    options = options.strip()
    options = options.lstrip(parser.prog)
    options = options.strip()
    options = options.replace('-', '\-')
    outfile.write(template.format(
                        app=unicode(config.get_appname_short(),'utf-8'),
                        date=str(datetime.date.today()),
                        NAME=unicode(_('NAME'),'utf-8'),
                        program=config.PACKAGE,
                        description=parser.description,
                        SYNOPSIS=unicode(_('SYNOPSIS'),'utf-8'),
                        options=options,
                        OPTIONS=unicode(_('OPTIONS'),'utf-8'),
                    ).encode('utf8'))
    for action in parser._actions:
        if action.metavar is None:
            option = r',\ '.join(action.option_strings)
        else:
            option = r',\ '.join(r'\ '.join((o, action.metavar)) for o in action.option_strings)
        option = option.replace('-', '\-')
        outfile.write(template_option.format(
                        option=option,
                        help=action.help,
                    ).encode('utf8'))
    outfile.write('\n')
        
def main_():
    if len(sys.argv) > 1 and sys.argv[1]:
        filename = sys.argv[1]
        outfile = open(filename, 'w')
    else:
        filename = None
        outfile = sys.stdout
    if len(sys.argv) > 3 and sys.argv[2] and sys.argv[3]:
        set_domain(sys.argv[2], sys.argv[3])
    try:
        write_manpage(outfile)
    finally:
        if filename is not None:
            outfile.close()
            
if __name__ == '__main__':
    sys.exit(main_())
    

