#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Ported from GNUbik
# Original filename: main.c
# Original copyright and license:
#/*
#    GNUbik -- A 3 dimensional magic cube game.
#    Copyright (C) 1998, 2003--2004  John Darrington
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License,  or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#*/

import sys
import argparse
argparse._ = _

from . import debug, config


def import_(pure_python):
    if not pure_python:
        try:
            import cube_c
            sys.modules['pybiklib.cube'] = cube_c
            sys.modules['cube_c'] = cube_c
        except ImportError as e:
            print e
            print 'Unable to import module cube_c, using slow fallback.'
            pure_python = True
    if not pure_python:
        try:
            import drwBlock_c
            sys.modules['pybiklib.drwBlock'] = drwBlock_c
            sys.modules['drwBlock_c'] = drwBlock_c
        except ImportError as e:
            del sys.modules['pybiklib.cube']
            del sys.modules['cube_c']
            print e
            print 'Unable to import module drwBlock_c, using slow fallback.'
            pure_python = True
    if not pure_python:
        try:
            import glarea_common_c
            sys.modules['pybiklib.glarea_common'] = glarea_common_c
        except ImportError as e:
            del sys.modules['pybiklib.cube']
            del sys.modules['cube_c']
            del sys.modules['pybiklib.drwBlock']
            del sys.modules['drwBlock_c']
            print e
            print 'Unable to import module glarea_common_c, using slow fallback.'
        else:
            return
    try:
        import cython
        debug.debug('cython found')
        cython.float[5]
        debug.debug('cython types support indexing')
    except (ImportError, TypeError):
        debug.debug('cython not found or types do not support indexing: simulate')
        def _ctype(type_):
            class _CType (object):
                def __call__(self, *args):
                    return type_(*args)
                def __getitem__(self, n):
                    return lambda: [None]*n
            return _CType()
        
        sys.modules['cython'] = cython = type(sys)('cython')
        cython.compiled = False
        def declare(*args, **kwags):
            if len(args) == 1:
                return args[0]()
            if len(args) == 2:
                return args[0](args[1])
            assert len(args) == 0
        cython.declare = declare
        def struct(**kwargs):
            class _Struct (object):
                def __init__(self):
                    for k in kwargs:
                        setattr(self, k, None)
            return _Struct
        cython.struct = struct
        def locals(**kwargs):
            return lambda func: func
        cython.locals = locals
        cython.NULL = None
        cython.int = _ctype(int)
        cython.p_int = object
        cython.float = _ctype(float)
        cython.p_float = object
        cython.double = _ctype(float)
        cython.short = _ctype(int)
        cython.uchar = _ctype(int)
        cython.p_char = object
        

def run(argv, frameQty, cube_dimension, solved):
    # Create the top level widget --- that is,  the main window which everything
    #   goes in
    import application
    app = application.Application()
    if frameQty is not None:
        app.cube_area.frameQty = frameQty
    
    # create the cube
    app.first_new_game(cube_dimension, solved)
    
    app.start_main_loop()
    

debug_level_names = [__a[6:].lower()
                        for __a in debug.__all__
                            if __a.startswith('DEBUG_') and __a != 'DEBUG_LEVEL']
def arg_parser():
    '''Parse the command line'''
    parser = argparse.ArgumentParser(
            description=unicode(config.get_description(),'utf-8'),
            add_help=False,
            )
            
    # These strings are in the module argparse defined
    # and repeated here so that they are included in the pot-file.
    if False:
        _('usage: ')
        _('optional arguments')
        
    parser.add_argument('-h', '--help', action='help',
                help=unicode(_("Show help message and exit"),'utf-8'))
    parser.add_argument('--version', action='version', version=config.VERSION,
                help=unicode(_("Show version number and exit"),'utf-8'))
    parser.add_argument("-s", "--solved", action="store_true", default=False,
                help=unicode(_("Start with the cube already solved"),'utf-8'))
    parser.add_argument("--size", type=int, dest='cube_dimension',
                help=unicode(_("Start with a N x N x N sized cube"),'utf-8'), metavar="N")
    parser.add_argument("--animation", type=int, dest='frameQty',
                help=unicode(_("Show N intermediate positions in animations"),'utf-8'), metavar="N")
    parser.add_argument("--pure-python", action="store_true", default=False,
                help=unicode(_("Use python module for rendering (very slow)"),'utf-8'))
    parser.add_argument("--debug", type=str, dest='debug_level', default=-1,
                  help=unicode(_("Enable debug output, D is an integer or a comma-separated list of [{0}]"),'utf-8')
                                                        .format(','.join(debug_level_names)),
                  metavar="D")
                  
    return parser
    
def app_opts():
    parser = arg_parser()
    args = parser.parse_args()
    
    debug_level = args.debug_level
    debug_level_names_u = [a.upper() for a in debug_level_names]
    try:
        debug_level = int(debug_level)
        debug_level_max = sum([1<<i for i, n in enumerate(debug_level_names_u)])
        if not (-1 <= debug_level <= debug_level_max):
            parser.error(_("debug level out of range: {0}").format(debug_level))
    except ValueError:
        debug_level = debug_level.split(',')
        _debug_level_names = dict([(n, 1<<i) for i, n in enumerate(debug_level_names_u)])
        debug_level = [(d.upper() if d.upper() in _debug_level_names else d) for d in debug_level]
        try:
            debug_level = sum([_debug_level_names[d] for d in debug_level])
        except KeyError as e:
            parser.error(_("unknown debug option: {0}").format(e.args[0]))
    args.debug_modes = {'DEBUG_LEVEL': debug_level}
    
    if debug_level < 0:
        debug_level = 0
    debug_modes = reversed(bin(debug_level)[2:].rjust(len(debug_level_names_u),'0'))
    debug_modes = [bool(int(c)) for c in debug_modes]
    debug_modes = zip(debug_level_names_u, debug_modes)
    args.debug_modes.update(dict(('DEBUG_'+n, v) for n, v in debug_modes))
    return args
    

