#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009-2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import print_function

__all__ = ['error', 'debug', 'debug_func', 'DEBUG_LEVEL',
            'DEBUG_FUNC', 'DEBUG_MSG', 'DEBUG_ROTATE',
            'DEBUG_DRAW', 'DEBUG_KEYS', 'DEBUG_TEST', 'DEBUG_PICK']

def error(*args, **kwargs):
    print('ERROR:', *args, **kwargs)
    
debug = lambda *args, **kwargs: None
debug_func = lambda x: x
DEBUG_LEVEL = -1
DEBUG_FUNC = DEBUG_MSG = DEBUG_ROTATE = DEBUG_DRAW = DEBUG_KEYS = DEBUG_TEST = DEBUG_PICK = False

def install(module, debug_modes):
    for m, v in debug_modes.items():
        setattr(module, m, v)
    
    if module.DEBUG_FUNC:
        def _debug_pre_func(func, *args, **kwargs):
            def short_arg(arg):
                arg = str(arg)
                maxlen = 80 - debug_func.indent * 3 - 2
                if len(arg) > maxlen:
                    return arg[:maxlen]
                return arg
            print('%s--%s' % ('  |'*debug_func.indent, func.func_name))
            debug_func.indent += 1
            for arg in args:
                try:
                    print('%s: %s' % ('  |'*debug_func.indent, short_arg(arg)))
                except:
                    pass 
            for kw, arg in kwargs:
                try:
                    print('%s: %s=%s' % ('  |'*debug_func.indent, kw, short_arg(arg)))
                except:
                    pass 
        def debug_func(func):
            def ret_func(*args, **kwargs):
                _debug_pre_func(func, *args, **kwargs)
                try:
                    return func(*args, **kwargs)
                except Exception, e:
                    if debug_func.last_exc != e:
                        print('  X'*debug_func.indent)
                        debug_func.last_exc = e
                    raise
                finally:
                    debug_func.indent -= 1
                    print('  |'*debug_func.indent + "--'")
            ret_func.__dict__ = func.__dict__
            ret_func.__doc__ = func.__doc__
            ret_func.__module__ = func.__module__
            ret_func.__name__ = func.__name__
            ret_func.func_defaults = func.func_defaults
            return ret_func
        debug_func.indent = 0
        debug_func.last_exc = None
        module.debug_func = debug_func
        
    if module.DEBUG_MSG:
        module.debug = print
        
