#!/usr/bin/env sh
#######################################################################
#                                                                     #
#       Universal build script of Psi+ under Linux                    #
#       Универсальный скрипт сборки Psi+ под Linux                    #
#                                                                     #
#######################################################################

# REQUIREMENTS / ТРЕБОВАНИЯ

# In order to build Psi+ you must have next packages in your system
# Для сборки Psi+ вам понадобятся следующие пакеты
# git - vcs system / система контроля версий
# gcc - compiler / компилятор
# qt4 tools libraries and headers (most probably "dev" packages) / qt4 тулзы либы и хидеры (наверное "dev" пакеты)
# qca/QtCrypto - encryption libs / криптовальные либы
 


# OPTIONS / НАСТРОЙКИ

# build and store directory / каталог для сорсов и сборки
PSI_DIR="${HOME}/psi"

# icons for downloads / иконки для скачивания
ICONSETS="system clients activities moods affiliations roster"

# do not update anything from repositories until required
# не обновлять ничего из репозиториев если нет необходимости
WORK_OFFLINE=${WORK_OFFLINE:-0}

# log of applying patches / лог применения патчей
PATCH_LOG="${PSI_DIR}/psipatch.log"

# skip patches which applies with errors / пропускать глючные патчи
SKIP_INVALID_PATCH="${SKIP_INVALID_PATCH:-0}"

# configure options / опции скрипта configure
CONF_OPTS="${@}"

# install root / каталог куда устанавливать (полезно для пакаджеров)
INSTALL_ROOT="${INSTALL_ROOT:-/}"

# bin directory of compiler cache util
CCACHE_BIN_DIR="${CCACHE_BIN_DIR:-/usr/lib/ccache}"

# plugins to build
PLUGINS="${PLUGINS:-}"

# checkout libpsibuild
if [ -d .svn ]; then
  . ./libpsibuild.sh
else
  echo "Checking for a new version of libpsibuild.sh.."
  scripts_repo="http://psi-dev.googlecode.com/svn/trunk/scripts/posix"
  librevraw=`svn ls -v ${scripts_repo}/libpsibuild.sh`
  librev=`echo $librevraw | cut -f 1 -d ' '`
  [ ! -f libpsibuild_r${librev}.sh ] && {
    echo "Updating libpsibuild.."
    rm libpsibuild_r*.sh 2>/dev/null
    svn cat ${scripts_repo}/libpsibuild.sh > libpsibuild_r${librev}.sh
    [ ! -f libpsibuild_r${librev}.sh ] && {
      echo "can't update libpsibuild.sh"
      exit 1
    }
  }
  . ./libpsibuild_r${librev}.sh
fi

#############
# Go Go Go! #
#############
check_env
prepare_workspace
fetch_all
prepare_all
compile_all
install_all
