/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef INPUT_H
#define INPUT_H

typedef struct input {
	// If open fails, you must call close to free the input.
	int (*open)(struct input *p, const char *fn);
	// Output format must be suitable for ao with given format
	// fmt will be valid after first call
	// Return value is bytes in buffer; 0 for EOF; -1 for error
	int (*get_audio)(struct input *p, buffer *buf);
	// Position and length are in seconds
	int (*get_pos)(struct input *p, double *pos);
	int (*get_len)(struct input *p, double *len);
	int (*get_seekable)(struct input *p);
	int (*set_pos)(struct input *p, double pos);
	int (*close)(struct input *p);
	sample_format fmt;
	float bitrate;
	void *data;
} input;

typedef input *(*input_constructor)(void);

input *input_alloc(void);

#endif
