/*
 Copyright (C) 2010 Christian Dywan <christian@twotoasts.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

[CCode (cprefix = "GLib", lower_case_cprefix = "g_")]
namespace GLib {
    [CCode (cname = "g_ascii_strdown", cheader_filename = "glib.h")]
    public static string ascii_strdown (string str, ssize_t len = -1);
    [CCode (cname = "g_base64_encode", cheader_filename = "glib.h")]
        public static string base64_encode (string data, size_t length);
    }

[CCode (cprefix = "Gdk", lower_case_cprefix = "gdk_")]
namespace Gdk {
    [CCode (cname = "gdk_pixbuf_save_to_buffer", cheader_filename = "gdk-pixbuf/gdk-pixdata.h")]
        public static bool pixbuf_save_to_buffer (Gdk.Pixbuf pixbuf, out string buffer,
                                                  out size_t buffer_size, string type,
                                                  void* a, void* b) throws GLib.Error;
    [CCode (cname = "gdk_rectangle_intersect", cheader_filename = "gdk/gdk.h")]
    public static bool rectangle_intersect (Gdk.Rectangle src1, Gdk.Rectangle src2,
                                            out Gdk.Rectangle dest);
    }

