dnl Copyright (c) 2002  Leon Bottou and Yann Le Cun.
dnl Copyright (c) 2001  AT&T
dnl
dnl Most of these macros are derived from macros listed
dnl at the GNU Autoconf Macro Archive
dnl http://www.gnu.org/software/ac-archive/
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA02111 USA
dnl

dnl -------------------------------------------------------
dnl @synopsis AC_CHECK_CXX_OPT(OPTION,
dnl               ACTION-IF-OKAY,ACTION-IF-NOT-OKAY)
dnl Check if compiler accepts option OPTION.
dnl -------------------------------------------------------
AC_DEFUN(AC_CHECK_CXX_OPT,[
 opt="$1"
 AC_MSG_CHECKING([if $CXX accepts $opt])
 echo 'void f(){}' > conftest.cc
 if test -z "`${CXX} ${CXXFLAGS} ${OPTS} $opt -c conftest.cc 2>&1`"; then
    AC_MSG_RESULT(yes)
    rm conftest.* 
    $2
 else
    AC_MSG_RESULT(no)
    rm conftest.*
    $3
 fi
])

dnl -------------------------------------------------------
dnl @synopsis AC_CXX_OPTIMIZE
dnl Setup option --enable-debug
dnl Collects optimization/debug option in variable OPTS
dnl Filter options from CFLAGS and CXXFLAGS
dnl -------------------------------------------------------
AC_DEFUN(AC_CXX_OPTIMIZE,[
   AC_REQUIRE([AC_CANONICAL_HOST])
   AC_ARG_ENABLE(debug,
        AC_HELP_STRING([--enable-debug],
                       [Compile with debugging options (default: no)]),
        [ac_debug=$enableval],[ac_debug=no])
   OPTS=
   AC_SUBST(OPTS)
   saved_CXXFLAGS="$CXXFLAGS"
   saved_CFLAGS="$CFLAGS"
   CXXFLAGS=
   CFLAGS=
   for opt in $saved_CXXFLAGS ; do
     case $opt in
       -g*) test $ac_debug != no && OPTS="$OPTS $opt" ;;
       -O*) ;;
       *) CXXFLAGS="$CXXFLAGS $opt" ;;
     esac
   done
   for opt in $saved_CFLAGS ; do
     case $opt in
       -O*|-g*) ;;
       *) CFLAGS="$CFLAGS $opt" ;;
     esac
   done
   if test x$ac_debug = xno ; then
     OPTS=-DNDEBUG
     AC_CHECK_CXX_OPT([-Wall],[OPTS="$OPTS -Wall"])
     AC_CHECK_CXX_OPT([-O3],[OPTS="$OPTS -O3"],
        [ AC_CHECK_CXX_OPT([-O2], [OPTS="$OPTS -O2"] ) ] )
     dnl This triggers compiler bugs with gcc-3.2.2
     dnl AC_CHECK_CXX_OPT([-funroll-loops], [OPTS="$OPTS -funroll-loops"])
     cpu=`uname -m 2>/dev/null`
     test -z "$cpu" && cpu=${host_cpu}
     case "${host_cpu}" in
        i?86)
           opt="-mcpu=${host_cpu}"
           AC_CHECK_CXX_OPT([$opt], [OPTS="$OPTS $opt"])
           ;;
      esac
   else
     AC_CHECK_CXX_OPT([-Wall],[OPTS="$OPTS -Wall"])
   fi
   case x"$ac_debug" in
changequote(<<, >>)dnl
     x[0-9])  OPTS="$OPTS -DDEBUGLVL=$ac_debug" ;;
     xr*)   OPTS="$OPTS -DRUNTIME_DEBUG_ONLY" ;;
changequote([, ])dnl 
   esac
])

dnl -------------------------------------------------------
dnl @synopsis AC_CXX_TYPENAME
dnl Define HAVE_TYPENAME if the compiler recognizes 
dnl keyword typename.
dnl -------------------------------------------------------
AC_DEFUN([AC_CXX_TYPENAME],
[AC_CACHE_CHECK(whether the compiler recognizes typename,
ac_cv_cxx_typename,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE([template<typename T>class X {public:X(){}};],
[X<float> z; return 0;],
 ac_cv_cxx_typename=yes, ac_cv_cxx_typename=no)
 AC_LANG_RESTORE
])
if test "$ac_cv_cxx_typename" = yes; then
  AC_DEFINE(HAVE_TYPENAME,1,[define if the compiler recognizes typename])
fi
])


dnl -------------------------------------------------------
dnl @synopsis AC_CXX_STDINCLUDES
dnl Define HAVE_STDINCLUDES if the compiler has the
dnl new style include files (without the .h)
dnl -------------------------------------------------------
AC_DEFUN([AC_CXX_STDINCLUDES],
[AC_CACHE_CHECK(whether the compiler comes with standard includes,
ac_cv_cxx_stdincludes,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE([#include <new>
struct X { int a; X(int a):a(a){}; };
X* foo(void *x) { return new(x) X(2); } ],[],
 ac_cv_cxx_stdincludes=yes, ac_cv_cxx_stdincludes=no)
 AC_LANG_RESTORE
])
if test "$ac_cv_cxx_stdincludes" = yes; then
  AC_DEFINE(HAVE_STDINCLUDES,1,
    [define if the compiler comes with standard includes])
fi
])


dnl -------------------------------------------------------
dnl @synopsis AC_CXX_BOOL
dnl If the compiler recognizes bool as a separate built-in type,
dnl define HAVE_BOOL. Note that a typedef is not a separate
dnl type since you cannot overload a function such that it 
dnl accepts either the basic type or the typedef.
dnl -------------------------------------------------------
AC_DEFUN([AC_CXX_BOOL],
[AC_CACHE_CHECK(whether the compiler recognizes bool as a built-in type,
ac_cv_cxx_bool,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE([
int f(int  x){return 1;}
int f(char x){return 1;}
int f(bool x){return 1;}
],[bool b = true; return f(b);],
 ac_cv_cxx_bool=yes, ac_cv_cxx_bool=no)
 AC_LANG_RESTORE
])
if test "$ac_cv_cxx_bool" = yes; then
  AC_DEFINE(HAVE_BOOL,1,[define if bool is a built-in type])
fi
])

dnl ------------------------------------------------------------------
dnl @synopsis AC_PATH_QT([ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]])
dnl Process option --with-qt=DIR
dnl Define HAVE_QT and set it to QT_VERSION
dnl Set output variables MOC, UIC, QT_LIBS and QT_CFLAGS.
dnl ------------------------------------------------------------------

AC_DEFUN([AC_PATH_QT],
[
  AC_REQUIRE([AC_PATH_X])
  AC_REQUIRE([AC_PATH_XTRA])
  if test ${no_x-no} != yes ; then
    X_LIBS="$X_LIBS $X_PRE_LIBS -lXext -lX11 $X_EXTRA_LIBS"
  fi
  # Variables
  AC_ARG_VAR(QTDIR,[Location of the Qt package.])
  AC_ARG_VAR(QT_CFLAGS,[Flags for compiling Qt programs.])
  AC_ARG_VAR(QT_LIBS,[Flags for linking Qt programs.])
  AC_ARG_VAR(MOC,[Location of the MOC program.])
  AC_ARG_VAR(UIC,[Location of the UIC program.])
  # Arguments
  AC_ARG_WITH(qt, 
      AC_HELP_STRING([--with-qt=DIR],
                     [where the Qt root is installed.]),
      [ test x$withval != xyes && QTDIR=$withval ])
  test x$no_x = xyes && QTDIR=no
  # Check for the lib64 thing
  lib=`basename "$libdir"`
  case "$lib" in lib*) ;; *) lib="lib" ;; esac
  if test $lib = "lib" ; then libs="lib" ; else libs="$lib lib" ; fi
  # Standard qt directory
  ac_has_qt=no
  if test x$QTDIR != xno ; then
    AC_MSG_CHECKING([for Qt root directory])
    ac_has_qt=no
    ac_userdef_qt=no
    if test x${QT_CFLAGS+set} = xset || test x${QT_LIBS+set} = xset ; then
       ac_userdef_qt=yes
       ac_has_qt="user defined QT_CFLAGS and QT_LIBS" # no questions asked
    else
       ac_qt_dirs="/usr/local /usr/X11R6 /usr"
       for lib in $libs ; do 
         for n in /usr/$lib/qt* ; do
           test -d $n && ac_qt_dirs="$n $ac_qt_dirs" ; 
         done
       done
       if test -d "$QTDIR" ; then 
         ac_qt_dirs="$QTDIR $ac_qt_dirs"
       fi
       for dir in $ac_qt_dirs ; do
          if test -r $dir/include/qwidget.h ; then
            ac_has_qt=$dir
            QTDIR=$dir
            break
          fi
       done
    fi
    # Unusual install
    if test "x$ac_has_qt" = xno ; then
      ac_qt_names="qt3 qt2 qt"
      ac_qt_dirs="/usr /usr/X11R6 /usr/local"
      case "$host" in
      *-darwin* | *-macos10*)
        if test -d /opt/local ; then
          ac_qt_dirs="/opt/local $ac_qt_dirs"
        elif test -d /sw ; then
          ac_qt_dirs="/sw $ac_qt_dirs"
	fi
      ;;
      esac
      ac_qt_dirs="$QTDIR $prefix $ac_qt_dirs"
      for d in $ac_qt_dirs ; do
        for n in $ac_qt_names ; do
          if test -r $d/include/$n/qwidget.h ; then
            for lib in $libs ; do
              for l in lib$n.so lib$n-mt.so lib$n-mt.dylib lib$n.a lib$n-mt.a ; do
                  if test -r $d/$lib/$l ; then
                      QT_CFLAGS="-I$d/include/$n"
                      QT_LIBS="-L$d/$lib -l$n"
                      QTDIR=$d
                      ac_has_qt="bsd-style Qt install"
                      break 3
                  fi
              done
              for l in libqt.so libqt-mt.so libqt-mt.dylib libqt.a libqt-mt.a; do
                  if test -r $d/$lib/$l ; then
                      QT_CFLAGS="-I$d/include/$n"
                      QT_LIBS="-L$d/$lib -lqt"
                      QTDIR=$d
                      ac_has_qt="debian-style Qt install"
                      break 3
                  fi
              done
            done
          fi
        done
      done
    fi
    # Print result
    AC_MSG_RESULT($ac_has_qt)
  fi
  # Programs
  if test "x$ac_has_qt" != xno ; then
    if test "x$ac_userdef_qt" != xyes ; then
        if test x${QT_CFLAGS+set} != xset ; then
           QT_CFLAGS="-I$QTDIR/include"
        fi
        if test x${QT_LIBS+set} != xset ; then
           if test -d $QTDIR/$lib ; then
             QT_LIBS="-L$QTDIR/$lib -lqt"
           else
             QT_LIBS="-L$QTDIR/lib -lqt"
           fi
        fi
        # KDE-3.0 styles require qt-mt even in non KDE applications. 
        # Bero dixit. See kde bug #40823.
        qt_libdir=
        qt_libname=
        AC_MSG_CHECKING([for multithreaded Qt3 library])
        for n in `echo $QT_LIBS` ; do case $n in
           -L*) qt_libdir=`echo "$n" | sed -e 's:^-L::'` ;;
           -l*) qt_libname=`echo "$n" | sed -e 's:^-l::'` ;;
          esac
        done
        ac_has_qt_mt=no
        for n in ${qt_libdir}/lib${qt_libname}-mt.so \
	         ${qt_libdir}/lib${qt_libname}-mt.dylib \
		 ${qt_libdir}/lib${qt_libname}-mt.dll.a; do
          if test -r $n ; then
            ac_has_qt_mt=yes
          fi
        done
        AC_MSG_RESULT($ac_has_qt_mt)
        if test $ac_has_qt_mt = yes ; then
          newqtlibs=
          for n in `echo $QT_LIBS` ; do 
            test "$n" = "-l$qt_libname"  &&  n="$n-mt"
            newqtlibs="$newqtlibs $n"
          done
          QT_LIBS="$newqtlibs"
        fi
    fi
    AC_PATH_PROGS(MOC, [moc moc3 moc2], [:], [$QTDIR/bin $PATH])
    AC_PATH_PROGS(UIC, [uic uic3 uic2], [:], [$QTDIR/bin $PATH])
    AC_PATH_PROGS(LUPDATE, [lupdate],   [:], [$QTDIR/bin $PATH])
    AC_PATH_PROGS(LRELEASE,[lrelease],  [:], [$QTDIR/bin $PATH])
    if test -x "$MOC" ; then : ; else 
        AC_MSG_WARN([Cannot locate the Qt Meta-Object compiler.])
        ac_has_qt=no
        QTDIR=no
    fi
  fi
  # Execute
  if test "x$ac_has_qt" != xno ; then
    AC_MSG_CHECKING([if a small Qt program runs])
    AC_LANG_PUSH(C++)
    save_CXXFLAGS="$CXXFLAGS"
    save_LIBS="$LIBS"
    CXXFLAGS="$CXXFLAGS $CFLAGS $THREAD_CFLAGS $QT_CFLAGS $X_CFLAGS"
    LIBS="$THREAD_LIBS $QT_LIBS $X_LIBS $LIBS"
    AC_TRY_RUN([
#include <qfile.h>
#include <qtextstream.h>
#include <qglobal.h>
int main() { 
QFile qf("confout"); if (!qf.open(IO_WriteOnly)) return 1;
QTextStream ts(&qf); ts << QT_VERSION; return 0;
}],[okay=yes],[okay=no; QTDIR=no]) 
    CXXFLAGS="$save_CXXFLAGS"
    LIBS="$save_LIBS"
    AC_LANG_POP(C++)
    AC_MSG_RESULT($okay)
    if test "x$okay" = xno ; then
      ac_has_qt=no
    fi
  fi
  # Version
  if test "x$ac_has_qt" != xno ; then
     AC_MSG_CHECKING([Qt version])
     qt_version=`cat < confout`
     AC_MSG_RESULT($qt_version)
     AC_DEFINE_UNQUOTED(HAVE_QT,$qt_version,
                        [Define to Qt version if available])
     rm confout 2>/dev/null
  fi
  # Execute
  if test "x$ac_has_qt" = xno ; then
    QT_CFLAGS= ; QT_LIBS= ; QTDIR= ; MOC=moc ;
    ifelse([$2],,:,[$2])        
  else
    AC_MSG_RESULT([setting QT_CFLAGS=$QT_CFLAGS])
    AC_MSG_RESULT([setting QT_LIBS=$QT_LIBS])
    ifelse([$1],,:,[$1])        
  fi
])

dnl Checks for Xft/XRender
AC_DEFUN([AC_HAVE_XRENDER],
[
	have_render=false
	RENDER_LIBS=""
	AC_CHECK_LIB(Xrender, XRenderFindFormat, 
		have_render=true)
	if $have_render ; then
		RENDER_LIBS="-lXrender -lXext"
		AC_DEFINE(HAVE_XRENDER, [], [Define to 1 if Xrender is available])
	fi
])

dnl check if the assembler supports SSE instructions
AC_DEFUN([AC_CHECK_X86_SSE],
[
AC_MSG_CHECKING([for x86 SSE instructions])
AC_CACHE_VAL(ac_cv_x86_sse,
[
AC_TRY_COMPILE(,
[
#if defined(__GNUC__) && defined(__i386__)
__asm__("movups %xmm0, (%esp)");
#else
#error Not gcc on x86
#endif
],
ac_cv_x86_sse=yes,
ac_cv_x86_sse=no)
])
AC_MSG_RESULT($ac_cv_x86_sse)
if test "x$ac_cv_x86_sse" = "xyes"; then
	AC_DEFINE(HAVE_X86_SSE,1,
		[Defined to 1 if assembler supports x86 SSE instructions])
fi
])
