/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file message_box.hpp
 * \brief This frame displays a message.
 * \author Julien Jorge
 */
#ifndef __PTB_MESSAGE_BOX_HPP__
#define __PTB_MESSAGE_BOX_HPP__

#include "ptb/frame/frame.hpp"
#include "ptb/frame/button.hpp"
#include "gui/picture.hpp"
#include "gui/static_text.hpp"

#include <string>

namespace ptb
{
  /**
   * \brief This frame displays a message.
   * \author Julien Jorge
   */
  class message_box:
    public frame
  {
  public:
    typedef unsigned int flags;

  private:
    typedef button< bear::gui::static_text, std::mem_fun_t<bool, message_box> >
    button_with_text;

  public:
    message_box( windows_layer* in_layer, const std::string& msg,
                 flags* buttons = NULL );

  private:
    bool on_key_press( const bear::input::key_info& key );
    bool on_button_press
    ( bear::input::joystick::joy_code button, unsigned int joy_index );
    bool on_mouse_move( const claw::math::coordinate_2d<unsigned int>& pos );

    bool on_ok();
    bool on_cancel();
    bool on_left();
    bool on_right();

    void position_cursor();

    void create_controls( const std::string& msg_key );
    void create_text
    ( const std::string& msg, bear::gui::static_text::font_type f );
    void create_buttons( bear::gui::static_text::font_type f );
    void position_buttons();

  public:
    /** \brief Flag of the 'ok' button. */
    static const flags s_ok;

    /** \brief Flag of the 'cancel' button. */
    static const flags s_cancel;

  private:
    /** \brief The flags of the selected buttons. Serves also as result. */
    flags* m_flags;

    /** \brief Displayed text */
    bear::gui::static_text* m_text;

    /** \brief The cursor to select 'ok' or 'cancel'. */
    bear::gui::picture* m_cursor;

    /** \brief The position of the cursor. */
    unsigned int m_cursor_position;

    /** \brief The buttons. */
    std::vector<button_with_text*> m_button;

    /** \brief The margin between the controls. */
    const unsigned int m_margin;

  }; // class message_box
} // namespace ptb

#endif // __PTB_MESSAGE_BOX_HPP__
