/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file menu_frame.cpp
 * \brief Implementation of the ptb::menu_frame class.
 * \author Julien Jorge
 */
#include "ptb/frame/menu_frame.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owning_layer The layer onwing the window.
 */
ptb::menu_frame::menu_frame( windows_layer* owning_layer )
  : frame(owning_layer),
    m_menu(new menu(&get_frame(), get_cursor(), get_font(), 10, 10, 5))
{

} // menu_frame::menu_frame()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell that a key has been pressed.
 * \param key The code of the key.
 */
bool ptb::menu_frame::on_key_press( const bear::input::key_info& key )
{
  bool result = true;

  if ( key.is_enter() )
    validate();
  else
    result = false;

  return result;
} // menu_frame::on_key_press()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell that a joystick button has been pressed.
 * \param button The code of the button.
 * \param joy_index The index of the joytick.
 */
bool ptb::menu_frame::on_button_press
( bear::input::joystick::joy_code button, unsigned int joy_index )
{
  bool result = true;

  switch( button )
    {
    case bear::input::joystick::jc_button_1 :
    case bear::input::joystick::jc_button_2 :
    case bear::input::joystick::jc_button_3 :
    case bear::input::joystick::jc_button_4 :
    case bear::input::joystick::jc_button_5 :
    case bear::input::joystick::jc_button_6 :
    case bear::input::joystick::jc_button_7 :
    case bear::input::joystick::jc_button_8 :
    case bear::input::joystick::jc_button_9 :
    case bear::input::joystick::jc_button_10 :
    case bear::input::joystick::jc_button_11 :
    case bear::input::joystick::jc_button_12 :
    case bear::input::joystick::jc_button_13 :
    case bear::input::joystick::jc_button_14 :
    case bear::input::joystick::jc_button_15 :
    case bear::input::joystick::jc_button_16 :
      validate();
      break;
    default:
      result = false;
    }

  return result;
} // menu_frame::on_button_press()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell that a mouse button has been pressed.
 * \param pos The current position of the cursor.
 * \param key The code of the key.
 */
bool ptb::menu_frame::on_mouse_press
( bear::input::mouse::mouse_code key,
  const claw::math::coordinate_2d<unsigned int>& pos )
{
  bool result = true;

  switch( key )
    {
    case bear::input::mouse::mc_left_button :
    case bear::input::mouse::mc_middle_button :
    case bear::input::mouse::mc_right_button :
      validate();
      break;
    default:
      result = false;
    }

  return result;
} // menu_frame::on_key_press()

/*----------------------------------------------------------------------------*/
/**
 * \brief Validate the selected action.
 */
void ptb::menu_frame::validate() const
{

} // menu_frame::validate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the menu contained by this frame.
 */
ptb::menu& ptb::menu_frame::get_menu()
{
  return *m_menu;
} // menu_frame::create_controls()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the menu contained by this frame.
 */
const ptb::menu& ptb::menu_frame::get_menu() const
{
  return *m_menu;
} // menu_frame::create_controls()

