/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file menu.cpp
 * \brief Implementation of the ptb::menu class.
 * \author Julien Jorge
 */
#include "ptb/frame/menu.hpp"

#include "engine/game.hpp"
#include "ptb/frame/frame.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owner The component owning this menu.
 * \param cursor The cursor next to the selected item.
 * \param f The font used to display the text.
 * \param horizontal_margins The size of the margins on the left and on the
 *        right.
 * \param vertical_margins The size of the margins at the top and at the bottom.
 * \param line_space The size of the line space.
 */
ptb::menu::menu
( bear::gui::visual_component* owner, const bear::visual::sprite& cursor,
  const bear::visual::font& f, unsigned int horizontal_margins,
  unsigned int vertical_margins, unsigned int line_space )
  : bear::gui::menu( owner, new bear::visual::sprite(cursor), f,
                     horizontal_margins, vertical_margins, line_space )
{
  set_size( owner->get_size() );
} // menu::menu()

/*----------------------------------------------------------------------------*/
/**
 * \brief Add items from a list of strings and call auto_size().
 * \param strings The names of the strings to add, from the language file.
 * \pre The last item in strings is NULL.
 */
void ptb::menu::make( const char* strings[] )
{
  for (unsigned int i=0; strings[i]!=NULL; ++i)
    add_string(strings[i]);

  auto_size();
} // menu::make()

/*----------------------------------------------------------------------------*/
/**
 * \brief Add items from a list of strings and call auto_size().
 * \param strings The names of the strings to add, from the language file.
 */
void ptb::menu::make( const std::vector<std::string>& strings )
{
  for (unsigned int i=0; i!=strings.size(); ++i)
    add_string(strings[i]);

  auto_size();
} // menu::make()

/*----------------------------------------------------------------------------*/
/**
 * \brief Add an item.
 * \param str The string to add.
 */
void ptb::menu::add_string( const std::string& str )
{
  bear::gui::static_text& static_text = add();

  static_text.set_auto_size(true);
  static_text.set_text( str );
} // menu::add_string()
