;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../../common.scm")

(define idle-gorilla
  (lambda (dest_image)

    (let ( (idle_name "idle.xcf.bz2") )
      (let ( (idle_image (car (gimp-file-load 1 idle_name idle_name)))
             )

        ; layer names
        (let ( (mouth_3   0)
               (mouth_2   1)
               (mouth_1   2)
               (right_arm 3)
               (right_leg 4)
               (left_foot 5)
               (body      6)
               (grass     7)
               (face      8)
               (left_leg  9) )

          (create-layer idle_image
                        (list grass
                         right_arm right_leg left_foot body face left_leg)
                        0 0 113 103 dest_image)
          (create-layer idle_image
                        (list mouth_1
                         right_arm right_leg left_foot body face left_leg)
                        113 0 113 103 dest_image)
          (create-layer idle_image
                        (list mouth_2
                         right_arm right_leg left_foot body face left_leg)
                        226 0 113 103 dest_image)
          (create-layer idle_image
                        (list mouth_3
                         right_arm right_leg left_foot body face left_leg)
                        339 0 113 103 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define idle-gorilla

(let ( (dest_name "idle.png") )
  (let ( (dest_image (car (gimp-image-new 512 128 RGB))) )
    (let ( (bk (car (gimp-layer-new dest_image 512 128 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (idle-gorilla dest_image);

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
