/*
    Bear Engine - Model editor

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/mark_properties_frame.hpp
 * \brief The window showing the properties of a mark.
 * \author Sbastien Angibaud
 */
#ifndef __BF_MARK_PROPERTIES_FRAME_HPP__
#define __BF_MARK_PROPERTIES_FRAME_HPP__

#include <wx/wx.h>
#include <wx/textctrl.h>

#include "bf/mark.hpp"

namespace bf
{
  class action;
  class animation_file_edit;

  /**
   * \brief The mark_properties window of our program.
   * \author Sbastien Angibaud
   */
  class mark_properties_frame:
    public wxDialog
  {
  public:
    mark_properties_frame( wxWindow* parent, const action* a );

    const std::string& get_mark_name() const;
    const bf::animation_file_type& get_mark_animation() const;
    bool apply_angle_to_animation() const;

    void fill_from( const mark& a );

  private:
    void fill_controls();

    void create_controls();
    void create_member_controls();
    void create_sizer_controls();
    
    void on_ok(wxCommandEvent& event);

  private:
    /** \brief The current action. */
    const action* m_action;

    /** \brief The label of the mark. */
    std::string m_mark_label;

    /** \brief The animation file of the mark. */
    bf::animation_file_type m_mark_animation;

    /** \brief Tell if the angle applied to the mark is also applied to the
        animation. */
    bool m_apply_angle_to_animation;

    /** \brief The text control in which we configure the label of the mark. */
    wxTextCtrl* m_mark_label_box;

    /** \brief The control in which we configure the animation. */
    animation_file_edit* m_animation_ctrl;

    /** \brief The button control to check the angle application statut. */
    wxCheckBox* m_apply_angle_box;

    DECLARE_EVENT_TABLE()

  }; // class mark_properties_frame
} // namespace bf

#endif // __BF_MARK_PROPERTIES_FRAME_HPP__
