/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file binary_boolean_expression.hpp
 * \brief A logical and of two boolean expressions.
 * \author Julien Jorge
 */
#ifndef __ENGINE_BINARY_BOOLEAN_EXPRESSION_HPP__
#define __ENGINE_BINARY_BOOLEAN_EXPRESSION_HPP__

#include "engine/expr/base_boolean_expression.hpp"
#include "engine/expr/boolean_expression.hpp"

#include <functional>

namespace bear
{
  namespace engine
  {
    /**
     * \brief A boolean expression with two operands.
     * \author Julien Jorge
     */
    template<typename F>
    class ENGINE_EXPORT binary_boolean_expression:
      public base_boolean_expression
    {
    public:
      /** \brief The type of the operands. */
      typedef boolean_expression operand_type;

    public:
      binary_boolean_expression();
      binary_boolean_expression
      ( const boolean_expression& left, const boolean_expression& right );

      const boolean_expression& get_left_operand() const;
      void set_left_operand( const boolean_expression& op );

      const boolean_expression& get_right_operand() const;
      void set_right_operand( const boolean_expression& op );

      base_boolean_expression* clone() const;
      bool evaluate() const;

    private:
      /** \brief The left operand. */
      boolean_expression m_left;

      /** \brief The right operand. */
      boolean_expression m_right;

    }; // class binary_boolean_expression

    typedef binary_boolean_expression< std::equal_to<bool> > boolean_equality;
    typedef
    binary_boolean_expression< std::not_equal_to<bool> > boolean_disequality;
    typedef binary_boolean_expression< std::logical_and<bool> > logical_and;
    typedef binary_boolean_expression< std::logical_or<bool> > logical_or;

  } // namespace engine
} // namespace bear

#include "engine/expr/impl/binary_boolean_expression.tpp"

#endif // __ENGINE_BINARY_BOOLEAN_EXPRESSION_HPP__
