
/*****************************************************************************/
/*                                                                           */
/*  Fichero:     nd2.h                                                       */
/*  Autor:       Javier Minguez                                              */
/*  Creado:      28/05/2003                                                  */
/*  Modificado:  21/06/2003                                                  */
/*                                                                           */
/*****************************************************************************/

#ifndef nd2_h
#define nd2_h

#include "geometria.h"

// ----------------------------------------------------------------------------
// CONSTANTES.
// ----------------------------------------------------------------------------

// Nmero de sectores: mltiplo de 4.
#define SECTORES 180

#define VERDADERO 1
#define FALSO 0
#define NO_SIGNIFICATIVO -1

// ----------------------------------------------------------------------------
// TIPOS.
// ----------------------------------------------------------------------------

// Informacin acerca del robot.

// Dimensiones del robot.
//   Consideramos el robot definido por un rectngulo. Numeramos sus
//   dimensiones, medidas a partir de su centro en las direcciones principales,
//   siguiendo la misma convencin que para los sectores:
//     Dimension[0]: distancia desde el centro a la trasera del robot.
//     Dimension[1]: distancia desde el centro a la izquierda del robot.
//     Dimension[2]: distancia desde el centro al frontal del robot.
//     Dimension[3]: distancia desde el centro a la derecha del robot.
typedef float TDimensiones[4];

typedef float TMatriz2x2[2][2];

typedef struct {

  TDimensiones Dimensiones;
  float enlarge;

  short int geometriaRect; // Si es cuadrado o no

  float R; // radio del robot por si es circular

  short int holonomo;

  float E[SECTORES]; // Distancia desde el origen de SR2 al permetro del robot.
  float ds[SECTORES];  // Distancia de seguridad: desde el permetro del robot al permetro de seguridad.

  float velocidad_lineal_maxima;
  float velocidad_angular_maxima;

  float aceleracion_lineal_maxima;
  float aceleracion_angular_maxima;

  float discontinuidad; // Espacio mnimo por el que cabe el robot.

  float T; // Perodo.

  TMatriz2x2 H; // Generador de movimientos: "Inercia" del robot.
  TMatriz2x2 G; // Generador de movimientos: "Fuerza" aplicada sobre el robot.

} TInfoRobot;

// Informacin acerca del objetivo.

typedef struct {
  TCoordenadas c0;
  TCoordenadas c1;
  TCoordenadasPolares p1;
  int s; // Sector.
} TObjetivo;

// Informacin acerca de la regin escogida.

#define DIRECCION_OBJETIVO                0
#define DIRECCION_DISCONTINUIDAD_INICIAL  1
#define DIRECCION_DISCONTINUIDAD_FINAL    2

typedef struct {
  int principio;
  int final;

  int principio_ascendente;
  int final_ascendente;

  int descartada;

  int direccion_tipo;
  int direccion_sector;
  float direccion_angulo;
} TRegion;

typedef struct {
  int longitud;
  TRegion vector[SECTORES];
} TVRegiones;

// Informacin interna del mtodo de navegacin.

typedef struct {

  TObjetivo objetivo;

  TSR SR1;                  // Estado actual del robot: posicin y orientacin.
  TVelocities velocidades; // Estado actual del robot: velocidades lineal y angular.

  TCoordenadasPolares d[SECTORES]; // Distancia desde el centro del robot al obstculo ms prximo en cada sector (con ngulos).
  float dr[SECTORES]; // Distancia desde el permetro del robot al obstculo ms prximo en cada sector.

  TVRegiones regiones; // Slo como informacin de cara al exterior: Lista de todas las regiones encontradas en el proceso de seleccin.
  int region;          // Como almacenamos ms de una regin debemos indicar cul es la escogida.

  int obstaculo_izquierda,obstaculo_derecha;

  float angulosin;    // Slo como informacin de cara al exterior: ngulo antes de tener en cuenta los obstculos ms prximos.
  float angulocon;    // Slo como informacin de cara al exterior: ngulo despus de tener en cuenta los obstculos ms prximos.
  char situacion[20]; // Slo como informacin de cara al exterior: Situacin en la que se encuentra el robot.
  char cutting[20];   // Slo como informacin de cara al exterior: Cutting aplicado al movimiento del robot.

  float angulo;    // Salida del algoritmo de navegacin y entrada al generador de movimientos: direccin de movimiento deseada.
  float velocidad; // Salida del algoritmo de navegacin y entrada al generador de movimientos: velocidad lineal deseada.

} TInfoND;

// ----------------------------------------------------------------------------
// VARIABLES.
// ----------------------------------------------------------------------------

extern TInfoRobot robot;

// ----------------------------------------------------------------------------
// FUNCIONES.
// ----------------------------------------------------------------------------

extern float sector2angulo(int sector);

extern int angulo2sector(float angulo);


#endif 
