/*

Copyright (C) 2000  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* viewer.c by Paul Wilkins 1/2/2000 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <Imlib.h>

int
main(int argc, char **argv)
{
   Display *disp;
   ImlibData *id;
   XSetWindowAttributes attr;
   Window win;
   ImlibImage *im;
   Pixmap p, m;
   int w, h;

   /* Be nice and tell the user if they don't, to provide a file as an arg */
   if (argc <= 1) {
      printf("Usage:\n %s image_file\n", argv[0]);
      exit(1);
   }

   /* Connect to the default Xserver */
   disp = XOpenDisplay(NULL);

   /* Immediately afterwards Intitialise Imlib */
   id = Imlib_init(disp);

   /* Load the image specified as the first argument */
   im = Imlib_load_image(id, argv[1]);

   /* Suck the image's original width and height out of the Image structure */
   w = im->rgb_width;
   h = im->rgb_height;

   /* Create a Window to display in */
   win = XCreateWindow(disp, DefaultRootWindow(disp), 0, 0, w, h, 0, id->x.depth,
      InputOutput, id->x.visual, 0, &attr);
   XSelectInput(disp, win, StructureNotifyMask);

   /* Render the original 24-bit Image data into a pixmap of size w * h */
   Imlib_render(id, im, w, h);

   /* Extract the Image and mask pixmaps from the Image */
   p = Imlib_move_image(id, im);

   /* The mask will be 0 if the image has no transparency */
   m = Imlib_move_mask(id, im);

   /* Put the Image pixmap in the background of the window */
   XSetWindowBackgroundPixmap(disp, win, p);

   /* If there was a mask to the image, set the Image's mask to it */
   if (m)
      XShapeCombineMask(disp, win, ShapeBounding, 0, 0, m, ShapeSet);

   /* Actually display the window */
   XMapWindow(disp, win);
   /* Synchronise with the Xserver */
   XSync(disp, False);

   /* Event loop to handle resizes */
   for (;;) {
      XEvent ev;

      /* Sit and wait for an event to happen */
      XNextEvent(disp, &ev);

      if (ev.type == ConfigureNotify) {
	 w = ev.xconfigure.width;
	 h = ev.xconfigure.height;

	 /* Re-render the Image to the new size */
	 Imlib_render(id, im, w, h);

	 /* Free the previous pixmap used for the window - note ONLY the
	    pixmap is */
	 /* freed - the mask is marked automatically to be freed along with
	    the */
	 /* pixmap. There is no need to free it as well - in fact it is
	    advised you do */
	 /* not. You must use the Imlib free function because of Imlib's
	    caching. Do */
	 /* not use any other free functions. You can use this function for
	    Pixmaps */
	 /* not created by Imlib - and it will just go free them as expected. 
	  */
	 Imlib_free_pixmap(id, p);
	 p = Imlib_move_image(id, im);

	 /* The mask will be 0 if the image has no transparency */
	 m = Imlib_move_mask(id, im);

	 /* Put the Image pixmap in the background of the window */
	 XSetWindowBackgroundPixmap(disp, win, p);

	 /* If there was a mask to the image, set the Image's mask to it */
	 if (m)
	    XShapeCombineMask(disp, win, ShapeBounding, 0, 0, m, ShapeSet);

	 /* Clear the window to update the background change */
	 XClearWindow(disp, win);

	 /* Synchronise with the Xserver */
	 XSync(disp, False);
      }
   }
}
