/* OpenVAS Client
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _OPENVAS_OPENVAS_PLUGIN
#define _OPENVAS_OPENVAS_PLUGIN

#include <openvas/base/nvti.h> /* for nvti_t */

/**
 * @brief Basic openvas_plugin struct, describing a NVT and maybe preferences
 * @brief in their user-modified state.
 * 
 * Implements a single-linked list (through a 'next' pointer).
 */
struct openvas_plugin {
  nvti_t * ni;
	char * oid;
	char * md5sum;
	
	char * category;

	struct arglist * plugin_prefs;

	struct openvas_plugin * next;
	int enabled:1;
	int is_current:1;    /**< Used for the cache */
};



struct openvas_plugin * openvas_plugin_new(char * id, char * name, char * category, char * copyright, char * description, char * summary, char * family, char * version, char * cve, char * bid, char * xrefs, char* sign_key_ids, char* script_tags);

struct openvas_plugin * openvas_plugin_get_by_name( struct openvas_plugin * plugins, char * name);
struct openvas_plugin * openvas_plugin_get_by_oid( struct openvas_plugin * plugins, const char * id);

void openvas_plugin_set_md5sum(struct openvas_plugin * plugin, const char * md5sum);

struct openvas_plugin* openvas_plugin_duplicate(struct openvas_plugin *);

int openvas_plugin_list_length (struct openvas_plugin*);

#endif /* _OPENVAS_OPENVAS_PLUGIN */
