#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

try :
    myCache = FunctionCache (10)
    myCache.enable()

    point1 = NumericalPoint(2)
    point1[0]=1
    point1[1]=-1

    value1 = NumericalPoint (1)
    value1[0]=2

    myCache.add( point1, value1 )

    point2 = NumericalPoint(2)
    point2[0]=2
    point2[1]=-2

    value2 = NumericalPoint(1)
    value2[0]=4

    myCache.add( point2, value2 )

    inputCacheSample = myCache.getInputNumericalSample()
    print "input cache sample =", inputCacheSample

    outputCacheSample = myCache.getOutputNumericalSample()
    print "output cache sample =", outputCacheSample

    newInput = NumericalPoint (2)
    newInput[0] = 9.0
    newInput[1] = 8.0

    newOutput = NumericalPoint (1)
    newOutput[0] = 7.0

    inputCacheSample.add( newInput )
    outputCacheSample.add( newOutput )

    myCache.importFromNumericalSample(inputCacheSample, outputCacheSample)

    print "input cache from imported sample =", myCache.getInputNumericalSample()
    print "output cache from imported sample =", myCache.getOutputNumericalSample()

except :
    import sys
    print "t_Wilks_std.py", sys.exc_type, sys.exc_value
