// SWIG file model_copula_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-06 12:03:57 +0200 (Wed, 06 Jul 2011) $
// Id : $Id: model_copula_module.i 1991 2011-07-06 10:03:57Z schueller $

%module(package="openturns", docstring="Random vectors and copulas.") model_copula
#pragma SWIG nowarn=302,509
%feature("autodoc","1");

%{
#include "OTconfig.hxx"
#include "OTBase.hxx"
#include "OTModel.hxx"
#include "OTDistribution.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

%import common_module.i
%include TestResult.i
%import base_module.i

/* Uncertainty/Model */
%include DistributionImplementation.i
%include DistributionImplementationFactory.i
%include Distribution.i
%include DistributionFactory.i
%include UsualDistribution.i
%include ContinuousDistribution.i
%include EllipticalDistribution.i
%include NonEllipticalDistribution.i
%include DiscreteDistribution.i
%include CopulaImplementation.i
%include Copula.i
%include ArchimedeanCopula.i
%include SklarCopula.i

/* Uncertainty/Distribution (copulas) */
%include IndependentCopula.i
%include NormalCopula.i
%include NormalCopulaFactory.i
%include FrankCopula.i
%include FrankCopulaFactory.i
%include ClaytonCopula.i
%include ClaytonCopulaFactory.i
%include GumbelCopula.i
%include GumbelCopulaFactory.i
%include ComposedDistribution.i
%include ComposedCopula.i

/* Uncertainty/Model */
%include RandomVectorImplementation.i
%include ConstantRandomVector.i
%include UsualRandomVector.i
%include RandomVector.i
%include CompositeRandomVector.i
%include EventRandomVectorImplementation.i
%include ConditionalRandomVector.i
%include Event.i
%include StandardEvent.i

/* At last we include template definitions */
%include UncertaintyModelCopulaTemplateDefs.i
